/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.ui.charts;

import ch.elexis.core.ui.UiDesk;
import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.ui.GraphicalMessage;
import ch.unibe.iam.scg.archie.ui.charts.AbstractDatasetCreator;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.swt.ChartComposite;

public abstract class AbstractChartComposite
extends Composite
implements IJobChangeListener {
    protected Composite parent;
    protected AbstractDatasetCreator creator;
    private ChartComposite chartComposite;
    private GridData layoutData;

    public AbstractChartComposite(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.layoutData = new GridData(1808);
        this.setLoadingMessage();
        this.setLayout((Layout)layout);
        this.setLayoutData(this.layoutData);
        this.creator = this.initializeCreator();
        this.creator.addJobChangeListener(this);
    }

    protected abstract AbstractDatasetCreator initializeCreator();

    protected abstract JFreeChart initializeChart();

    public void refresh() {
        this.clean();
        this.setLoadingMessage();
        this.creator.schedule();
    }

    public void cancelCreator() {
        this.creator.cancel();
    }

    public void startCreator() {
        this.creator.schedule();
    }

    public AbstractDatasetCreator getCreator() {
        return this.creator;
    }

    public void addJobChangeListener(IJobChangeListener listener) {
        this.creator.addJobChangeListener(listener);
    }

    public void removeJobChangeListener(IJobChangeListener listener) {
        this.creator.removeJobChangeListener(listener);
    }

    private void setLoadingMessage() {
        new GraphicalMessage(this, ArchieActivator.getInstance().getImageRegistry().get("coffee"), Messages.WORKING);
        this.layout();
    }

    private void setEmptyMessage() {
        new GraphicalMessage(this, ArchieActivator.getInstance().getImageRegistry().get("info"), Messages.RESULT_EMPTY);
        this.layout();
    }

    private void clean() {
        if (this.chartComposite != null) {
            this.chartComposite.dispose();
        }
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public void done(IJobChangeEvent event) {
        UiDesk.getDisplaySafe().ifPresent(d -> d.syncExec(() -> {
            this.clean();
            if (this.creator.isDatasetEmpty()) {
                this.setEmptyMessage();
            } else {
                this.chartComposite = new ChartComposite((Composite)this, 0, this.initializeChart());
                this.chartComposite.setLayoutData((Object)this.layoutData);
            }
            this.layout();
        }));
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

