/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.handlers;

import ch.elexis.core.ui.util.SWTHelper;
import ch.unibe.iam.scg.archie.ArchieActivator;
import ch.unibe.iam.scg.archie.Messages;
import ch.unibe.iam.scg.archie.controller.ChartModelManager;
import ch.unibe.iam.scg.archie.controller.ProviderChartFactory;
import ch.unibe.iam.scg.archie.controller.ProviderManager;
import ch.unibe.iam.scg.archie.handlers.ExportHandler;
import ch.unibe.iam.scg.archie.model.ChartModel;
import ch.unibe.iam.scg.archie.ui.views.ChartView;
import ch.unibe.iam.scg.archie.ui.views.StatisticsView;
import ch.unibe.iam.scg.archie.ui.wizards.ChartWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartWizardHandler
extends AbstractHandler {
    private static final int WIZARD_PAGE_HEIGHT = 600;
    private static final int WIZARD_PAGE_WIDTH = 400;
    private StatisticsView view;
    private static Logger log = LoggerFactory.getLogger(ExportHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = activePage.findView("ch.unibe.iam.scg.archie.ui.views.StatisticsView");
        if (!(viewPart instanceof StatisticsView)) {
            log.error("chartWizardHandler: StatisticsView not found");
            return null;
        }
        this.view = (StatisticsView)viewPart;
        if (ProviderManager.getInstance().getProvider() == null && this.view.getResultPanel() == null) {
            SWTHelper.showError((String)(Messages.CHART_WIZARD_TITLE + " " + Messages.ERROR), (String)Messages.ERROR_SELECT_DATA);
        } else {
            ChartWizard chartWizard = new ChartWizard();
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)chartWizard);
            wizardDialog.setPageSize(400, 600);
            wizardDialog.setBlockOnOpen(true);
            wizardDialog.create();
            if (wizardDialog.open() == 0) {
                ChartModel chartModel = chartWizard.getModel();
                ProviderChartFactory.getInstance().setChartModel(chartModel);
                ChartModelManager.getInstance().setChartModel(chartModel);
                this.setExistingViewDirty();
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.unibe.iam.scg.archie.ui.views.ChartView");
                }
                catch (PartInitException e) {
                    ArchieActivator.LOG.log("Could not create the chart view.\n" + e.getLocalizedMessage(), 2);
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void setExistingViewDirty() {
        IViewPart chartView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.unibe.iam.scg.archie.ui.views.ChartView");
        if (chartView instanceof ChartView) {
            ((ChartView)chartView).setDirty();
            System.out.println(chartView.getTitle());
        }
    }
}

