/*
 * Decompiled with CFR 0.152.
 */
package ch.unibe.iam.scg.archie.controller;

import ch.unibe.iam.scg.archie.model.ChartModel;

public class ChartModelManager {
    private static ChartModelManager INSTANCE;
    private ChartModel barChartModel = null;
    private ChartModel pieChartModel = null;

    private ChartModelManager() {
    }

    public static ChartModelManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ChartModelManager();
        }
        return INSTANCE;
    }

    public ChartModel getBarChartModel() {
        return this.barChartModel;
    }

    public void setBarChartModel(ChartModel barChartModel) {
        if (barChartModel.getChartType() != 2) {
            throw new IllegalArgumentException("This method can only be used for bar chart models.");
        }
        this.barChartModel = barChartModel;
    }

    public void setChartModel(ChartModel chartModel) {
        if (chartModel.getChartType() == 1) {
            this.setPieChartModel(chartModel);
        } else if (chartModel.getChartType() == 2) {
            this.setBarChartModel(chartModel);
        } else {
            throw new IllegalArgumentException("The model has to have a valid chart type.");
        }
    }

    public ChartModel getPieChartModel() {
        return this.pieChartModel;
    }

    public void setPieChartModel(ChartModel pieChartModel) {
        if (pieChartModel.getChartType() != 1) {
            throw new IllegalArgumentException("This method can only be used for pie chart models.");
        }
        this.pieChartModel = pieChartModel;
    }

    public boolean hasChartModel(int type) {
        if (type == 1) {
            return this.pieChartModel != null;
        }
        if (type == 2) {
            return this.barChartModel != null;
        }
        return false;
    }

    public boolean hasPieChartModel() {
        return this.hasChartModel(1);
    }

    public boolean hasBarChartModel() {
        return this.hasChartModel(2);
    }

    public void clean() {
        this.barChartModel = null;
        this.pieChartModel = null;
    }
}

