/*
 * Decompiled with CFR 0.152.
 */
package ch.pharmed.phmprescriber;

import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.pharmed.phmprescriber.Barcode;
import ch.pharmed.phmprescriber.Physician;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

class Page
implements Printable {
    private static Font fnt = new Font("Helvetica", 0, 8);
    private static Font fntBold = new Font("Helvetica", 1, 8);
    private static Font fntItalic = new Font("Helvetica", 2, 8);
    private static Font fntTitle = new Font("Helvetica", 1, 11);
    private String PHONE;
    private String FAX;
    private String EAN;
    private String ZSR;
    private String TITLE;
    private String BORN;
    private String REPETITION;
    private static final String PROMO = "https://www.pharmedsolutions.ch";
    private final double LMARGINRATIO = 0.3;
    private final double SPACERATIO = 1.5;
    int Code128Width = 185;
    int Code128Height = 36;
    int QRCodeBorder = 118;
    private Physician ph;
    private Rezept rp;
    private String presID;
    private String QRCode;
    private Patient pat;
    private BufferedImage imgQRCode;
    private BufferedImage imgCode128;
    private int firstProd = 0;
    private int lastProd = 0;
    private ResourceBundle messages;

    public Page(Physician ph, Rezept rp, String presID, String QRCode, Integer firstProductIndex, Integer lastProductIndex) {
        this.ph = ph;
        this.rp = rp;
        this.pat = rp.getPatient();
        this.presID = presID;
        this.QRCode = QRCode;
        this.firstProd = firstProductIndex;
        this.lastProd = lastProductIndex;
        this.messages = ResourceBundle.getBundle("ch.pharmed.phmprescriber.MessagesBundle", new Locale("de", "CH"));
        this.PHONE = this.messages.getString("Page_4");
        this.FAX = this.messages.getString("Page_5");
        this.EAN = this.messages.getString("Page_6");
        this.ZSR = this.messages.getString("Page_7");
        this.TITLE = this.messages.getString("Page_8");
        this.BORN = this.messages.getString("Page_9");
        this.REPETITION = this.messages.getString("Page_10");
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) throws PrinterException {
        double printAreaX = pageFormat.getImageableX();
        double printAreaY = pageFormat.getImageableY();
        FontMetrics metrics = g.getFontMetrics(fnt);
        int intMeasureY = 0;
        int intMarginLeft = (int)Math.round(printAreaX * 0.3);
        int intSpace = (int)Math.round((double)metrics.getHeight() * 1.5);
        int intDefaultHeight = metrics.getHeight();
        int intPageWidth = (int)Math.round(pageFormat.getImageableWidth());
        int pageHeight = (int)Math.round(pageFormat.getImageableHeight());
        metrics = g.getFontMetrics(fntTitle);
        int intSpaceBig = metrics.getHeight();
        Line2D.Double line = new Line2D.Double();
        g.setColor(Color.black);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        g2d.translate(printAreaX, printAreaY);
        line.setLine(0.0, 0.0, 0.0, pageFormat.getHeight() + 500.0);
        g2d.draw(line);
        g.setFont(fntBold);
        metrics = g.getFontMetrics(fntBold);
        g.drawString(this.ph.getTitle() + " " + this.ph.getFirstname() + " " + this.ph.getLastname(), intMarginLeft, intMeasureY += metrics.getHeight());
        g.setFont(fnt);
        metrics = g.getFontMetrics(fnt);
        g.drawString(this.rp.getDate(), intPageWidth - metrics.stringWidth(this.rp.getDate()), intMeasureY);
        g.drawString(this.ph.getSpecialty1(), intMarginLeft, intMeasureY += metrics.getHeight());
        if (this.ph.getSpecialty2().length() > 0) {
            g.drawString(this.ph.getSpecialty2(), intMarginLeft, intMeasureY += intDefaultHeight);
        }
        g.drawString(this.ph.getStreet() + " " + this.ph.getPostbox(), intMarginLeft, intMeasureY += intSpace);
        g.drawString(this.ph.getZip() + " " + this.ph.getCity(), intMarginLeft, intMeasureY += intDefaultHeight);
        intMeasureY += intSpace;
        int phoneWidth = metrics.stringWidth(this.PHONE);
        if (metrics.stringWidth(this.PHONE) < metrics.stringWidth(this.FAX) && this.ph.getFax().length() > 0) {
            phoneWidth = metrics.stringWidth(this.FAX);
        }
        g.drawString(this.PHONE, intMarginLeft, intMeasureY);
        g.drawString(this.ph.getPhone(), intMarginLeft + phoneWidth, intMeasureY);
        if (this.ph.getFax().length() > 0) {
            g.drawString(this.FAX, intMarginLeft, intMeasureY += intDefaultHeight);
            g.drawString(this.ph.getFax(), intMarginLeft + phoneWidth, intMeasureY);
        }
        intMeasureY += intSpace;
        int EANWidth = metrics.stringWidth(this.ZSR);
        if (metrics.stringWidth(this.ZSR) < metrics.stringWidth(this.EAN) && this.ph.getGlnid().length() > 0) {
            EANWidth = metrics.stringWidth(this.EAN);
        }
        g.drawString(this.ZSR, intMarginLeft, intMeasureY);
        g.drawString(this.ph.getZsrid(), intMarginLeft + EANWidth, intMeasureY);
        if (this.ph.getGlnid().length() > 0) {
            g.drawString(this.EAN, intMarginLeft, intMeasureY += intDefaultHeight);
            g.drawString(this.ph.getGlnid(), intMarginLeft + EANWidth, intMeasureY);
        }
        line.setLine(intMarginLeft, intMeasureY += intSpaceBig, pageFormat.getWidth(), intMeasureY);
        g2d.draw(line);
        g.setFont(fntTitle);
        g.drawString(this.TITLE, intMarginLeft, intMeasureY += intSpaceBig + intSpace);
        g.setFont(fntBold);
        g.drawString(this.pat.getName() + " " + this.pat.getVorname(), intMarginLeft, intMeasureY += intSpaceBig + intDefaultHeight);
        metrics = g.getFontMetrics(fntBold);
        int xPat = intMarginLeft + metrics.stringWidth(this.pat.getName() + " " + this.pat.getVorname());
        g.setFont(fnt);
        g.drawString(", " + this.BORN + this.pat.getGeburtsdatum(), xPat, intMeasureY);
        intMeasureY += intSpaceBig + intSpace;
        Hashtable hash = new Hashtable();
        int i = this.firstProd;
        while (i <= this.lastProd) {
            Prescription actualLine = (Prescription)this.rp.getLines().get(i);
            Artikel article = actualLine.getArtikel();
            AttributedString attributedString = new AttributedString("1x " + article.getLabel(), hash);
            attributedString.addAttribute(TextAttribute.FONT, fntBold);
            g2d.setFont(fntBold);
            FontRenderContext frc = g2d.getFontRenderContext();
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            int intstart = attributedCharacterIterator.getBeginIndex();
            int intend = attributedCharacterIterator.getEndIndex();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, frc);
            float width = (float)intPageWidth - (float)intMarginLeft;
            int X = intMarginLeft;
            lineBreakMeasurer.setPosition(intstart);
            while (lineBreakMeasurer.getPosition() < intend) {
                TextLayout textLayout = lineBreakMeasurer.nextLayout(width);
                intMeasureY = (int)((float)intMeasureY + textLayout.getAscent());
                X = intMarginLeft;
                textLayout.draw(g2d, X, intMeasureY);
                intMeasureY = (int)((float)intMeasureY + (textLayout.getDescent() + textLayout.getLeading()));
            }
            Object label = actualLine.getBemerkung();
            if (actualLine.getDosis().length() > 0) {
                label = actualLine.getDosis() + ", " + (String)label;
            }
            if (((String)label).length() == 0) {
                intMeasureY += intSpaceBig * 2;
            } else {
                attributedString = new AttributedString((String)label, hash);
                attributedString.addAttribute(TextAttribute.FONT, fnt);
                g2d.setFont(fnt);
                frc = g2d.getFontRenderContext();
                attributedCharacterIterator = attributedString.getIterator();
                intstart = attributedCharacterIterator.getBeginIndex();
                intend = attributedCharacterIterator.getEndIndex();
                lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, frc);
                lineBreakMeasurer.setPosition(intstart);
                while (lineBreakMeasurer.getPosition() < intend) {
                    int next = lineBreakMeasurer.nextOffset(width);
                    int limit = next;
                    if (limit <= ((String)label).length()) {
                        int k = lineBreakMeasurer.getPosition();
                        while (k < next) {
                            char c = ((String)label).charAt(k);
                            if (c == '\n') {
                                limit = k + 1;
                                break;
                            }
                            ++k;
                        }
                    }
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(width, limit, false);
                    intMeasureY = (int)((float)intMeasureY + textLayout.getAscent());
                    X = intMarginLeft;
                    textLayout.draw(g2d, X, intMeasureY);
                    intMeasureY = (int)((float)intMeasureY + (textLayout.getDescent() + textLayout.getLeading()));
                }
                intMeasureY += intSpaceBig * 2;
            }
            ++i;
        }
        Barcode bc = new Barcode();
        this.imgCode128 = bc.getCode128(this.presID);
        this.imgQRCode = bc.getQRCode(this.QRCode);
        g.setFont(fntBold);
        metrics = g.getFontMetrics(fntBold);
        int xPrescId = intPageWidth - this.Code128Width + Integer.valueOf(Math.round((this.Code128Width - metrics.stringWidth(this.presID)) / 2));
        g.drawString(this.presID, xPrescId, pageHeight);
        g.drawImage(this.imgCode128, intPageWidth - this.Code128Width, pageHeight - this.Code128Height - intDefaultHeight, this.Code128Width, this.Code128Height, null);
        g.drawImage(this.imgQRCode, intMarginLeft, pageHeight - this.QRCodeBorder, this.QRCodeBorder, this.QRCodeBorder, null);
        g.setColor(Color.gray);
        metrics = g.getFontMetrics(fntItalic);
        g.setFont(fntItalic);
        g.drawString(PROMO, Math.round(intMarginLeft + (this.QRCodeBorder - metrics.stringWidth(PROMO)) / 2), pageHeight);
        g.setColor(Color.black);
        g.setFont(fnt);
        return 0;
    }
}

