/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MedNetConfigFormPath
implements Comparable<MedNetConfigFormPath> {
    private static final Pattern csvLinePattern = Pattern.compile("^\"(?<accountID>[^\"]*)\";\"(?<accountTitle>[^\"]*)\";\"(?<accountLastname>[^\"]*)\";\"(?<accountFirstname>[^\"]*)\";\"(?<path>[^\"]*)\"$");
    private String accountID;
    private String accountTitle;
    private String accountLastname;
    private String accountFirstname;
    private Path path;

    public MedNetConfigFormPath(String fileLine) {
        Matcher matcher = csvLinePattern.matcher(fileLine);
        if (matcher.matches()) {
            this.accountID = matcher.group("accountID");
            this.accountTitle = matcher.group("accountTitle");
            this.accountLastname = matcher.group("accountLastname");
            this.accountFirstname = matcher.group("accountFirstname");
            this.path = Paths.get(matcher.group("path"), new String[0]);
        }
    }

    public String getKey() {
        return this.accountID;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public String getAccountTitle() {
        return this.accountTitle;
    }

    public String getAccountLastname() {
        return this.accountLastname;
    }

    public String getAccountFirstname() {
        return this.accountFirstname;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public int compareTo(MedNetConfigFormPath other) {
        if (other == null) {
            return -1;
        }
        if (this.getAccountID() != null && other.getAccountID() == null) {
            return -1;
        }
        if (this.getAccountID() == null && other.getAccountID() != null) {
            return 1;
        }
        return this.getAccountID().compareTo(other.getAccountID());
    }
}

