/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin;

import ch.novcom.elexis.mednet.plugin.MedNetConfigDocumentPath;
import ch.novcom.elexis.mednet.plugin.MedNetConfigFormItem;
import ch.novcom.elexis.mednet.plugin.MedNetConfigFormPath;
import ch.novcom.elexis.mednet.plugin.MedNetSettings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedNet {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MedNet.class.getName());
    private static final Charset OUTPUT_ENCONDING = StandardCharsets.UTF_8;
    private static MedNetSettings settings = new MedNetSettings();

    public static MedNetSettings getSettings() {
        if (settings == null) {
            settings = new MedNetSettings();
        }
        return settings;
    }

    public static void getDocuments() {
        block5: {
            String logPrefix = "getDocuments() - ";
            LOGGER.debug(logPrefix + "start");
            ArrayList<String> command = new ArrayList<String>();
            command.add(MedNet.getSettings().getExePath().toString());
            command.add("-getResults");
            ProcessBuilder probuilder = new ProcessBuilder(command);
            probuilder.directory(MedNet.getSettings().getExePath().getParent().toFile());
            try {
                Process process = probuilder.start();
                int exitValue = 1;
                try {
                    exitValue = process.waitFor();
                    if (exitValue >= 0) {
                        LOGGER.debug(logPrefix + "Successful");
                        break block5;
                    }
                    LOGGER.debug(logPrefix + "Failed");
                }
                catch (InterruptedException ie) {
                    LOGGER.warn(logPrefix + "Has been interrupted");
                }
            }
            catch (IOException ioe) {
                LOGGER.error(logPrefix + "IOException: ", (Throwable)ioe);
            }
        }
    }

    public static void openFormview(Path gdtFile) {
        String logPrefix = "openFormview() - ";
        LOGGER.debug(logPrefix + "start");
        ArrayList<String> command = new ArrayList<String>();
        command.add(MedNet.getSettings().getExePath().toString());
        command.add("-openformview");
        if (gdtFile != null && Files.exists(gdtFile, new LinkOption[0]) && Files.isRegularFile(gdtFile, new LinkOption[0])) {
            command.add("-patientinfo:\"" + gdtFile.toString() + "\"");
        }
        ProcessBuilder probuilder = new ProcessBuilder(command);
        probuilder.directory(MedNet.getSettings().getExePath().getParent().toFile());
        try {
            probuilder.start();
            LOGGER.debug(logPrefix + "done");
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException: ", (Throwable)ioe);
        }
    }

    public static Map<String, Map<String, MedNetConfigFormItem>> listForms() {
        String logPrefix = "listForms() - ";
        LOGGER.debug(logPrefix + "start");
        ArrayList<String> command = new ArrayList<String>();
        command.add(MedNet.getSettings().getExePath().toString());
        command.add("-listForms");
        Path file = null;
        try {
            file = Files.createTempFile("mednet-listform", ".dt", new FileAttribute[0]);
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException creating list form file.", (Throwable)ioe);
            return null;
        }
        command.add("-output:" + file.toString());
        LOGGER.debug(logPrefix + "launch MedNet " + String.join((CharSequence)" ", command));
        ProcessBuilder probuilder = new ProcessBuilder(command);
        probuilder.directory(MedNet.getSettings().getExePath().getParent().toFile());
        int exitValue = -1;
        List<Object> resultStringList = new ArrayList();
        try {
            Process process = probuilder.start();
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn(logPrefix + "Has been interrupted");
            }
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException: ", (Throwable)ioe);
        }
        if (exitValue >= 0) {
            LOGGER.debug(logPrefix + "Successful");
            try {
                resultStringList = Files.readAllLines(file, OUTPUT_ENCONDING);
            }
            catch (IOException | SecurityException ioe) {
                LOGGER.error(logPrefix + "Exception reading configuration File ", (Throwable)ioe);
            }
        } else {
            LOGGER.debug(logPrefix + "Failed");
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException | SecurityException ioe) {
            // empty catch block
        }
        TreeMap<String, Map<String, MedNetConfigFormItem>> result = new TreeMap<String, Map<String, MedNetConfigFormItem>>();
        for (String string : resultStringList) {
            MedNetConfigFormItem item = new MedNetConfigFormItem(string);
            if (!result.containsKey(item.getInstitutionID())) {
                TreeMap institutionMap = new TreeMap();
                result.put(item.getInstitutionID(), institutionMap);
            }
            ((Map)result.get(item.getInstitutionID())).put(item.getFormID(), item);
        }
        return result;
    }

    public static Map<String, MedNetConfigFormPath> export_ConfigForms() {
        String logPrefix = "export_ConfigForms() - ";
        LOGGER.debug(logPrefix + "start");
        ArrayList<String> command = new ArrayList<String>();
        command.add(MedNet.getSettings().getExePath().toString());
        command.add("-export_ConfigForms");
        Path file = null;
        try {
            file = Files.createTempFile("mednet-export_ConfigForms", ".dt", new FileAttribute[0]);
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException creating config form file.", (Throwable)ioe);
            return null;
        }
        command.add("-output:" + file.toString());
        ProcessBuilder probuilder = new ProcessBuilder(command);
        probuilder.directory(MedNet.getSettings().getExePath().getParent().toFile());
        int exitValue = -1;
        List<Object> resultStringList = new ArrayList();
        try {
            Process process = probuilder.start();
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn(logPrefix + "Has been interrupted");
            }
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException: ", (Throwable)ioe);
        }
        if (exitValue >= 0) {
            LOGGER.debug(logPrefix + "Successful");
            try {
                resultStringList = Files.readAllLines(file, OUTPUT_ENCONDING);
            }
            catch (IOException | SecurityException ioe) {
                LOGGER.error(logPrefix + "Exception reading configuration File ", (Throwable)ioe);
            }
        } else {
            LOGGER.debug(logPrefix + "Failed");
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException | SecurityException ioe) {
            // empty catch block
        }
        TreeMap<String, MedNetConfigFormPath> result = new TreeMap<String, MedNetConfigFormPath>();
        for (String string : resultStringList) {
            MedNetConfigFormPath item = new MedNetConfigFormPath(string);
            result.put(item.getAccountID(), item);
            LOGGER.debug(logPrefix + "Form Path loaded: " + item.getAccountID() + " " + item.getAccountLastname() + " " + String.valueOf(item.getPath()));
        }
        return result;
    }

    public static Set<MedNetConfigDocumentPath> export_ConfigResults() {
        String logPrefix = "export_ConfigResults() - ";
        LOGGER.debug(logPrefix + "start");
        ArrayList<String> command = new ArrayList<String>();
        command.add(MedNet.getSettings().getExePath().toString());
        command.add("-export_ConfigResults");
        Path file = null;
        try {
            file = Files.createTempFile("mednet-export_ConfigResults", ".dt", new FileAttribute[0]);
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException creating config result file.", (Throwable)ioe);
            return null;
        }
        command.add("-output:" + file.toString());
        ProcessBuilder probuilder = new ProcessBuilder(command);
        probuilder.directory(MedNet.getSettings().getExePath().getParent().toFile());
        int exitValue = -1;
        List<Object> resultStringList = new ArrayList();
        try {
            Process process = probuilder.start();
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn(logPrefix + "Has been interrupted");
            }
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException: ", (Throwable)ioe);
        }
        if (exitValue >= 0) {
            LOGGER.debug(logPrefix + "Successful");
            try {
                resultStringList = Files.readAllLines(file, OUTPUT_ENCONDING);
            }
            catch (IOException | SecurityException ioe) {
                LOGGER.error(logPrefix + "Exception reading configuration File ", (Throwable)ioe);
            }
        } else {
            LOGGER.debug(logPrefix + "Failed");
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException | SecurityException ioe) {
            // empty catch block
        }
        TreeSet<MedNetConfigDocumentPath> result = new TreeSet<MedNetConfigDocumentPath>();
        for (String string : resultStringList) {
            MedNetConfigDocumentPath item = new MedNetConfigDocumentPath(string);
            result.add(item);
            LOGGER.debug(logPrefix + "Document Path loaded: " + item.getAccountID() + " " + item.getAccountLastname() + " " + item.getInstitutionID() + " " + item.getInstitutionName() + " " + String.valueOf(item.getPath()));
        }
        return result;
    }
}

