/*
 * Decompiled with CFR 0.152.
 */
package ch.novcom.elexis.mednet.plugin.ui.commands;

import at.medevit.elexis.gdt.messages.GDTSatzNachricht6301;
import at.medevit.elexis.gdt.tools.GDTSatzNachrichtHelper;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Patient;
import ch.novcom.elexis.mednet.plugin.MedNet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFormView
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OpenFormView.class.getName());
    private static Charset GDT_ENCODING = Charset.forName("ISO-8859-1");
    public static final String ID = "ch.novcom.elexis.mednet.plugin.ui.commands.openformview";
    protected static final SimpleDateFormat fromDatabase = new SimpleDateFormat("dd.MM.yyyy");
    protected static final SimpleDateFormat toGDT = new SimpleDateFormat("ddMMyyyy");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String logPrefix = "execute() - ";
        Patient pat = null;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        IStructuredSelection strucSelection = (IStructuredSelection)selection;
        if (selection != null & selection instanceof IStructuredSelection) {
            pat = (Patient)strucSelection.getFirstElement();
        }
        String configuredGDTId = CoreHub.localCfg.get("GDT/Identity", "");
        if (pat == null) {
            pat = ElexisEventDispatcher.getSelectedPatient();
        }
        if (pat == null) {
            return null;
        }
        String socialSecurityNumber = pat.getXid("www.ahv.ch/xid");
        String birthdate = "";
        try {
            birthdate = toGDT.format(fromDatabase.parse(pat.getGeburtsdatum()));
        }
        catch (ParseException pe) {
            LOGGER.error(logPrefix + "Unable to parse birthdate " + pat.getGeburtsdatum());
        }
        GDTSatzNachricht6301 gdt6301 = new GDTSatzNachricht6301(pat.get("PatientNr"), pat.getName(), pat.getVorname(), birthdate, null, pat.get("Titel"), socialSecurityNumber, pat.get("Plz") + " " + pat.get("Ort"), pat.get("Strasse"), null, GDTSatzNachrichtHelper.bestimmeGeschlechtsWert((String)pat.get("Geschlecht")), null, null, null, null, configuredGDTId, "2", "02.10");
        File file = null;
        try {
            file = File.createTempFile("mednet-" + pat.get("PatientNr") + "-", ".gdt");
            file.deleteOnExit();
            Files.write(file.toPath(), String.join((CharSequence)"\n", gdt6301.getMessage()).getBytes(GDT_ENCODING), new OpenOption[0]);
        }
        catch (IOException ioe) {
            LOGGER.error(logPrefix + "IOException creating gdtFile.", (Throwable)ioe);
            MedNet.openFormview(null);
            return null;
        }
        MedNet.openFormview(file.toPath());
        return null;
    }
}

