/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.elexis.directories;

public class HtmlParser {
    private final StringBuffer htmlText;
    private int currentPos = 0;

    public HtmlParser(String htmlText) {
        this.htmlText = new StringBuffer(htmlText);
    }

    public void reset() {
        this.currentPos = 0;
    }

    public boolean startsWith(String prefix) {
        if (prefix == null) {
            return false;
        }
        return this.htmlText.substring(this.currentPos, this.currentPos + prefix.length()).startsWith(prefix);
    }

    public boolean moveTo(String keyString) {
        int newPos = this.getNextPos(keyString);
        if (newPos >= 0) {
            this.currentPos = newPos + keyString.length();
            this.display(this.currentPos);
            return true;
        }
        return false;
    }

    public String getTail() {
        return this.htmlText.substring(this.currentPos, this.htmlText.length());
    }

    public String extractTo(String endKeyString) {
        int newPos = this.getNextPos(endKeyString);
        String text = "";
        if (newPos >= 0) {
            text = this.htmlText.substring(this.currentPos, newPos);
            this.currentPos = newPos + endKeyString.length();
            this.display(this.currentPos);
        }
        return text;
    }

    private void display(int pos) {
    }

    public String extract(String startKeyString, String endKeyString) {
        if (this.moveTo(startKeyString)) {
            return this.extractTo(endKeyString);
        }
        return "";
    }

    public int getNextPos(String keyString, int pos) {
        return this.htmlText.indexOf(keyString, pos);
    }

    public int getNextPos(String keyString) {
        return this.getNextPos(keyString, this.currentPos);
    }
}

