/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.elexis.directories.views;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.medshare.elexis.directories.KontaktEntry;
import ch.medshare.elexis.directories.views.Messages;
import ch.medshare.elexis.directories.views.WeisseSeitenSearchForm;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class WeisseSeitenSearchView
extends ViewPart {
    private TableViewer kontakteTableViewer;
    private Text searchInfoText;
    private Action newPatientAction;
    private Action newKontaktAction;
    WeisseSeitenSearchForm searchForm;

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        parent.setLayout((Layout)new GridLayout(1, false));
        this.searchForm = new WeisseSeitenSearchForm(parent, 0);
        this.searchForm.addResultChangeListener(new Listener(){

            public void handleEvent(Event event) {
                WeisseSeitenSearchView.this.showResult();
            }
        });
        Composite listArea = new Composite(parent, 0);
        listArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        listArea.setLayout((Layout)new GridLayout(1, false));
        this.searchInfoText = new Text(listArea, 0);
        this.searchInfoText.setEnabled(false);
        this.searchInfoText.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Table table = new Table(listArea, 68098);
        TableColumn nameTc = new TableColumn(table, 0x1000000);
        nameTc.setText(Messages.WeisseSeitenSearchView_header_Name);
        nameTc.setWidth(250);
        TableColumn adrTc = new TableColumn(table, 16384);
        adrTc.setText(Messages.WeisseSeitenSearchView_header_Adresse);
        adrTc.setWidth(140);
        TableColumn plzTc = new TableColumn(table, 16384);
        plzTc.setText(Messages.WeisseSeitenSearchView_header_Plz);
        plzTc.setWidth(40);
        TableColumn ortTc = new TableColumn(table, 16384);
        ortTc.setText(Messages.WeisseSeitenSearchView_header_Ort);
        ortTc.setWidth(150);
        TableColumn telTc = new TableColumn(table, 16384);
        telTc.setText(Messages.WeisseSeitenSearchView_header_Tel);
        telTc.setWidth(90);
        table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.kontakteTableViewer = new TableViewer(table);
        this.kontakteTableViewer.setContentProvider((IContentProvider)new WhitePageContentProvider());
        this.kontakteTableViewer.setLabelProvider((IBaseLabelProvider)new WhitePageLabelProvider());
        this.kontakteTableViewer.setSorter((ViewerSorter)new KontaktSorter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.kontakteTableViewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void showResult() {
        try {
            this.kontakteTableViewer.setInput(this.searchForm.getKontakte());
            this.searchInfoText.setText(this.searchForm.getSearchInfoText());
            if (this.kontakteTableViewer.getTable().getItems().length > 0) {
                this.kontakteTableViewer.getTable().select(0);
            }
            this.kontakteTableViewer.getTable().setFocus();
        }
        catch (Exception e) {
            this.showMessage(e.getMessage());
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WeisseSeitenSearchView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.kontakteTableViewer.getControl());
        this.kontakteTableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.kontakteTableViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.newKontaktAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.newPatientAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.newKontaktAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.newPatientAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newKontaktAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.newPatientAction);
    }

    private void openPatientenDialog() {
        StructuredSelection selection = (StructuredSelection)this.kontakteTableViewer.getSelection();
        if (!selection.isEmpty()) {
            for (KontaktEntry selectedKontakt : selection) {
                this.searchForm.openPatientenDialog(selectedKontakt);
            }
        }
    }

    private void openKontaktDialog() {
        StructuredSelection selection = (StructuredSelection)this.kontakteTableViewer.getSelection();
        if (!selection.isEmpty()) {
            for (KontaktEntry selectedKontakt : selection) {
                this.searchForm.openKontaktDialog(selectedKontakt);
            }
        }
    }

    private void makeActions() {
        this.newPatientAction = new Action(){

            public void run() {
                WeisseSeitenSearchView.this.openPatientenDialog();
            }
        };
        this.newPatientAction.setText(Messages.WeisseSeitenSearchView_popup_newPatient);
        this.newPatientAction.setToolTipText(Messages.WeisseSeitenSearchView_tooltip_newPatient);
        this.newPatientAction.setImageDescriptor(Images.IMG_PERSON_ADD.getImageDescriptor());
        this.newKontaktAction = new Action(){

            public void run() {
                WeisseSeitenSearchView.this.openKontaktDialog();
            }
        };
        this.newKontaktAction.setText(Messages.WeisseSeitenSearchView_popup_newKontakt);
        this.newKontaktAction.setToolTipText(Messages.WeisseSeitenSearchView_tooltip_newKontakt);
        this.newKontaktAction.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
    }

    private void hookDoubleClickAction() {
        this.kontakteTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WeisseSeitenSearchView.this.newKontaktAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.kontakteTableViewer.getControl().getShell(), (String)"ch.elexis.WeiSeitSearch", (String)message);
    }

    public void setFocus() {
        this.kontakteTableViewer.getControl().setFocus();
    }

    class KontaktSorter
    extends ViewerSorter {
        KontaktSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s1 = ((KontaktEntry)e1).getName() + ((KontaktEntry)e1).getVorname();
            String s2 = ((KontaktEntry)e2).getName() + ((KontaktEntry)e1).getVorname();
            return s1.compareTo(s2);
        }
    }

    class WhitePageContentProvider
    implements IStructuredContentProvider {
        WhitePageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class WhitePageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        WhitePageLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            KontaktEntry entry = (KontaktEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getName() + " " + entry.getVorname();
                }
                case 1: {
                    return entry.getAdresse();
                }
                case 2: {
                    return entry.getPlz();
                }
                case 3: {
                    return entry.getOrt();
                }
                case 4: {
                    return entry.getTelefon();
                }
            }
            return "-";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

