/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.connect.abacusjunior.packages;

import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.LabItemTyp;
import ch.medshare.connect.abacusjunior.Messages;
import ch.rgw.tools.TimeTool;
import java.util.ResourceBundle;

public class Value {
    private static final String BUNDLE_NAME = "ch.medshare.connect.abacusjunior.packages.valuetexts";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("ch.medshare.connect.abacusjunior.packages.valuetexts");
    ILaboratory _myLab;
    String _shortName;
    String _longName;
    String _unit;
    ILabItem _labItem;
    String _refMann;
    String _refFrau;

    private static String getString(String paramName, String key) {
        return RESOURCE_BUNDLE.getString(paramName + "." + key);
    }

    public static Value getValue(String paramName) {
        return new Value(paramName);
    }

    public String get_shortName() {
        return this._shortName;
    }

    public String get_longName() {
        return this._longName;
    }

    Value(String paramName) {
        this._shortName = Value.getString(paramName, "kuerzel");
        this._longName = Value.getString(paramName, "text");
        this._unit = Value.getString(paramName, "unit");
        this._refMann = Value.getString(paramName, "refM");
        this._refFrau = Value.getString(paramName, "refF");
    }

    private void initialize() {
        this._myLab = LabImportUtilHolder.get().getOrCreateLabor(Messages.AbacusJunior_Value_LabKuerzel);
        this._labItem = LabImportUtilHolder.get().getLabItem(this._shortName, this._myLab);
        if (this._labItem == null) {
            this._labItem = LabImportUtilHolder.get().createLabItem(this._shortName, this._longName, this._myLab, this._refMann, this._refFrau, this._unit, LabItemTyp.NUMERIC, Messages.AbacusJunior_Value_LabName, "50");
        }
    }

    public TransientLabResult fetchValue(IPatient patient, String value, String flags, TimeTool date) {
        if (this._labItem == null) {
            this.initialize();
        }
        if (flags == null || flags.isEmpty()) {
            return new TransientLabResult.Builder(patient, this._myLab, this._labItem, value).date(date).build(LabImportUtilHolder.get());
        }
        String comment = "";
        int resultFlags = 0;
        if (flags.equals("1")) {
            resultFlags |= 1;
        }
        if (flags.equals("2")) {
            resultFlags |= 1;
        }
        if (flags.equals("*") || flags.equals("E")) {
            comment = Messages.AbacusJunior_Value_Error;
        }
        return new TransientLabResult.Builder(patient, this._myLab, this._labItem, value).date(date).comment(comment).flags(Integer.valueOf(resultFlags)).build(LabImportUtilHolder.get());
    }
}

