/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.lmz.risch.laborder.gdt;

import ch.itmed.lmz.risch.laborder.data.PatientData;

public final class GdtBody {
    private String number;
    private String lastName;
    private String firstName;
    private String birthDate;
    private String street;
    private String sex;
    private String zip;
    private String city;
    private String country;
    private String costObjectName;
    private String insurancePolicyNumber;
    private String insuranceType;
    private PatientData patientData;

    public GdtBody(String formId) throws UnsupportedOperationException {
        this.patientData = formId.equals("012.051.001") ? new PatientData(true) : new PatientData(false);
        this.setNumber();
        this.setLastName();
        this.setFirstName();
        this.setBirthDate();
        this.setStreet();
        this.setSex();
        this.setZip();
        this.setCity();
        this.setCountry();
        this.setCostObjectName();
        this.setInsurancePolicyNumber();
        this.setInsuranceType();
    }

    private void setNumber() {
        this.number = this.gdtFormatter(this.patientData.getNumber(), "3000");
    }

    private void setLastName() {
        this.lastName = this.gdtFormatter(this.patientData.getLastName(), "3101");
    }

    private void setFirstName() {
        this.firstName = this.gdtFormatter(this.patientData.getFirstName(), "3102");
    }

    private void setBirthDate() {
        this.birthDate = this.gdtFormatter(this.patientData.getBirthDate(), "3103");
    }

    private void setStreet() {
        this.street = this.gdtFormatter(this.patientData.getStreet(), "3107");
    }

    private void setSex() {
        this.sex = this.gdtFormatter(this.patientData.getSex(), "3110");
    }

    private void setZip() {
        this.zip = this.gdtFormatter(this.patientData.getZip(), "3112");
    }

    private void setCity() {
        this.city = this.gdtFormatter(this.patientData.getCity(), "3113");
    }

    private void setCountry() {
        this.country = this.gdtFormatter(this.patientData.getCountry(), "3114");
    }

    private void setCostObjectName() {
        this.costObjectName = this.gdtFormatter(this.patientData.getCostObjectName(), "0202");
    }

    private void setInsurancePolicyNumber() {
        this.insurancePolicyNumber = this.gdtFormatter(this.patientData.getInsurancePolicyNumber(), "3119");
    }

    private void setInsuranceType() {
        this.insuranceType = this.gdtFormatter(this.patientData.getInsuranceType(), "6331");
    }

    public String gdtFormatter(String data, String gdtCode) {
        String gdtSizeMask = "000";
        String payload = gdtCode + data + "\r\n";
        int gdtStringLength = payload.length() + 3;
        String fullGdtString = gdtSizeMask.substring(0, gdtSizeMask.length() - Integer.toString(gdtStringLength).length()) + gdtStringLength + payload;
        return fullGdtString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("0228200Obj_Kopfdaten\r\n");
        sb.append("921803.00\r\n");
        sb.append("01082013\r\n");
        sb.append("0178200Obj_Patient\r\n");
        sb.append(this.number);
        sb.append(this.lastName);
        sb.append(this.firstName);
        sb.append(this.birthDate);
        sb.append(this.street);
        sb.append(this.sex);
        sb.append(this.zip);
        sb.append(this.city);
        sb.append(this.country);
        sb.append("011820111\r\n");
        sb.append("0226330Obj_Kostentr\u00e4ger\r\n");
        sb.append(this.costObjectName);
        sb.append(this.insurancePolicyNumber);
        sb.append(this.insuranceType);
        sb.append("01082015\r\n");
        sb.append("011820222\r\n");
        return sb.toString();
    }
}

