/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.lmz.risch.laborder.data;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.itmed.lmz.risch.laborder.ui.CaseWindow;
import ch.itmed.lmz.risch.laborder.ui.MessageBoxUtil;
import java.util.ArrayList;
import java.util.Arrays;

public final class PatientData {
    private Patient patient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
    private Fall fall;

    public PatientData(boolean loadCase) throws UnsupportedOperationException {
        if (loadCase) {
            this.getCase();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getCase() throws UnsupportedOperationException {
        ArrayList<Fall> cases = new ArrayList<Fall>(Arrays.asList(this.patient.getFaelle()));
        cases.removeIf(fall -> !fall.isOpen());
        if (cases.size() > 1) {
            int caseIndex = new CaseWindow().open(cases);
            if (caseIndex > 0) {
                this.fall = cases.get(caseIndex);
                return;
            }
            MessageBoxUtil.showErrorDialog("Kein Fall ausgew\u00e4hlt", "Es wurde kein g\u00fcltiger Fall ausgew\u00e4hlt");
            throw new UnsupportedOperationException("No open case for patient found");
        }
        if (cases.size() == 1) {
            this.fall = cases.get(0);
            return;
        }
        MessageBoxUtil.showErrorDialog("Kein offener Fall vorhanden", "F\u00fcr den aktuellen Patienten gibt es keinen offenen Fall");
        throw new UnsupportedOperationException("No open case for patient found");
    }

    public String getNumber() {
        return this.patient.get("PatientNr");
    }

    public String getLastName() {
        return this.patient.getName();
    }

    public String getFirstName() {
        return this.patient.getVorname();
    }

    public String getBirthDate() {
        return this.patient.getGeburtsdatum().replace(".", "");
    }

    public String getStreet() {
        return this.patient.get("Strasse");
    }

    public String getSex() {
        if (this.patient.getGeschlecht().equals("m")) {
            return "1";
        }
        return "2";
    }

    public String getZip() {
        return this.patient.get("Plz");
    }

    public String getCity() {
        return this.patient.get("Ort");
    }

    public String getCountry() {
        return this.patient.get("Land");
    }

    public String getCostObjectName() {
        Kontakt kontakt;
        if (this.fall != null && (kontakt = this.fall.getRequiredContact("Kostentr\u00e4ger")) != null) {
            return kontakt.get("Bezeichnung1");
        }
        return "";
    }

    public String getInsurancePolicyNumber() {
        if (this.fall != null) {
            return this.fall.getRequiredString("Versicherungsnummer").isEmpty() ? this.fall.getRequiredString("Unfallnummer") : this.fall.getRequiredString("Versicherungsnummer");
        }
        return "";
    }

    public String getInsuranceType() {
        if (this.fall != null) {
            String insuranceType = this.fall.getAbrechnungsSystem();
            if (insuranceType.equals("KVG")) {
                return "0";
            }
            if (insuranceType.equals("VVG")) {
                return "1";
            }
            if (insuranceType.equals("UVG")) {
                return "2";
            }
            if (insuranceType.equals("IV")) {
                return "3";
            }
            if (insuranceType.equals("MV")) {
                return "4";
            }
            return "";
        }
        return "";
    }
}

