/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.elements;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.itmed.fop.printing.barcode.BarcodeCreator;
import ch.itmed.fop.printing.data.PatientData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PatientElement {
    public static Element create(Document doc, boolean loadFromAgenda) throws Exception {
        return PatientElement.create(doc, loadFromAgenda, false, null);
    }

    public static Element create(Document doc, boolean loadFromAgenda, boolean useLegalGuardian, IPatient patient) throws Exception {
        String[] addressParts;
        PatientData pd = new PatientData(useLegalGuardian);
        if (loadFromAgenda) {
            pd.loadFromAgenda();
        } else {
            pd.load(patient);
        }
        Element p = doc.createElement("Patient");
        Element c = doc.createElement("FirstName");
        c.appendChild(doc.createTextNode(pd.getFirstName()));
        p.appendChild(c);
        c = doc.createElement("LastName");
        c.appendChild(doc.createTextNode(pd.getLastName()));
        p.appendChild(c);
        c = doc.createElement("Birthdate");
        c.appendChild(doc.createTextNode(pd.getBirthdate()));
        p.appendChild(c);
        c = doc.createElement("Sex");
        c.appendChild(doc.createTextNode(pd.getSex()));
        p.appendChild(c);
        c = doc.createElement("PID");
        c.appendChild(doc.createTextNode(pd.getPid()));
        p.appendChild(c);
        c = doc.createElement("Salutation");
        c.appendChild(doc.createTextNode(pd.getSalutation()));
        p.appendChild(c);
        c = doc.createElement("Title");
        c.appendChild(doc.createTextNode(pd.getTitle()));
        p.appendChild(c);
        c = doc.createElement("PostalCode");
        c.appendChild(doc.createTextNode(pd.getPostalCode()));
        p.appendChild(c);
        c = doc.createElement("City");
        c.appendChild(doc.createTextNode(pd.getCity()));
        p.appendChild(c);
        c = doc.createElement("Country");
        c.appendChild(doc.createTextNode(pd.getCountry()));
        p.appendChild(c);
        c = doc.createElement("Street");
        c.appendChild(doc.createTextNode(pd.getStreet()));
        p.appendChild(c);
        c = doc.createElement("Phone1");
        c.appendChild(doc.createTextNode(pd.getPhone1()));
        p.appendChild(c);
        c = doc.createElement("Phone2");
        c.appendChild(doc.createTextNode(pd.getPhone2()));
        p.appendChild(c);
        c = doc.createElement("MobilePhone");
        c.appendChild(doc.createTextNode(pd.getMobilePhone()));
        p.appendChild(c);
        c = doc.createElement("Email");
        c.appendChild(doc.createTextNode(pd.getEmail()));
        p.appendChild(c);
        c = doc.createElement("CompleteAddress");
        String address = pd.getCompleteAddress();
        String[] stringArray = addressParts = address.split("[\\r\\n]+");
        int n = addressParts.length;
        int n2 = 0;
        while (n2 < n) {
            String addressPart = stringArray[n2];
            Element part = doc.createElement("Part");
            part.appendChild(doc.createTextNode(addressPart));
            c.appendChild(part);
            ++n2;
        }
        p.appendChild(c);
        c = doc.createElement("OrderNumber");
        c.appendChild(doc.createTextNode(pd.getOrderNumber()));
        p.appendChild(c);
        p.setAttribute("barcodeKennung", BarcodeCreator.createInternalCode128fromKontakt((IContact)pd.getPatient()));
        p.setAttribute("barcodeKennungPatNr", BarcodeCreator.createInternalCode128FromKontaktPatNr((IContact)pd.getPatient()));
        return p;
    }
}

