/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.print;

import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.print.PageableRenderer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrintProvider {
    private static Logger logger = LoggerFactory.getLogger(PrintProvider.class);

    private static DocPrintJob createDocPrintJob(String printerName) {
        PrintService[] services;
        PrintService[] printServiceArray = services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printer = printServiceArray[n2];
            if (printer.getName().equals(printerName)) {
                return printer.createPrintJob();
            }
            ++n2;
        }
        return null;
    }

    private static PrintService getPrintServiceByName(String printerName) {
        PrintService[] services;
        PrintService[] printServiceArray = services = PrintServiceLookup.lookupPrintServices(null, null);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService service = printServiceArray[n2];
            if (service.getName().equals(printerName)) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public static void print(InputStream foStream, String printerName) throws IOException, FOPException, TransformerException, PrintException {
        foStream.reset();
        FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
        DocPrintJob printJob = PrintProvider.createDocPrintJob(printerName);
        if (printJob == null) {
            throw new PrintException("Could not find print service for printer [" + printerName + "]");
        }
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        PageableRenderer renderer = new PageableRenderer(userAgent);
        userAgent.setRendererOverride((Renderer)renderer);
        Fop fop = fopFactory.newFop(userAgent);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        StreamSource src = new StreamSource(foStream);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        transformer.transform(src, res);
        SimpleDoc doc = new SimpleDoc(renderer, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        printJob.print(doc, null);
        logger.info("Print job sent to printer: " + printerName);
    }

    public static void printPdf(final InputStream pdf, final String printerName) {
        Job printJob = new Job("Print pdf on " + printerName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PrinterJob job = PrinterJob.getPrinterJob();
                    PrintService printer = PrintProvider.getPrintServiceByName(printerName);
                    if (printer != null) {
                        job.setPrintService(printer);
                        logger.info("Print job sent to printer: " + printerName);
                    } else {
                        logger.warn("Printer not found: " + printerName);
                    }
                    job.setPageable((Pageable)new PDFPageable(PDDocument.load((InputStream)pdf)));
                    job.print();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    logger.error("Error printing pdf ", (Throwable)e);
                    e.printStackTrace();
                    return new Status(4, "ch.itmed.fop.printing.print", "Error printing pdf", (Throwable)e);
                }
            }
        };
        printJob.schedule();
    }
}

