/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.fhir;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.Setting;
import ch.itmed.fop.printing.print.PrintProvider;
import ch.itmed.fop.printing.resources.ResourceProvider;
import ch.itmed.fop.printing.xml.documents.AppointmentCard;
import ch.itmed.fop.printing.xml.documents.FoTransformer;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.name=ch.itmed.fop.printing.fhir.PrintAppointmentCardFunction"})
public class PrintAppointmentCardFunction
implements Function {
    public Object apply(Object input) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Map _input = (Map)input;
        IAppointment appointment = (IAppointment)_input.get("appointment");
        IPatient patient = (IPatient)_input.get("patient");
        IMandator mandator = (IMandator)_input.get("mandator");
        try {
            InputStream xmlDoc = AppointmentCard.create(appointment, patient, mandator);
            InputStream fo = FoTransformer.transformXmlToFo(xmlDoc, ResourceProvider.getXslTemplateFile(0));
            String docName = "AppointmentCard";
            String printerName = Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 0));
            logger.info("Printing document AppointmentCard on printer: " + printerName);
            PrintProvider.print(fo, printerName);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return Status.error((String)e.getMessage());
        }
        return Status.OK_STATUS;
    }
}

