/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.data;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.Setting;
import ch.itmed.fop.printing.resources.Messages;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public final class MedicationData {
    private IPrescription prescription;

    public MedicationData(IPrescription prescription) {
        this.prescription = prescription;
    }

    public void load() throws NullPointerException {
        this.prescription = ContextServiceHolder.get().getTyped(IPrescription.class).orElse(null);
        if (this.prescription == null) {
            throw new NullPointerException("No prescription selected");
        }
    }

    public String getArticleName() {
        return this.prescription.getArticle().getName();
    }

    public String getArticlePrice() {
        return this.prescription.getArticle().getSellingPrice().toString();
    }

    public String getDeliveryDate() {
        LocalDate localDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.YYYY").withZone(ZoneId.systemDefault());
        String currentDate = formatter.format(localDate);
        return currentDate;
    }

    public String getDose() {
        return this.prescription.getDosageInstruction();
    }

    public String[] getDoseArray() {
        return MedicationServiceHolder.get().getSignatureAsStringArray(this.prescription.getDosageInstruction());
    }

    public String getDosageInstructions() {
        return this.prescription.getRemark();
    }

    public String getPrescriptionDate() {
        return this.prescription.getDateFrom() != null ? DateTimeFormatter.ofPattern("dd.MM.yyyy").format(this.prescription.getDateFrom()) : "";
    }

    public String getPrescriptionAuthor() {
        return this.prescription.getPrescriptor() != null ? this.prescription.getPrescriptor().getLabel() : "";
    }

    public String getResponsiblePharmacist() {
        String docName = "MedicationLabel";
        return Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 13));
    }

    public String getMedicationType() {
        EntryType entryType = this.prescription.getEntryType();
        switch (entryType.numericValue()) {
            case 0: {
                return Messages.Medication_FixedMedication;
            }
            case 1: {
                return Messages.Medication_ReserveMedication;
            }
            case 2: {
                return Messages.Medication_Recipe;
            }
            case 3: {
                return Messages.Medication_SelfDispensed;
            }
            case 5: {
                return Messages.Medication_SymptomaticMedication;
            }
        }
        return "";
    }

    public boolean isFreetext() {
        String[] signature = MedicationServiceHolder.get().getSignatureAsStringArray(this.prescription.getDosageInstruction());
        return !signature[0].isEmpty() && signature[1].isEmpty() && signature[2].isEmpty() && signature[3].isEmpty();
    }
}

