/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.console;

import ch.elexis.core.console.AbstractConsoleCommandProvider;
import ch.elexis.core.console.CmdAdvisor;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IModelService;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.Setting;
import ch.itmed.fop.printing.print.PrintProvider;
import ch.itmed.fop.printing.resources.ResourceProvider;
import ch.itmed.fop.printing.xml.documents.AppointmentCard;
import ch.itmed.fop.printing.xml.documents.FoTransformer;
import java.io.InputStream;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommandProvider.class}, immediate=true)
public class ConsoleCommandProvider
extends AbstractConsoleCommandProvider {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;

    @Activate
    public void activate() {
        this.register(((Object)((Object)this)).getClass());
    }

    @CmdAdvisor(description="itmed")
    public void _itmed(CommandInterpreter ci) {
        this.executeCommand("itmed", ci);
    }

    @CmdAdvisor(description="print an appointment sticker")
    public void __itmed_print(String appointmentId, String patientId, String mandatorId) {
        IAppointment appointment = (IAppointment)this.coreModelService.load(appointmentId, IAppointment.class).orElseThrow(() -> new IllegalArgumentException());
        IPatient patient = (IPatient)this.coreModelService.load(patientId, IPatient.class).orElseThrow(() -> new IllegalArgumentException());
        IMandator mandator = (IMandator)this.coreModelService.load(mandatorId, IMandator.class).orElseThrow(() -> new IllegalArgumentException());
        try {
            InputStream xmlDoc = AppointmentCard.create(appointment, patient, mandator);
            InputStream fo = FoTransformer.transformXmlToFo(xmlDoc, ResourceProvider.getXslTemplateFile(0));
            String docName = "AppointmentCard";
            String printerName = Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 0));
            this.logger.info("Printing document AppointmentCard on printer: " + printerName);
            PrintProvider.print(fo, printerName);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

