/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.documents;

import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.rgw.tools.ExHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTransformer {
    private static Logger logger = LoggerFactory.getLogger(PdfTransformer.class);
    public static String DEBUG_MODE = "fop.printing.debug";

    public static InputStream transformXmlToPdf(InputStream xmlInputStream, File xslFile) throws Exception {
        BundleContext bundleContext;
        ServiceReference fopFactoryRef;
        Object source;
        if (!xslFile.exists()) {
            logger.error("XSL template " + xslFile.getAbsolutePath() + " not found");
            throw new IllegalStateException("Druck fehlgeschlagen. Die Vorlage " + xslFile.toString() + " konnte nicht gefunden werden.");
        }
        if (xmlInputStream == null) {
            logger.error("Failed to create XML file");
            return null;
        }
        if (System.getProperty(DEBUG_MODE) != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)xmlInputStream, (OutputStream)bo);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            source = new StreamSource(new ByteArrayInputStream(bo.toByteArray()));
            transformer.transform((Source)source, result);
            System.out.println(result.getWriter().toString());
            xmlInputStream = new ByteArrayInputStream(bo.toByteArray());
        }
        if ((fopFactoryRef = (bundleContext = FrameworkUtil.getBundle(PdfTransformer.class).getBundleContext()).getServiceReference(IFormattedOutputFactory.class)) != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                source = null;
                Object var6_8 = null;
                try (FileInputStream xslInput = new FileInputStream(xslFile);){
                    IFormattedOutputFactory fopFactory = (IFormattedOutputFactory)bundleContext.getService(fopFactoryRef);
                    IFormattedOutput foOutputt = fopFactory.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.XMLSTREAM, IFormattedOutputFactory.OutputType.PDF);
                    foOutputt.transform((Object)xmlInputStream, (InputStream)xslInput, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    if (source == null) {
                        source = throwable;
                    } else if (source != throwable) {
                        ((Throwable)source).addSuppressed(throwable);
                    }
                    throw source;
                }
            }
            catch (IllegalStateException e) {
                ExHandler.handle((Throwable)e);
            }
            bundleContext.ungetService(fopFactoryRef);
            return new ByteArrayInputStream(out.toByteArray());
        }
        return null;
    }
}

