/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.elements;

import ch.elexis.core.model.IPrescription;
import ch.itmed.fop.printing.data.MedicationData;
import ch.itmed.fop.printing.resources.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class MedicationElement {
    public static Element create(Document doc) throws Exception {
        MedicationData md = new MedicationData(null);
        md.load();
        return MedicationElement.createElement(doc, md);
    }

    public static Element create(Document doc, IPrescription iPrescription) {
        MedicationData md = new MedicationData(iPrescription);
        return MedicationElement.createElement(doc, md);
    }

    private static Element createElement(Document doc, MedicationData md) {
        String dosageInstructions;
        Element p = doc.createElement("Medication");
        Element c = doc.createElement("ArticleName");
        c.appendChild(doc.createTextNode(md.getArticleName()));
        p.appendChild(c);
        c = doc.createElement("ArticlePrice");
        c.appendChild(doc.createTextNode(md.getArticlePrice()));
        p.appendChild(c);
        c = doc.createElement("Dose");
        if (md.isFreetext()) {
            c.setAttribute("Freetext", "true");
        } else {
            c.setAttribute("Freetext", "false");
        }
        c.appendChild(doc.createTextNode(md.getDose()));
        p.appendChild(c);
        if (md.getDose() != null && !md.getDose().isEmpty()) {
            c = doc.createElement("DoseTableHeader");
            Element hi = doc.createElement("HeaderItem");
            hi.appendChild(doc.createTextNode(Messages.Medication_Dose_Morning));
            c.appendChild(hi);
            hi = doc.createElement("HeaderItem");
            hi.appendChild(doc.createTextNode(Messages.Medication_Dose_Midday));
            c.appendChild(hi);
            hi = doc.createElement("HeaderItem");
            hi.appendChild(doc.createTextNode(Messages.Medication_Dose_Evening));
            c.appendChild(hi);
            hi = doc.createElement("HeaderItem");
            hi.appendChild(doc.createTextNode(Messages.Medication_Dose_Night));
            c.appendChild(hi);
            p.appendChild(c);
            c = doc.createElement("DoseTableBody");
            String[] stringArray = md.getDoseArray();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                Element di = doc.createElement("DoseItem");
                di.appendChild(doc.createTextNode(i));
                c.appendChild(di);
                ++n2;
            }
            p.appendChild(c);
        }
        if ((dosageInstructions = md.getDosageInstructions()) != null && !dosageInstructions.trim().isEmpty()) {
            c = doc.createElement("DosageInstructions");
            c.appendChild(doc.createTextNode(dosageInstructions));
            p.appendChild(c);
        }
        c = doc.createElement("PrescriptionDate");
        c.appendChild(doc.createTextNode(md.getPrescriptionDate()));
        p.appendChild(c);
        c = doc.createElement("DeliveryDate");
        c.appendChild(doc.createTextNode(md.getDeliveryDate()));
        p.appendChild(c);
        c = doc.createElement("PrescriptionAuthor");
        c.appendChild(doc.createTextNode(md.getPrescriptionAuthor()));
        p.appendChild(c);
        c = doc.createElement("ResponsiblePharmacist");
        c.appendChild(doc.createTextNode(md.getResponsiblePharmacist()));
        p.appendChild(c);
        c = doc.createElement("MedicationType");
        c.appendChild(doc.createTextNode(md.getMedicationType()));
        p.appendChild(c);
        return p;
    }
}

