/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.resources;

import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.Setting;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceProvider {
    private static final String PLUGIN_ID = "ch.itmed.fop.printing";
    private static final String xslResourcePath = "/res/xsl/";
    private static final String xmlResourcePath = "/res/xml/PaperSizes.xml";
    public static final String IMAGE_ELLIPSIS_V_PATH = "/res/icons/vertical.png";
    public static final String IMAGE_ELLIPSIS_H_PATH = "/res/icons/horizontal.png";
    private static Logger logger = LoggerFactory.getLogger(ResourceProvider.class);

    public static File getXslTemplateFile(int docId) {
        String docName = PreferenceConstants.getDocumentName(docId);
        Setting.getBoolean(docName, PreferenceConstants.getDocPreferenceConstant(docName, 2));
        if (Setting.getBoolean(docName, PreferenceConstants.getDocPreferenceConstant(docName, 2))) {
            String xslPath = Setting.getString(docName, PreferenceConstants.getDocPreferenceConstant(docName, 1));
            if (xslPath.contains("ch.itmed.fop.printing.ui")) {
                xslPath = xslPath.replaceAll("ch.itmed.fop.printing.ui", PLUGIN_ID);
            }
            return new File(xslPath);
        }
        return ResourceProvider.loadBundleFile(xslResourcePath + docName + ".xsl");
    }

    public static File loadBundleFile(String path) {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL url = bundle.getEntry(path);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            logger.error("Could not locate bundle file at " + path, (Throwable)e);
        }
        String bundleLocation = url.getPath();
        return new File(bundleLocation);
    }

    public static String[] getPaperFormats() {
        ArrayList<String> paperSizes = new ArrayList<String>();
        try {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(bundle.getEntry(xmlResourcePath).toString());
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/paperSizes/paperSize");
            NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                paperSizes.add(node.getAttributes().getNamedItem("id").getNodeValue());
                ++i;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return paperSizes.toArray(new String[paperSizes.size()]);
    }

    public static List<String> getPaperFormatValues(String paperFormatName) {
        ArrayList<String> paperFormatValues = new ArrayList<String>();
        try {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(bundle.getEntry(xmlResourcePath).toString());
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/paperSizes/paperSize");
            NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getAttributes().getNamedItem("id").getNodeValue().equals(paperFormatName)) {
                    NodeList childNodeList = node.getChildNodes();
                    int k = 0;
                    while (k < childNodeList.getLength()) {
                        Node childNode = childNodeList.item(k);
                        if (childNode.getNodeType() == 1) {
                            paperFormatValues.add(childNode.getTextContent());
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return paperFormatValues;
    }
}

