/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.documents;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.itmed.fop.printing.xml.documents.DomDocument;
import ch.itmed.fop.printing.xml.documents.PageProperties;
import ch.itmed.fop.printing.xml.elements.ArticlesElement;
import ch.itmed.fop.printing.xml.elements.MandatorElement;
import ch.itmed.fop.printing.xml.elements.PatientElement;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArticleLabel {
    public static InputStream create() throws Exception {
        return ArticleLabel.create(true);
    }

    public static InputStream create(boolean includeMedication) throws Exception {
        Document doc = DomDocument.newDocument();
        Element page = PageProperties.setProperties(doc, "ArticleLabel");
        PageProperties.setCurrentDate(page);
        doc.appendChild(page);
        Element patient = PatientElement.create(doc, false);
        page.appendChild(patient);
        Element mandator = MandatorElement.create(doc, null);
        if (mandator != null) {
            page.appendChild(mandator);
        }
        Element articles = ArticlesElement.create(doc, includeMedication);
        page.appendChild(articles);
        return DomDocument.toInputStream(doc);
    }

    public static InputStream create(IArticle article) throws Exception {
        Document doc = DomDocument.newDocument();
        Optional<IArticleDefaultSignature> signatureOpt = ArticlesElement.getDefaultSignature(article);
        Element page = PageProperties.setProperties(doc, "ArticleLabel");
        if (signatureOpt.isPresent()) {
            IArticleDefaultSignature signature = signatureOpt.get();
            String dosageInstructions = signature.getComment();
            String signatureAsDosisString = signature.getSignatureAsDosisString();
            if (StringUtils.isNotBlank((CharSequence)dosageInstructions) || StringUtils.isNotBlank((CharSequence)signatureAsDosisString)) {
                page = PageProperties.setProperties(doc, "ArticleMedicLabel");
                PageProperties.setCurrentDate(page);
            }
        }
        doc.appendChild(page);
        Element patient = PatientElement.create(doc, false);
        page.appendChild(patient);
        Element mandator = MandatorElement.create(doc, null);
        if (mandator != null) {
            page.appendChild(mandator);
        }
        Element articles = ArticlesElement.create(doc, article);
        page.appendChild(articles);
        return DomDocument.toInputStream(doc);
    }
}

