/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.data;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.Gender;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PatientData {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private IPatient patient;
    private boolean useLegalGuardian;
    private IContact legalGuardian;

    public PatientData(boolean useLegalGuardian) {
        this.useLegalGuardian = useLegalGuardian;
    }

    public void load(IPatient _patient) throws NullPointerException {
        if (_patient != null) {
            this.patient = _patient;
        } else {
            this.patient = ContextServiceHolder.get().getActivePatient().orElse(null);
            if (this.patient == null) {
                throw new NullPointerException("No patient selected");
            }
            if (this.useLegalGuardian) {
                this.initLegalGuardian();
            }
        }
    }

    public void loadFromAgenda() throws NullPointerException {
        Optional iAppointment = ContextServiceHolder.get().getTyped(IAppointment.class);
        if (!iAppointment.isPresent()) {
            throw new NullPointerException("No appointment selected");
        }
        IContact contact = ((IAppointment)iAppointment.get()).getContact();
        if (contact != null && contact.isPatient()) {
            this.patient = (IPatient)CoreModelServiceHolder.get().load(contact.getId(), IPatient.class).get();
        }
        if (this.useLegalGuardian) {
            this.initLegalGuardian();
        }
    }

    private void initLegalGuardian() {
        if (this.patient != null && !this.patient.isDeleted()) {
            this.legalGuardian = this.patient.getLegalGuardian();
        }
    }

    public String getFirstName() {
        if (this.legalGuardian != null && this.legalGuardian.isPerson()) {
            return this.legalGuardian.getDescription2();
        }
        return this.patient.getFirstName();
    }

    public String getLastName() {
        if (this.legalGuardian != null && this.legalGuardian.isPerson()) {
            return this.legalGuardian.getDescription1();
        }
        return this.patient.getLastName();
    }

    public String getBirthdate() {
        LocalDateTime date = this.legalGuardian != null && this.legalGuardian.isPerson() ? this.legalGuardian.asIPerson().getDateOfBirth() : this.patient.getDateOfBirth();
        if (date != null) {
            return date.toLocalDate().format(dateFormat);
        }
        return "";
    }

    public String getSex() {
        if (this.legalGuardian != null && this.legalGuardian.isPerson()) {
            return this.legalGuardian.asIPerson().getGender().getLocaleText();
        }
        return this.patient.asIPerson().getGender().getLocaleText();
    }

    public String getPid() {
        return StringUtils.defaultString((String)this.patient.getCode());
    }

    public String getSalutation() {
        Gender gender;
        String salutation = this.legalGuardian != null && this.legalGuardian.isPerson() ? (Gender.MALE == (gender = this.legalGuardian.asIPerson().getGender()) ? Messages.Contact_SalutationM : Messages.Contact_SalutationF) : (this.patient.getGender().equals((Object)Gender.MALE) ? Messages.Contact_SalutationM : Messages.Contact_SalutationF);
        return salutation;
    }

    public String getTitle() {
        return this.patient.getTitel();
    }

    public String getPostalCode() {
        if (this.legalGuardian != null) {
            return StringUtils.defaultString((String)this.legalGuardian.getZip());
        }
        return StringUtils.defaultString((String)this.patient.getZip());
    }

    public String getCity() {
        if (this.legalGuardian != null) {
            return StringUtils.defaultString((String)this.legalGuardian.getCity());
        }
        return StringUtils.defaultString((String)this.patient.getCity());
    }

    public String getCountry() {
        if (this.legalGuardian != null) {
            return StringUtils.defaultString((String)this.legalGuardian.getCountry().name());
        }
        return StringUtils.defaultString((String)this.patient.getCountry().name());
    }

    public String getStreet() {
        if (this.legalGuardian != null) {
            return StringUtils.defaultString((String)this.legalGuardian.getStreet());
        }
        return StringUtils.defaultString((String)this.patient.getStreet());
    }

    public String getPhone1() {
        if (this.legalGuardian != null) {
            return StringUtils.defaultString((String)this.legalGuardian.getPhone1());
        }
        return StringUtils.defaultString((String)this.patient.getPhone1());
    }

    public String getPhone2() {
        if (this.legalGuardian != null) {
            return StringUtils.defaultString((String)this.legalGuardian.getPhone2());
        }
        return StringUtils.defaultString((String)this.patient.getPhone2());
    }

    public String getMobilePhone() {
        if (this.legalGuardian != null) {
            return StringUtils.defaultString((String)this.legalGuardian.getMobile());
        }
        return StringUtils.defaultString((String)this.patient.getMobile());
    }

    public String getCompleteAddress() {
        if (this.legalGuardian != null) {
            return this.legalGuardian.getPostalAddress();
        }
        return this.patient.getPostalAddress();
    }

    public String getOrderNumber() {
        return this.getAuftragsnummer(this.patient.getCode());
    }

    public String getEmail() {
        if (this.legalGuardian != null) {
            return this.legalGuardian.getEmail();
        }
        return this.patient.getEmail();
    }

    private String getAuftragsnummer(String patCode) {
        String pid = StringTool.addModulo10((String)patCode) + "-" + new TimeTool().toString(8);
        return pid;
    }

    public IPatient getPatient() {
        return this.patient;
    }
}

