/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.data;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.itmed.fop.printing.data.ArticleData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public final class ConsultationData {
    private IEncounter encounter;
    private static List<IBillable> verrechenbar;

    public List<ArticleData> load() throws NullPointerException {
        this.encounter = ContextServiceHolder.get().getTyped(IEncounter.class).orElse(null);
        if (this.encounter == null) {
            throw new NullPointerException("No consultation selected");
        }
        return this.getArticles();
    }

    private List<ArticleData> getArticles() {
        List verrechnet = this.encounter.getBilled();
        verrechenbar = new ArrayList<IBillable>();
        verrechnet.stream().forEach(new VerrechnetConsumer());
        ArrayList<ArticleData> articles = new ArrayList<ArticleData>();
        verrechenbar.stream().filter(v -> v instanceof IArticle).forEach(v -> {
            boolean bl = articles.add(new ArticleData((IArticle)v));
        });
        return articles;
    }

    public List<IPrescription> getMedication() {
        IPatient patient = this.encounter.getCoverage().getPatient();
        List<EntryType> filterList = Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION);
        return patient.getMedication(filterList);
    }

    private static class VerrechnetConsumer
    implements Consumer<IBilled> {
        private VerrechnetConsumer() {
        }

        @Override
        public void accept(IBilled v) {
            int i = 0;
            while ((double)i < v.getAmount()) {
                verrechenbar.add(v.getBillable());
                ++i;
            }
        }
    }
}

