/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.data;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.itmed.fop.printing.data.AppointmentData;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class AppointmentsData {
    private IContact kontakt;
    private List<AppointmentData> appointmentsData;

    public List<AppointmentData> load(List<IAppointment> appointments) throws NullPointerException {
        return this.load(appointments, null);
    }

    public List<AppointmentData> load(List<IAppointment> appointments, IPatient patient) throws NullPointerException {
        if (appointments != null && !appointments.isEmpty()) {
            this.appointmentsData = appointments.stream().map(a -> new AppointmentData((IAppointment)a)).collect(Collectors.toList());
        } else {
            this.kontakt = patient != null ? patient : (IContact)ContextServiceHolder.get().getTyped(IPatient.class).orElse(null);
            if (this.kontakt == null) {
                throw new NullPointerException("No patient selected");
            }
            this.appointmentsData = new ArrayList<AppointmentData>();
            this.querryAppointments(this.kontakt.getId());
        }
        return this.appointmentsData;
    }

    private void querryAppointments(String contactId) {
        IQuery query = CoreModelServiceHolder.get().getQuery(IAppointment.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IAPPOINTMENT__SUBJECT_OR_PATIENT, IQuery.COMPARATOR.EQUALS, (Object)contactId);
        query.and("tag", IQuery.COMPARATOR.GREATER, (Object)LocalDate.now());
        List appointments = query.execute();
        for (IAppointment appointment : appointments) {
            this.appointmentsData.add(new AppointmentData(appointment));
        }
    }

    public String getAgendaArea() {
        return this.appointmentsData.get(0).getAgendaArea();
    }
}

