/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.preferences.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.resources.Messages;
import ch.itmed.fop.printing.resources.PrinterProvider;
import ch.itmed.fop.printing.resources.ResourceProvider;
import ch.itmed.fop.printing.ui.resources.UiResourceProvider;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class TemplatePreferencesDialog
extends TitleAreaDialog {
    private String docName;
    private String textOrientation;
    private String textBarcodeFormat;
    private int selectionIndex;
    private IPreferenceStore settingsStore;
    private Composite templateArea;
    private Composite pageCustomArea;
    private Text xslTemplate;
    private Text pageWidth;
    private Text pageHeight;
    private Text pageMarginTop;
    private Text pageMarginBottom;
    private Text pageMarginLeft;
    private Text pageMarginRight;
    private Text responsiblePharmacist;
    private Combo settingsStoreCombo;
    private Combo printerName;
    private Combo pageTemplateName;
    private Button buttonHorizontal;
    private Button buttonVertical;
    private Button btnElexis;
    private Button btnLaborbarcode;
    private Button xslCustomFlag;
    private Button xslCustomFileDialog;
    private Button pageCustomCheckBox;
    private Group orientationGroup;

    public TemplatePreferencesDialog(Shell parentShell, int selectionIndex) {
        super(parentShell);
        this.selectionIndex = selectionIndex;
        this.docName = PreferenceConstants.getDocumentName((int)selectionIndex);
        this.settingsStore = CoreHub.localCfg.get(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)12), true) ? new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL) : new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.LOCAL);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label description = new Label(composite, 0);
        description.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        new Label(composite, 0).setText(Messages.TemplatePreferences_SettingsStore);
        this.settingsStoreCombo = new Combo(composite, 8);
        this.settingsStoreCombo.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.settingsStoreCombo.setItems(new String[]{Messages.TemplatePreferences_SettingsStore_Global, Messages.TemplatePreferences_SettingsStore_Local});
        this.settingsStoreCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplatePreferencesDialog.this.settingsStore = TemplatePreferencesDialog.this.settingsStoreCombo.getSelectionIndex() == 0 ? new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL) : new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.LOCAL);
                TemplatePreferencesDialog.this.updateValues();
                System.out.println(TemplatePreferencesDialog.this.settingsStoreCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(composite, 258).setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        if (!this.docName.equals("BarCodeLabel")) {
            new Label(composite, 0).setText("Drucker");
        }
        this.printerName = new Combo(composite, 8);
        this.printerName.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.printerName.setItems(PrinterProvider.getAvailablePrinters());
        this.orientationGroup = new Group(composite, 0);
        this.orientationGroup.setLayout((Layout)new RowLayout(256));
        this.orientationGroup.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        new Label((Composite)this.orientationGroup, 0).setText(Messages.TemplatePreferences_TextOrientation);
        this.buttonHorizontal = new Button((Composite)this.orientationGroup, 16);
        this.buttonHorizontal.setText(Messages.TemplatePreferences_TextOrientation_Horizontal);
        this.buttonHorizontal.setImage(UiResourceProvider.loadImage("/res/icons/horizontal.png"));
        this.buttonHorizontal.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        TemplatePreferencesDialog.this.textOrientation = "0";
                    }
                }
            }
        });
        new Label((Composite)this.orientationGroup, 514);
        this.buttonVertical = new Button((Composite)this.orientationGroup, 16);
        this.buttonVertical.setText(Messages.TemplatePreferences_TextOrientation_Vertical);
        this.buttonVertical.setImage(UiResourceProvider.loadImage("/res/icons/vertical.png"));
        this.buttonVertical.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        TemplatePreferencesDialog.this.textOrientation = "90";
                    }
                }
            }
        });
        if (this.docName.equals("BarCodeLabel")) {
            Group grpBarcodeformate = new Group(composite, 0);
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.spacing = 90;
            grpBarcodeformate.setLayout((Layout)rowLayout);
            grpBarcodeformate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
            grpBarcodeformate.setText(Messages.TemplatePreferences_TextBarCodeFormate);
            this.btnElexis = new Button((Composite)grpBarcodeformate, 16);
            this.btnElexis.setText(Messages.TemplatePreferences_TextOrientation_BarcodeElexis);
            this.btnElexis.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            TemplatePreferencesDialog.this.textBarcodeFormat = "0";
                        }
                    }
                }
            });
            this.btnLaborbarcode = new Button((Composite)grpBarcodeformate, 16);
            this.btnLaborbarcode.setText(Messages.TemplatePreferences_TextOrientation_BarcodePat);
            this.btnLaborbarcode.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 13: {
                            TemplatePreferencesDialog.this.textBarcodeFormat = "14";
                        }
                    }
                }
            });
            new Label(composite, 0);
            new Label(composite, 0);
        }
        this.xslCustomFlag = new Button(composite, 32);
        this.xslCustomFlag.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.xslCustomFlag.setText(Messages.TemplatePreferences_XslSetting);
        this.xslCustomFlag.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WindowUtil.handleXslCustomEvent(TemplatePreferencesDialog.this.xslCustomFlag, TemplatePreferencesDialog.this.xslCustomFileDialog, TemplatePreferencesDialog.this.xslTemplate);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.xslTemplate = new Text(composite, 2048);
        this.xslTemplate.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.xslCustomFileDialog = new Button(composite, 8);
        this.xslCustomFileDialog.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.xslCustomFileDialog.setText(Messages.TemplatePreferences_XslFileChooser);
        this.xslCustomFileDialog.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(TemplatePreferencesDialog.this.getShell(), 8192);
                dialog.setFilterNames(new String[]{Messages.TemplatePreferences_XslFileChooser_XslFilter, Messages.TemplatePreferences_XslFileChooser_AllFilesFilter});
                dialog.setFilterExtensions(new String[]{"*.xsl", "*.*"});
                String xslPath = dialog.open();
                if (xslPath != null) {
                    TemplatePreferencesDialog.this.xslTemplate.setText(xslPath);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.pageCustomCheckBox = new Button(composite, 32);
        this.pageCustomCheckBox.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        this.pageCustomCheckBox.setText(Messages.TemplatePreferences_PaperFormat_CheckBox);
        this.pageCustomCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WindowUtil.checkBoxEvent(TemplatePreferencesDialog.this.pageCustomCheckBox, TemplatePreferencesDialog.this.templateArea, TemplatePreferencesDialog.this.pageCustomArea, TemplatePreferencesDialog.this.pageTemplateName.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.templateArea = new Composite(composite, 0);
        this.templateArea.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        this.templateArea.setLayout((Layout)new GridLayout(4, false));
        new Label(this.templateArea, 0).setText(Messages.TemplatePreferences_PaperFormat_Label);
        this.pageTemplateName = new Combo(this.templateArea, 8);
        this.pageTemplateName.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.pageTemplateName.setItems(ResourceProvider.getPaperFormats());
        this.pageTemplateName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WindowUtil.updateCustomPaperFields(TemplatePreferencesDialog.this.pageTemplateName.getText(), TemplatePreferencesDialog.this.pageCustomArea);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pageCustomArea = new Composite(composite, 0);
        this.pageCustomArea.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        this.pageCustomArea.setLayout((Layout)new GridLayout(4, false));
        new Label(this.pageCustomArea, 0).setText(Messages.TemplatePreferences_Page_Width);
        this.pageWidth = new Text(this.pageCustomArea, 2048);
        this.pageWidth.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(this.pageCustomArea, 0).setText(Messages.TemplatePreferences_Page_Height);
        this.pageHeight = new Text(this.pageCustomArea, 2048);
        this.pageHeight.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(this.pageCustomArea, 0).setText(Messages.TemplatePreferences_Page_MarginTop);
        this.pageMarginTop = new Text(this.pageCustomArea, 2048);
        this.pageMarginTop.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(this.pageCustomArea, 0).setText(Messages.TemplatePreferences_Page_MarginBottom);
        this.pageMarginBottom = new Text(this.pageCustomArea, 2048);
        this.pageMarginBottom.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(this.pageCustomArea, 0).setText(Messages.TemplatePreferences_Page_MarginLeft);
        this.pageMarginLeft = new Text(this.pageCustomArea, 2048);
        this.pageMarginLeft.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(this.pageCustomArea, 0).setText(Messages.TemplatePreferences_Page_MarginRight);
        this.pageMarginRight = new Text(this.pageCustomArea, 2048);
        this.pageMarginRight.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        if (this.docName.equals("MedicationLabel")) {
            new Label(composite, 0).setText(Messages.TemplatePreferences_ResponsiblePharmacist);
            this.responsiblePharmacist = new Text(composite, 2048);
            this.responsiblePharmacist.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        }
        this.initializeValues();
        return composite;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.getDocumentName((int)this.selectionIndex) + " " + Messages.TemplatePreferences_Title);
        this.setMessage(Messages.TemplatePreferences_Description);
        this.getShell().setText(Messages.getDocumentName((int)this.selectionIndex) + " " + Messages.TemplatePreferences_Title);
    }

    protected void okPressed() {
        boolean answer;
        if (this.settingsStoreCombo.getSelectionIndex() == 0 && !(answer = SWTHelper.askYesNo((String)"Globale Einstellungen", (String)"Wollen Sie die globalen Einstellungen \u00fcberschreiben?"))) {
            System.out.println("Einstellungen nicht gespeichert!!!!");
            return;
        }
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)0), this.printerName.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)1), this.xslTemplate.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)2), this.xslCustomFlag.getSelection());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)3), this.pageTemplateName.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)4), this.pageCustomCheckBox.getSelection());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)5), this.pageHeight.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)6), this.pageWidth.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)7), this.textOrientation);
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)8), this.pageMarginTop.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)9), this.pageMarginBottom.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)10), this.pageMarginLeft.getText());
        this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)11), this.pageMarginRight.getText());
        if (this.docName.equals("MedicationLabel")) {
            this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)13), this.responsiblePharmacist.getText());
        }
        if (this.docName.equals("BarCodeLabel")) {
            this.settingsStore.setValue(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)14), this.textBarcodeFormat);
        }
        super.okPressed();
    }

    private void initializeValues() {
        this.settingsStoreCombo.select(WindowUtil.setComboSelection(this.settingsStoreCombo, new String[]{Messages.TemplatePreferences_SettingsStore_Global, Messages.TemplatePreferences_SettingsStore_Local}, CoreHub.localCfg.get(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)12), true)));
        this.updateValues();
    }

    private void updateValues() {
        this.printerName.select(WindowUtil.setComboSelection(this.printerName, PrinterProvider.getAvailablePrinters(), this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)0))));
        this.xslCustomFlag.setSelection(this.settingsStore.getBoolean(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)2)));
        this.xslTemplate.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)1)));
        this.pageCustomCheckBox.setSelection(this.settingsStore.getBoolean(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)4)));
        this.pageTemplateName.select(WindowUtil.setComboSelection(this.pageTemplateName, ResourceProvider.getPaperFormats(), this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)3))));
        this.pageWidth.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)6)));
        this.pageHeight.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)5)));
        this.pageMarginTop.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)8)));
        this.pageMarginBottom.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)9)));
        this.pageMarginLeft.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)10)));
        this.pageMarginRight.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)11)));
        if (this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)7)).equals("90")) {
            this.buttonVertical.setSelection(true);
            this.textOrientation = "90";
            this.buttonHorizontal.setSelection(false);
        } else {
            this.buttonHorizontal.setSelection(true);
            this.textOrientation = "0";
            this.buttonVertical.setSelection(false);
        }
        if (this.docName.equals("BarCodeLabel")) {
            if (this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)14)).equals("14")) {
                this.btnLaborbarcode.setSelection(true);
                this.textBarcodeFormat = "14";
                this.btnElexis.setSelection(false);
            } else {
                this.btnElexis.setSelection(true);
                this.textBarcodeFormat = "0";
                this.btnLaborbarcode.setSelection(false);
            }
        }
        if (this.docName.equals("MedicationLabel")) {
            this.responsiblePharmacist.setText(this.settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)this.docName, (int)13)));
        }
        WindowUtil.checkBoxEvent(this.pageCustomCheckBox, this.templateArea, this.pageCustomArea, this.pageTemplateName.getText());
        WindowUtil.handleXslCustomEvent(this.xslCustomFlag, this.xslCustomFileDialog, this.xslTemplate);
    }

    private static final class WindowUtil {
        private WindowUtil() {
        }

        public static void checkBoxEvent(Button checkBox, Composite areaTemplate, Composite areaCustom, String paperFormatName) {
            if (checkBox.getSelection()) {
                WindowUtil.setControlStatus((Control)areaCustom, true);
                WindowUtil.setControlStatus((Control)areaTemplate, false);
            } else {
                WindowUtil.setControlStatus((Control)areaCustom, false);
                WindowUtil.setControlStatus((Control)areaTemplate, true);
                WindowUtil.updateCustomPaperFields(paperFormatName, areaCustom);
            }
        }

        public static void handleXslCustomEvent(Button checkBox, Button xslCustomFileDialog, Text xslTemplate) {
            if (checkBox.getSelection()) {
                xslTemplate.setEnabled(true);
                xslCustomFileDialog.setEnabled(true);
            } else {
                xslTemplate.setEnabled(false);
                xslTemplate.setText("");
                xslCustomFileDialog.setEnabled(false);
            }
        }

        public static void setControlStatus(Control ctrl, boolean enabled) {
            if (ctrl instanceof Combo) {
                ctrl.setEnabled(enabled);
            }
            if (ctrl instanceof Composite) {
                Composite comp = (Composite)ctrl;
                Control[] controlArray = comp.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    WindowUtil.setControlStatus(c, enabled);
                    ++n2;
                }
            } else if (ctrl instanceof Text) {
                ctrl.setEnabled(enabled);
            }
        }

        public static int setComboSelection(Combo combo, String[] items, String item) {
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(item)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public static int setComboSelection(Combo combo, String[] items, boolean item) {
            if (item) {
                return 0;
            }
            return 1;
        }

        public static void updateCustomPaperFields(String paperFormatName, Composite customPaperFieldsArea) {
            List values = ResourceProvider.getPaperFormatValues((String)paperFormatName);
            Iterator iterator = values.iterator();
            Control[] controlArray = customPaperFieldsArea.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Text) {
                    Text t = (Text)c;
                    t.setText((String)iterator.next());
                }
                ++n2;
            }
        }
    }
}

