/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.handlers;

import ch.elexis.core.ui.util.SWTHelper;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.SettingsProvider;
import ch.itmed.fop.printing.print.PrintProvider;
import ch.itmed.fop.printing.resources.Messages;
import ch.itmed.fop.printing.resources.ResourceProvider;
import ch.itmed.fop.printing.xml.documents.PatientLabel;
import ch.itmed.fop.printing.xml.documents.PdfTransformer;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PatientLabelHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(PatientLabelHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            InputStream xmlDoc = PatientLabel.create();
            InputStream pdf = PdfTransformer.transformXmlToPdf((InputStream)xmlDoc, (File)ResourceProvider.getXslTemplateFile((int)4));
            String docName = "PatientLabel";
            IPreferenceStore settingsStore = SettingsProvider.getStore(docName);
            String printerName = settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0));
            logger.info("Printing document PatientLabel on printer: " + printerName);
            PrintProvider.printPdf((InputStream)pdf, (String)printerName);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.equals("No patient selected")) {
                return null;
            }
            SWTHelper.showError((String)Messages.DefaultError_Title, (String)Messages.DefaultError_Message);
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }
}

