/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.widget;

import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.ValueFinding;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.widget.CstCanvas;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class CstVorwertCanvas
extends CstCanvas {
    ValueFinding finding;
    int iPixX = 480;
    int iPixY = 60;
    int xoffBase = 4;
    int yoffBase = 80;
    List<ValueFinding> findings = new ArrayList<ValueFinding>();

    public CstVorwertCanvas(Composite parent, boolean a4Quer, int style) {
        super(parent, style);
        this.setBackground(WHITE);
        this.iPixX = a4Quer ? 810 : 480;
        parent.setSize(this.iPixX, 600);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CstVorwertCanvas.this.paintControl(e);
            }
        });
    }

    public double getHightestValue() {
        double highest = 0.0;
        for (ValueFinding finding : this.getFindings()) {
            if (!(finding.getValue() > highest)) continue;
            highest = finding.getValue();
        }
        return highest;
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setFont(this.fontA);
        if (this.findings == null || this.findings.size() == 0) {
            gc.drawText(Messages.Cst_Text_keine_vorwerte, 20, 20);
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Date dStart = this.findings.get(0).getDateOfFinding();
        Date dEnd = this.findings.get(this.findings.size() - 1).getDateOfFinding();
        long totalSpan = this.getNrOfDaysBetween(dStart, dEnd);
        gc.setBackground(ORANGE);
        gc.setForeground(GRAY);
        gc.drawRectangle(this.xoffBase, this.yoffBase, this.iPixX, 1);
        double dRefFend = this.findings.get(0).getRefFend();
        double dRefMend = this.findings.get(0).getRefMend();
        double dRefFstart = this.findings.get(0).getRefFstart();
        double dRefMstart = this.findings.get(0).getRefMstart();
        double maxRef = Math.max(dRefFend, dRefMend);
        double yFactor = new Double(this.iPixY) / Math.max(this.getHightestValue(), maxRef);
        int iOffYtopM = new Double(dRefMend * yFactor).intValue();
        int iOffYtopF = new Double(dRefFend * yFactor).intValue();
        int iOffYbottomM = new Double(dRefMstart * yFactor).intValue();
        int iOffYbottomF = new Double(dRefFstart * yFactor).intValue();
        gc.setForeground(BRIGHTGREEN);
        if (dRefMend > 0.0) {
            gc.drawLine(this.xoffBase, this.yoffBase - iOffYtopM, this.iPixX, this.yoffBase - iOffYtopM);
            gc.drawText(String.valueOf(dRefMend), this.iPixX + 25, this.yoffBase - iOffYtopM - 6, true);
        }
        if (dRefMstart > 0.0) {
            gc.drawLine(this.xoffBase, this.yoffBase - iOffYbottomM, this.iPixX, this.yoffBase - iOffYbottomM);
            gc.drawText(String.valueOf(dRefMstart), this.iPixX + 25, this.yoffBase - iOffYbottomM - 6, true);
        }
        gc.setForeground(ORANGE);
        if (dRefFend > 0.0) {
            gc.drawLine(this.xoffBase, this.yoffBase - iOffYtopF, this.iPixX, this.yoffBase - iOffYtopF);
            gc.drawText(String.valueOf(dRefFend), this.iPixX + 25, this.yoffBase - iOffYtopF - 6, true);
        }
        if (dRefFstart > 0.0) {
            gc.drawLine(this.xoffBase, this.yoffBase - iOffYbottomF, this.iPixX, this.yoffBase - iOffYbottomF);
            gc.drawText(String.valueOf(dRefFstart), this.iPixX + 25, this.yoffBase - iOffYbottomF - 6, true);
        }
        gc.setBackground(GRAY);
        int xoff = 0;
        double xFactor = new Double(this.iPixX) / new Double(totalSpan);
        gc.setForeground(BLACK);
        int x = 0;
        while (x < this.findings.size()) {
            ValueFinding finding = this.findings.get(x);
            int yoff = 0;
            if (x % 2 == 0) {
                yoff = 8;
            }
            String date = sdf.format(finding.getDateOfFinding());
            gc.drawText(date, this.xoffBase + new Double((double)xoff * xFactor).intValue(), this.yoffBase + yoff + 4, true);
            int corrY = 10;
            if (finding.getParam().toLowerCase().indexOf("neg") <= -1 && finding.getParam().toLowerCase().indexOf("norm") <= -1 && finding.getParam().toLowerCase().indexOf("pos") <= -1 && finding.getParam().toLowerCase().indexOf("+") <= -1 && finding.getParam().toLowerCase().indexOf("-") <= -1) {
                gc.drawText(String.valueOf(finding.getValue()), this.xoffBase + new Double((double)xoff * xFactor).intValue(), this.yoffBase - new Double(finding.getValue() * yFactor).intValue() - corrY, true);
            } else {
                String sDisplay = finding.getParam();
                if (sDisplay.indexOf("-") > -1) {
                    sDisplay = "negativ";
                } else if (sDisplay.indexOf("+") > -1) {
                    sDisplay = "positiv";
                }
                gc.drawText(sDisplay, this.xoffBase + new Double((double)xoff * xFactor).intValue(), this.yoffBase - 12 - corrY, true);
            }
            if (x < this.findings.size() - 1) {
                long lSpan = this.getNrOfDaysBetween(this.findings.get(0).getDateOfFinding(), this.findings.get(x + 1).getDateOfFinding());
                xoff = new Long(lSpan).intValue();
            }
            ++x;
        }
        gc.dispose();
    }

    private long getNrOfDaysBetween(Date dStart, Date dEnd) {
        long diff = dEnd.getTime() - dStart.getTime();
        long days = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
        return days;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.iPixX + 50, 30 + this.yoffBase);
    }

    public ValueFinding getFinding() {
        return this.finding;
    }

    public void setFinding(ValueFinding finding) {
        this.finding = finding;
    }

    public List<ValueFinding> getFindings() {
        return this.findings;
    }

    public void setFindings(List<ValueFinding> findings) {
        this.findings = findings;
        Collections.sort(this.findings, new FindingsComparable());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("");
        for (ValueFinding finding : this.getFindings()) {
            result.append("(" + CstService.getCompactFromDate(finding.getDateOfFinding()) + ":" + finding.getValue() + ")");
        }
        return result.toString();
    }

    public class FindingsComparable
    implements Comparator<ValueFinding> {
        @Override
        public int compare(ValueFinding o1, ValueFinding o2) {
            return o1.getDateOfFinding().compareTo(o2.getDateOfFinding());
        }
    }
}

