/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view.profileeditor;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.data.Brief;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.preferences.CstPreference;
import ch.gpb.elexis.cst.service.DocumentStoreHolder;
import ch.gpb.elexis.cst.view.profileeditor.CstComposite;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public class CstDocumentsComposite
extends CstComposite {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    CstProfile aProfile;
    private Table tableOmnivore;
    TableViewer tableViewerOmnivore;
    private Table tableBrief;
    TableViewer tableViewerBrief;
    private Action doubleClickAction;
    private Action briefLadenAction;
    IViewSite viewsite;
    private int sortColumn = 0;
    private boolean sortReverse = false;
    String sIdentBriefe;
    String sIdentOmnivore;

    public CstDocumentsComposite(Composite parent, IViewSite viewsite) {
        super(parent, 0);
        this.viewsite = viewsite;
        this.sIdentBriefe = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_BRIEFE, (String)"CST");
        this.sIdentOmnivore = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_OMNIVORE, (String)"CST");
        GridLayout gridLayout = new GridLayout(1, true);
        this.setLayout((Layout)gridLayout);
        Label lblOmnivoreDocs = new Label((Composite)this, 0);
        lblOmnivoreDocs.setText(Messages.Cst_Text_cst_documents_tooltip);
        this.tableViewerOmnivore = new TableViewer((Composite)this, 67584);
        this.tableOmnivore = this.tableViewerOmnivore.getTable();
        this.tableOmnivore.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblBriefe = new Label((Composite)this, 0);
        lblBriefe.setText(Messages.Cst_Text_cst_documents_tooltip_omnivore);
        this.tableViewerOmnivore.setContentProvider((IContentProvider)new DocumentsContentProvider());
        this.tableViewerOmnivore.setLabelProvider((IBaseLabelProvider)new DocumentsLabelProvider());
        String[] colLabels = this.getCategoryColumnLabels();
        int[] columnWidth = this.getCategoryColumnWidth();
        CstDocumentsSortListener categorySortListener = new CstDocumentsSortListener();
        TableColumn[] cols = new TableColumn[colLabels.length];
        int i = 0;
        while (i < colLabels.length) {
            cols[i] = new TableColumn(this.tableOmnivore, 0);
            cols[i].setWidth(columnWidth[i]);
            cols[i].setText(colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            cols[i].addSelectionListener((SelectionListener)categorySortListener);
            ++i;
        }
        this.tableOmnivore.setHeaderVisible(true);
        this.tableOmnivore.setLinesVisible(true);
        this.tableViewerOmnivore.setInput((Object)this);
        this.tableViewerOmnivore.setSorter((ViewerSorter)new CstDocumentsSorter());
        this.tableOmnivore.setSize(600, 150);
        GridData gdCstDoc = new GridData();
        gdCstDoc.heightHint = 150;
        gdCstDoc.widthHint = 600;
        this.tableOmnivore.setLayoutData((Object)gdCstDoc);
        this.tableViewerBrief = new TableViewer((Composite)this, 67584);
        this.tableBrief = this.tableViewerBrief.getTable();
        this.tableBrief.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewerBrief.setContentProvider((IContentProvider)new BriefeContentProvider());
        this.tableViewerBrief.setLabelProvider((IBaseLabelProvider)new BriefeLabelProvider());
        String[] colLabelsBrief = this.getCategoryColumnLabelsBrief();
        int[] columnWidthBrief = this.getCategoryColumnWidthBrief();
        CstBriefeSortListener briefeListener = new CstBriefeSortListener();
        TableColumn[] colsBrief = new TableColumn[colLabelsBrief.length];
        int i2 = 0;
        while (i2 < colLabelsBrief.length) {
            colsBrief[i2] = new TableColumn(this.tableBrief, 0);
            colsBrief[i2].setWidth(columnWidthBrief[i2]);
            colsBrief[i2].setText(colLabelsBrief[i2]);
            colsBrief[i2].setData((Object)new Integer(i2));
            colsBrief[i2].addSelectionListener((SelectionListener)briefeListener);
            ++i2;
        }
        this.tableBrief.setHeaderVisible(true);
        this.tableBrief.setLinesVisible(true);
        this.tableViewerBrief.setInput((Object)this);
        this.tableViewerBrief.setSorter((ViewerSorter)new CstBriefeSorter());
        this.tableBrief.setSize(600, 150);
        GridData gdBrief = new GridData();
        gdBrief.heightHint = 150;
        gdBrief.widthHint = 600;
        this.tableBrief.setLayoutData((Object)gdBrief);
        this.createLayout(this);
        this.makeActions();
        this.hookDoubleClickAction();
    }

    private void createLayout(Composite parent) {
    }

    public void getSelection(Map<Object, Object> mAuswahl) {
    }

    public void setSelection(Map<String, Object> mapAuswahl) {
    }

    private void hookDoubleClickAction() {
        this.tableViewerOmnivore.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CstDocumentsComposite.this.doubleClickAction.run();
            }
        });
        this.tableViewerBrief.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CstDocumentsComposite.this.briefLadenAction.run();
            }
        });
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = CstDocumentsComposite.this.tableViewerOmnivore.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                IDocument dh = (IDocument)obj;
                try {
                    File temp = File.createTempFile("csf_", dh.getExtension());
                    Program proggie = Program.findProgram((String)dh.getExtension());
                    if (proggie != null) {
                        proggie.execute(temp.getAbsolutePath());
                    } else if (!Program.launch((String)temp.getAbsolutePath())) {
                        Runtime.getRuntime().exec(temp.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Fehler beim \u00d6ffnen der Datei");
                }
            }
        };
        this.briefLadenAction = new Action(){

            public void run() {
                ISelection selection = CstDocumentsComposite.this.tableViewerBrief.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                Brief brief = (Brief)obj;
                try {
                    TextView tv = (TextView)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.TextView");
                    boolean bl = tv.openDocument(Brief.load((String)brief.getId()));
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
                catch (Exception e) {
                    CstDocumentsComposite.this.log.error("cannot open letter: " + e.getMessage());
                }
            }
        };
    }

    public void clear() {
        this.tableViewerOmnivore.getTable().clearAll();
        this.tableViewerOmnivore.refresh();
        this.tableViewerBrief.refresh();
    }

    private List<Brief> loadCstBriefe() {
        Patient actPat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        if (actPat != null) {
            this.sIdentBriefe = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_BRIEFE, (String)"CST");
            Query qbe = new Query(Brief.class);
            qbe.add("PatientID", "=", actPat.getId());
            ArrayList<Brief> listResult = new ArrayList<Brief>();
            List list = qbe.execute();
            for (Brief brief : list) {
                if (brief.getBetreff().toLowerCase().indexOf(this.sIdentBriefe.toLowerCase()) <= -1) continue;
                listResult.add(brief);
            }
            return listResult;
        }
        return new ArrayList<Brief>();
    }

    private List<IDocument> loadCstdocsOmnivore() {
        this.sIdentOmnivore = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_OMNIVORE, (String)"CST");
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat == null) {
            ArrayList<IDocument> emptyList = new ArrayList<IDocument>();
            return emptyList;
        }
        LinkedList<IDocument> ret = new LinkedList<IDocument>();
        String cat = this.sIdentOmnivore;
        ICategory category = DocumentStoreHolder.get().getCategories().stream().filter(c -> c.getName().equals(cat)).findFirst().orElse(null);
        if (category == null) {
            category = DocumentStoreHolder.get().createCategory(cat);
        }
        List root = DocumentStoreHolder.get().getDocuments(pat.getId(), null, category, null);
        ret.addAll(root);
        return ret;
    }

    private String[] getCategoryColumnLabels() {
        String[] columnLabels = new String[]{"Category", "Date", "Titel", "MIME Type"};
        return columnLabels;
    }

    private String[] getCategoryColumnLabelsBrief() {
        String[] columnLabels = new String[]{"Date", "Betreff", "MIME Type", "Typ"};
        return columnLabels;
    }

    private int[] getCategoryColumnWidth() {
        int[] columnWidth = new int[]{80, 200, 100, 100};
        return columnWidth;
    }

    private int[] getCategoryColumnWidthBrief() {
        int[] columnWidth = new int[]{80, 200, 100, 100};
        return columnWidth;
    }

    class BriefeContentProvider
    implements IStructuredContentProvider {
        BriefeContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            List<Brief> result = CstDocumentsComposite.this.loadCstBriefe();
            return result.toArray();
        }
    }

    class BriefeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        BriefeLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Brief docHandle = (Brief)obj;
            switch (index) {
                case 0: {
                    return docHandle.getDatum();
                }
                case 1: {
                    return docHandle.getBetreff();
                }
                case 2: {
                    return docHandle.getTyp();
                }
                case 3: {
                    return docHandle.getMimeType();
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            return font;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class CstBriefeSortListener
    extends SelectionAdapter {
        CstBriefeSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == CstDocumentsComposite.this.sortColumn) {
                    CstDocumentsComposite.this.sortReverse = !CstDocumentsComposite.this.sortReverse;
                } else {
                    CstDocumentsComposite.this.sortReverse = false;
                    CstDocumentsComposite.this.sortColumn = colNo;
                }
                CstDocumentsComposite.this.tableViewerBrief.refresh();
            }
        }
    }

    class CstBriefeSorter
    extends ViewerSorter {
        CstBriefeSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Brief && e2 instanceof Brief) {
                Brief d1 = (Brief)e1;
                Brief d2 = (Brief)e2;
                String c1 = "";
                String c2 = "";
                switch (CstDocumentsComposite.this.sortColumn) {
                    case 0: {
                        c1 = d1.getDatum();
                        c2 = d2.getDatum();
                        break;
                    }
                    case 1: {
                        c1 = d1.getBetreff();
                        c2 = d2.getBetreff();
                        break;
                    }
                    case 2: {
                        c1 = d1.getTyp();
                        c2 = d2.getTyp();
                    }
                    case 3: {
                        c1 = d1.getMimeType();
                        c2 = d2.getMimeType();
                    }
                }
                if (CstDocumentsComposite.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }

    class CstDocumentsSortListener
    extends SelectionAdapter {
        CstDocumentsSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == CstDocumentsComposite.this.sortColumn) {
                    CstDocumentsComposite.this.sortReverse = !CstDocumentsComposite.this.sortReverse;
                } else {
                    CstDocumentsComposite.this.sortReverse = false;
                    CstDocumentsComposite.this.sortColumn = colNo;
                }
                CstDocumentsComposite.this.tableViewerOmnivore.refresh();
            }
        }
    }

    class CstDocumentsSorter
    extends ViewerSorter {
        CstDocumentsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IDocumentHandle && e2 instanceof IDocumentHandle) {
                IDocumentHandle d1 = (IDocumentHandle)e1;
                IDocumentHandle d2 = (IDocumentHandle)e2;
                String c1 = "";
                String c2 = "";
                switch (CstDocumentsComposite.this.sortColumn) {
                    case 1: {
                        c1 = CstDocumentsComposite.this.dateFormat.format(d1.getCreated());
                        c2 = CstDocumentsComposite.this.dateFormat.format(d2.getCreated());
                        break;
                    }
                    case 2: {
                        c1 = d1.getTitle();
                        c2 = d2.getTitle();
                        break;
                    }
                    case 3: {
                        c1 = d1.getMimeType();
                        c2 = d2.getMimeType();
                    }
                }
                if (CstDocumentsComposite.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }

    class DocumentsContentProvider
    implements IStructuredContentProvider {
        DocumentsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            List<IDocument> result = CstDocumentsComposite.this.loadCstdocsOmnivore();
            return result.toArray();
        }
    }

    class DocumentsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        DocumentsLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            IDocument docHandle = (IDocument)obj;
            switch (index) {
                case 0: {
                    return docHandle.getCategory().getName();
                }
                case 1: {
                    return CstDocumentsComposite.this.dateFormat.format(docHandle.getCreated());
                }
                case 2: {
                    return docHandle.getTitle();
                }
                case 3: {
                    return docHandle.getMimeType();
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            return font;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

