/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.data;

import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.gpb.elexis.cst.data.CstGroup;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.List;

public class CstProfile
extends PersistentObject
implements Comparable<CstProfile> {
    private static final String TABLENAME = "cstprofiles";
    public static final String VERSIONID = "VERSION";
    public static final String VERSION = "3.0.0";
    public static final String GROUP_ITEM_TABLENAME = "cstgroup_profile_joint";
    public static final String ITEMRANKING = "itemsRanking";
    public static final String ANZEIGETYP_RASTER = "Zeitraster";
    public static final String ANZEIGETYP_MINIMAX = "Minimal/Maximal";
    public static final String ANZEIGETYP_EFFEKTIV = "Effektiv";
    public static final String KEY_AUSWAHLBEFUNDE = "Auswahlbefunde";
    private JdbcLink j = CstProfile.getConnection();
    static final String create = "CREATE TABLE cstprofiles (`ID` VARCHAR(25) NOT NULL,\t`lastupdate` BIGINT(20) NULL DEFAULT NULL,\t`deleted` CHAR(1) NULL DEFAULT '0',\t`KontaktID` VARCHAR(25) NULL DEFAULT NULL,\t`MandantID` VARCHAR(25) NULL DEFAULT NULL,\t`Name` VARCHAR(256) NULL DEFAULT NULL, `Description` VARCHAR(256) NULL DEFAULT NULL,\t`Icon` VARCHAR(25) NULL DEFAULT NULL,\t`ValidFrom` CHAR(8) NULL DEFAULT NULL,\t`ValidTo` CHAR(8) NULL DEFAULT NULL,\t`Active` CHAR(1) NULL DEFAULT '1',\t`Template` CHAR(1) NULL DEFAULT '0',\t`OutputHeader` VARCHAR(256) NULL DEFAULT NULL, `AusgabeRichtung` CHAR(1) NULL DEFAULT '0',\t`Auswahlbefunde` BLOB NULL,\t`itemsRanking` BLOB NULL,\t`PlausibilityCheck` char(1) DEFAULT '0', `AnzeigeTyp` VARCHAR(50) NULL DEFAULT NULL,\t`CrawlBack` SMALLINT(6) NULL DEFAULT '180',\t`DaySpan1` SMALLINT(6) NULL DEFAULT '720',\t`DaySpan2` SMALLINT(6) NULL DEFAULT '360',\t`DaySpan3` SMALLINT(6) NULL DEFAULT '0',\t`Therapievorschlag` TEXT NULL,\t`Period1DateStart` CHAR(8) NULL DEFAULT NULL,\t`Period1DateEnd` CHAR(8) NULL DEFAULT NULL,\t`Period2DateStart` CHAR(8) NULL DEFAULT NULL,\t`Period2DateEnd` CHAR(8) NULL DEFAULT NULL,\t`Period3DateStart` CHAR(8) NULL DEFAULT NULL,\t`Period3DateEnd` CHAR(8) NULL DEFAULT NULL,\tPRIMARY KEY (`ID`)) COLLATe='utf8_general_ci' ENGINE=InnoDB; CREATE TABLE `cstgroup_profile_joint` (\t`ID` VARCHAR(25) NULL DEFAULT NULL,\t`deleted` CHAR(1) NULL DEFAULT '0',\t`lastupdate` BIGINT(20) NULL DEFAULT NULL,\t`CstgroupID` VARCHAR(25) NULL DEFAULT NULL,\t`ProfileID` VARCHAR(25) NULL DEFAULT NULL,\t`Comment` TEXT NULL,\tUNIQUE INDEX `CstgroupID` (`CstgroupID`, `ProfileID`)) COLLAte='utf8_general_ci' ENGINE=InnoDB; INSERT INTO cstprofiles (ID, name) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"3.0.0") + ");";

    static {
        CstProfile.addMapping((String)TABLENAME, (String[])new String[]{"name=Name", "description=Description", "icon=Icon", "kontaktId=KontaktID", "mandantId=MandantID", "validFrom=ValidFrom", "validTo=ValidTo", "active=Active", "template=Template", "outputHeader=OutputHeader", "ausgabeRichtung=AusgabeRichtung", "itemsRanking=ItemsRanking", "therapievorschlag=Therapievorschlag", "diagnose=Diagnose", "anzeigeTyp=AnzeigeTyp", "plausibilityCheck=PlausibilityCheck", "crawlBack=CrawlBack", "daySpan1=DaySpan1", "daySpan2=DaySpan2", "daySpan3=DaySpan3", "period1DateStart=Period1DateStart", "period1DateEnd=Period1DateEnd", "period2DateStart=Period2DateStart", "period2DateEnd=Period2DateEnd", "period3DateStart=Period3DateStart", "period3DateEnd=Period3DateEnd", "CstGroups=JOINT:CstgroupID:ProfileID:cstgroup_profile_joint"});
        if (!CstProfile.tableExists((String)TABLENAME)) {
            CstProfile.createOrModifyTable((String)create);
            log.debug("Creating table:\r\n" + create);
        } else {
            CstProfile version = CstProfile.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get("name"));
            if (vi.isOlder(VERSION)) {
                if (version.getName() == null) {
                    version.create(VERSIONID);
                }
                version.set("name", VERSION);
            }
        }
    }

    public CstProfile() {
    }

    public CstProfile(String id) {
        super(id);
    }

    public static CstProfile load(String id) {
        return new CstProfile(id);
    }

    public CstProfile(String name, String description, String icon, String kontaktID, String mandantID, String validFrom, String validTo, String active) {
        CstProfile existing = CstProfile.getByNameAndPatientAndMandant(name, kontaktID, mandantID);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Mapping for origin id [%s] - [%s] already exists can not create multiple instances.", name, description));
        }
        this.create(null);
        this.set("name", name);
        this.set("description", description);
        this.set("icon", icon);
        this.set("kontaktId", kontaktID);
        this.set("mandantId", mandantID);
        this.set("validFrom", validFrom);
        this.set("validTo", validTo);
        this.set("active", active);
    }

    public CstProfile(String name, String description, String icon, String mandantID) {
        CstProfile existing = CstProfile.getByNameAndMandant(name, mandantID);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Mapping for origin id [%s] - [%s] already exists can not create multiple instances.", name, description));
        }
        this.create(null);
        this.set("name", name);
        this.set("description", description);
        this.set("icon", icon);
        this.set("mandantId", mandantID);
    }

    public static CstProfile getByNameAndPatientAndMandant(String name, String kontaktId, String mandantId) {
        Query qbe = new Query(CstProfile.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("name", "=", name);
        qbe.add("kontaktId", "=", kontaktId);
        qbe.add("mandantId", "=", mandantId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", name));
        }
        return (CstProfile)res.get(0);
    }

    public static CstProfile getByNameAndMandant(String name, String mandantId) {
        Query qbe = new Query(CstProfile.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("name", "=", name);
        qbe.add("mandantId", "=", mandantId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", name));
        }
        return (CstProfile)res.get(0);
    }

    public static List<CstProfile> getCstGroups(Patient patient, String mandantId) {
        Query qbe = new Query(CstProfile.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("mandantId", "=", mandantId);
        qbe.add("kontaktId", "=", patient.getId());
        return qbe.execute();
    }

    public static List<CstProfile> getAllProfiles(String mandantId) {
        Query qbe = new Query(CstProfile.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("mandantId", "=", mandantId);
        qbe.orderBy(false, new String[]{"name"});
        return qbe.execute();
    }

    public List<CstGroup> getCstGroups() {
        List lResp = this.getList("CstGroups", new String[0]);
        ArrayList<CstGroup> ret = new ArrayList<CstGroup>(lResp.size());
        for (String[] r : lResp) {
            ret.add(CstGroup.load(r[0]));
        }
        return ret;
    }

    public void removeCstGroup(CstGroup a) {
        for (CstGroup labitem : this.getCstGroups()) {
            if (!labitem.getId().equalsIgnoreCase(a.getId())) continue;
            this.removeFromList("CstGroups", a.getId());
        }
    }

    public void addItem(CstGroup item) {
        if (item != null && item.state() == 3) {
            String exists = this.j.queryString("SELECT CstgroupID FROM cstgroup_profile_joint WHERE ProfileID = " + this.getWrappedId() + " AND CstgroupID = " + item.getWrappedId());
            if (StringTool.isNothing((Object)exists)) {
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO cstgroup_profile_joint (ProfileID, CstgroupID) VALUES (").append(this.getWrappedId()).append(",").append(item.getWrappedId()).append(")");
                this.j.exec(sql.toString());
            } else {
                log.error("CSTGroup " + item.getName() + " already exists in CSTProfile :" + this.getName());
                throw new IllegalArgumentException(String.format("CSTGroup of name [%s] - [%s] already exists", item.getName()));
            }
        }
    }

    public void addItems(List<CstGroup> items) {
        if (items != null) {
            for (CstGroup item : items) {
                this.addItem(item);
            }
        }
    }

    public boolean delete() {
        CstProfile.getConnection().exec("DELETE FROM cstgroup_profile_joint WHERE ProfileID =" + this.getWrappedId());
        return super.delete();
    }

    public void setTherapievorschlag(String therapieVorschlag) {
        this.set("therapievorschlag", therapieVorschlag);
    }

    public String getTherapievorschlag() {
        return this.get("therapievorschlag");
    }

    public void setDiagnose(String diagnose) {
        this.set("diagnose", diagnose);
    }

    public String getDiagnose() {
        return this.get("diagnose");
    }

    public void setPlausibilityCheck(String plausibilitycheck) {
        this.set("plausibilityCheck", plausibilitycheck);
    }

    public String getPlausibilityCheck() {
        return this.get("plausibilityCheck");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getName() {
        return this.get("name");
    }

    public void setAnzeigeTyp(String anzeigeTyp) {
        this.set("anzeigeTyp", anzeigeTyp);
    }

    public String getAnzeigeTyp() {
        return this.get("anzeigeTyp");
    }

    public void setOutputHeader(String outputHeader) {
        this.set("outputHeader", outputHeader);
    }

    public String getOutputHeader() {
        return this.get("outputHeader");
    }

    public void setAusgabeRichtung(boolean ausgabeRichtung) {
        if (ausgabeRichtung) {
            this.set("ausgabeRichtung", "1");
        } else {
            this.set("ausgabeRichtung", "0");
        }
    }

    public boolean getAusgabeRichtung() {
        return !this.get("ausgabeRichtung").equals("0");
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public String getDescription() {
        return this.get("description");
    }

    public void setKontaktId(String kontaktId) {
        this.set("kontaktId", kontaktId);
    }

    public String getKontaktId() {
        return this.get("kontaktId");
    }

    public void setMandantId(String mandantId) {
        this.set("mandantId", mandantId);
    }

    public String getMandantId() {
        return this.get("mandantId");
    }

    public void setCrawlBack(int crawlBack) {
        this.setInt("crawlBack", crawlBack);
    }

    public int getCrawlBack() {
        return this.getInt("crawlBack");
    }

    public void setDaySpan1(int daySpan1) {
        this.setInt("daySpan1", daySpan1);
    }

    public int getDaySpan1() {
        return this.getInt("daySpan1");
    }

    public void setDaySpan2(int daySpan2) {
        this.setInt("daySpan2", daySpan2);
    }

    public int getDaySpan2() {
        return this.getInt("daySpan2");
    }

    public void setDaySpan3(int daySpan3) {
        this.setInt("daySpan3", daySpan3);
    }

    public int getDaySpan3() {
        return this.getInt("daySpan3");
    }

    public void setPeriod1DateStart(String period1DateStart) {
        this.set("period1DateStart", period1DateStart);
    }

    public String getPeriod1DateStart() {
        return this.get("period1DateStart");
    }

    public void setPeriod1DateEnd(String period1DateEnd) {
        this.set("period1DateEnd", period1DateEnd);
    }

    public String getPeriod1DateEnd() {
        return this.get("period1DateEnd");
    }

    public void setPeriod2DateStart(String period2DateStart) {
        this.set("period2DateStart", period2DateStart);
    }

    public String getPeriod2DateStart() {
        return this.get("period2DateStart");
    }

    public void setPeriod2DateEnd(String period2DateEnd) {
        this.set("period2DateEnd", period2DateEnd);
    }

    public String getPeriod2DateEnd() {
        return this.get("period2DateEnd");
    }

    public void setPeriod3DateStart(String period3DateStart) {
        this.set("period3DateStart", period3DateStart);
    }

    public String getPeriod3DateStart() {
        return this.get("period3DateStart");
    }

    public void setPeriod3DateEnd(String period3DateEnd) {
        this.set("period3DateEnd", period3DateEnd);
    }

    public String getPeriod3DateEnd() {
        return this.get("period3DateEnd");
    }

    public void setIcon(byte[] icon) {
        this.setBinary("icon", icon);
    }

    public byte[] getIcon() {
        return this.getBinary("icon");
    }

    public void setValidFrom(String validFrom) {
        this.set("validFrom", validFrom);
    }

    public void setValidTo(String validTo) {
        this.set("validTo", validTo);
    }

    public void setActive(String active) {
        this.set("active", active);
    }

    public void setTemplate(String template) {
        this.set("template", template);
    }

    public String getValidFrom() {
        return this.get("validFrom");
    }

    public String getValidTo() {
        return this.get("validTo");
    }

    public String getActive() {
        return this.get("active");
    }

    public String getTemplate() {
        return this.get("template");
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public Object getParent() {
        return new Object();
    }

    @Override
    public int compareTo(CstProfile profile) {
        return this.getName().compareTo(profile.getName());
    }
}

