/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.data;

import ch.elexis.data.LabItem;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.gpb.elexis.cst.data.LabItemWrapper;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.List;

public class CstGroup
extends PersistentObject {
    private static final String TABLENAME = "cstgroups";
    public static final String VERSIONID = "VERSION";
    public static final String VERSION = "3.0.0";
    public static final String GROUP_ITEM_TABLENAME = "cstgroup_labitem_joint";
    public static final String ITEMRANKING = "itemsRanking";
    private JdbcLink j = CstGroup.getConnection();
    static final String create = "CREATE TABLE `cstgroups` (\t`ID` VARCHAR(25) NOT NULL,\t`lastupdate` BIGINT(20) NULL DEFAULT NULL,\t`deleted` CHAR(1) NULL DEFAULT '0',\t`KontaktID` VARCHAR(25) NULL DEFAULT NULL,\t`MandantID` VARCHAR(25) NULL DEFAULT NULL,\t`Name` VARCHAR(30) NULL DEFAULT NULL,\t`Description` VARCHAR(256) NULL DEFAULT NULL,\t`itemsRanking` BLOB NULL, \t`Icon` VARCHAR(25) NULL, \tPRIMARY KEY (`ID`)) COlLATE='utf8_general_ci'  ENGINE=InnoDB; INSERT INTO cstgroups (ID, name) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"3.0.0") + ");";
    static final String create2 = "CREATE TABLE `cstgroup_labitem_joint` (\t`ID` VARCHAR(25) NULL DEFAULT NULL,\t`deleted` CHAR(1) NULL DEFAULT '0',\t`lastupdate` BIGINT(20) NULL DEFAULT NULL,\t`GroupID` VARCHAR(25) NULL DEFAULT NULL,\t`ItemID` VARCHAR(25) NULL DEFAULT NULL,\t`DisplayOnce` CHAR(1) NOT NULL DEFAULT '0',\t`Comment` TEXT NULL,\tUNIQUE INDEX `GroupID` (`GroupID`, `ItemID`)) COLlATE='utf8_general_ci' ENGINE=InnoDB;";

    static {
        CstGroup.addMapping((String)TABLENAME, (String[])new String[]{"name=Name", "description=Description", "icon=Icon", "kontaktId=KontaktID", "mandantId=MandantID", "itemsRanking=ItemsRanking", "Labitems=JOINT:ItemID:GroupID:cstgroup_labitem_joint"});
        if (!CstGroup.tableExists((String)TABLENAME)) {
            CstGroup.createOrModifyTable((String)create);
            CstGroup.createOrModifyTable((String)create2);
        } else {
            CstGroup version = CstGroup.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get("name"));
            if (vi.isOlder(VERSION)) {
                if (version.getName() == null) {
                    version.create(VERSIONID);
                }
                version.set("name", VERSION);
            }
        }
    }

    public CstGroup() {
    }

    public CstGroup(String id) {
        super(id);
    }

    public static CstGroup load(String id) {
        return new CstGroup(id);
    }

    public CstGroup(String name, String description, String icon, String kontaktID, String mandantID) {
        CstGroup existing = CstGroup.getByNameAndPatientAndMandant(name, kontaktID, mandantID);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Mapping for origin id [%s] - [%s] already exists can not create multiple instances.", name, description));
        }
        this.create(null);
        this.set("name", name);
        this.set("description", description);
        this.set("icon", icon);
        this.set("kontaktId", kontaktID);
        this.set("mandantId", mandantID);
    }

    public CstGroup(String name, String description, String icon, String mandantID) {
        CstGroup existing = CstGroup.getByNameAndMandant(name, mandantID);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Mapping for origin id [%s] - [%s] already exists can not create multiple instances.", name, description));
        }
        this.create(null);
        this.set("name", name);
        this.set("description", description);
        this.set("icon", icon);
        this.set("mandantId", mandantID);
    }

    public static CstGroup getByNameAndPatientAndMandant(String name, String kontaktId, String mandantId) {
        Query qbe = new Query(CstGroup.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("name", "=", name);
        qbe.add("kontaktId", "=", kontaktId);
        qbe.add("mandantId", "=", mandantId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", name));
        }
        return (CstGroup)((Object)res.get(0));
    }

    public static CstGroup getByNameAndMandant(String name, String mandantId) {
        Query qbe = new Query(CstGroup.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("name", "=", name);
        qbe.add("mandantId", "=", mandantId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", name));
        }
        return (CstGroup)((Object)res.get(0));
    }

    public static List<CstGroup> getByLabItemId(String labItemId) {
        Query qbe = new Query(CstGroup.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("itemId", "=", labItemId);
        return qbe.execute();
    }

    public static List<CstGroup> getCstGroups(Patient patient) {
        Query qbe = new Query(CstGroup.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("kontaktId", "=", patient.getId());
        return qbe.execute();
    }

    public static List<CstGroup> getCstGroups(Patient patient, String mandantId) {
        Query qbe = new Query(CstGroup.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("mandantId", "=", mandantId);
        qbe.add("kontaktId", "=", patient.getId());
        return qbe.execute();
    }

    public static List<CstGroup> getCstGroups() {
        Query qbe = new Query(CstGroup.class);
        qbe.add("ID", "<>", VERSIONID);
        return qbe.execute();
    }

    public List<LabItemWrapper> getLabitems() {
        List lResp = this.getList("Labitems", new String[]{"displayOnce"});
        ArrayList<LabItemWrapper> ret = new ArrayList<LabItemWrapper>(lResp.size());
        for (String[] r : lResp) {
            ret.add(new LabItemWrapper(LabItem.load((String)r[0]), r[1]));
        }
        return ret;
    }

    public void removeLabitem(LabItem a) {
        for (LabItemWrapper labitem : this.getLabitems()) {
            if (!labitem.getLabItem().getId().equalsIgnoreCase(a.getId())) continue;
            this.removeFromList("Labitems", a.getId());
        }
    }

    public int setDisplayOnce(LabItemWrapper labItem, String displayOnce) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE cstgroup_labitem_joint SET DisplayOnce = '").append(displayOnce).append("' WHERE GroupID = ").append(this.getWrappedId()).append(" AND ItemId = ").append(labItem.getLabItem().getWrappedId());
        int result = this.j.exec(sql.toString());
        return result;
    }

    public void addItem(LabItemWrapper item) {
        if (item != null && item.getLabItem().state() == 3) {
            String exists = this.j.queryString("SELECT ItemID FROM cstgroup_labitem_joint WHERE GroupID = " + this.getWrappedId() + " AND ItemID = " + item.getLabItem().getWrappedId());
            if (StringTool.isNothing((Object)exists)) {
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO cstgroup_labitem_joint (GroupID, ItemID, DisplayOnce) VALUES (").append(this.getWrappedId()).append(",").append(item.getLabItem().getWrappedId()).append(", ").append(item.getDisplayOnce()).append(")");
                this.j.exec(sql.toString());
            } else {
                log.error("Lab item " + item.getLabItem().getName() + " already exists in CSTGroup: " + this.getName());
                throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", item.getLabItem().getName()));
            }
        }
    }

    public void addItems(List<LabItemWrapper> items) {
        if (items != null) {
            for (LabItemWrapper item : items) {
                this.addItem(item);
            }
        }
    }

    public boolean delete() {
        CstGroup.getConnection().exec("DELETE FROM  cstgroup_labitem_joint WHERE GroupID =" + this.getWrappedId());
        return super.delete();
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getName() {
        return this.get("name");
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public String getDescription() {
        return this.get("description");
    }

    public void setKontaktId(String kontaktId) {
        this.set("kontaktId", kontaktId);
    }

    public String getKontaktId() {
        return this.get("kontaktId");
    }

    public void setMandantId(String mandantId) {
        this.set("mandantId", mandantId);
    }

    public String getMandantId() {
        return this.get("mandantId");
    }

    public void setIcon(byte[] icon) {
        this.setBinary("icon", icon);
    }

    public byte[] getIcon() {
        return this.getBinary("icon");
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public Object getParent() {
        return new Object();
    }
}

