/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.widget;

import ch.elexis.core.ui.UiDesk;
import ch.gpb.elexis.cst.widget.CstCanvas;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class CstDangerRangeCanvas
extends CstCanvas {
    double dRangeStart;
    double dRangeEnd;
    double dValue;
    String alphanumValue;
    int iLenScale;
    Image marker;
    Image verlaufRl;
    Image verlaufLr;
    Image pointer;
    int xoffset;
    int yoffset;
    int iPixLen;
    String title;
    String sDate;

    public CstDangerRangeCanvas(Composite parent, boolean a4Quer, int style, double dRangeStart, double dRangeEnd, double dValue, String sValue, String title, String date) {
        super(parent, style);
        this.dRangeStart = dRangeStart;
        this.dRangeEnd = dRangeEnd;
        this.dValue = dValue;
        this.title = title;
        this.sDate = date;
        this.alphanumValue = sValue;
        this.iPixLen = a4Quer ? 809 : 480;
        this.xoffset = 4;
        this.yoffset = 12;
        this.pointer = UiDesk.getImage((String)"pointer.png");
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                CstDangerRangeCanvas.this.paintControl(e);
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.iPixLen + 50, 36);
    }

    void paintControl(PaintEvent e) {
        double rTmp;
        GC gc = e.gc;
        gc.setFont(this.fontA);
        double dTmp = this.dValue;
        if (this.dValue < this.dRangeEnd) {
            dTmp = this.dRangeEnd;
        }
        double dAnzeigeBereich = (rTmp = (double)Math.round(dTmp)) % 10.0 == 0.0 ? rTmp : dTmp * 1.2;
        double xFac = (double)this.iPixLen / dAnzeigeBereich;
        gc.setBackground(ORANGE);
        gc.fillRectangle(this.xoffset, this.yoffset, this.iPixLen, 10);
        int greenStart = 0;
        int greenEnd = 0;
        if (this.dRangeStart > 0.0) {
            greenStart = new Double(Math.round(xFac * this.dRangeStart)).intValue();
        }
        greenEnd = new Double(xFac * this.dRangeEnd).intValue();
        gc.setBackground(BRIGHTGREEN);
        gc.fillRectangle(this.xoffset + greenStart, this.yoffset, greenEnd - greenStart, 10);
        gc.setForeground(ORANGE);
        if (this.dRangeStart > 0.0) {
            gc.fillGradientRectangle(this.xoffset + greenStart, this.yoffset, 40, 10, false);
        }
        gc.setForeground(BRIGHTGREEN);
        gc.setBackground(ORANGE);
        int xLenToFill = this.iPixLen - (greenEnd - 20);
        try {
            gc.fillGradientRectangle(this.xoffset + greenEnd - 20, this.yoffset, xLenToFill, 10, false);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            log.error("DangerRangeCanvas error: greenEnd:" + greenEnd + " xLenToFill: " + xLenToFill + "  title: " + this.title + " " + e1.getMessage());
        }
        gc.setForeground(BLACK);
        if (this.alphanumValue.toLowerCase().indexOf("neg") <= -1 && this.alphanumValue.toLowerCase().indexOf("norm") <= -1 && this.alphanumValue.toLowerCase().indexOf("pos") <= -1 && this.alphanumValue.toLowerCase().indexOf("-") <= -1 && this.alphanumValue.toLowerCase().indexOf("+") <= -1) {
            gc.drawString(">" + String.valueOf(this.dRangeEnd), this.xoffset + greenEnd, this.yoffset - 2, true);
        }
        if (this.title != null) {
            gc.drawString(this.title + " (" + this.sDate + ")", this.xoffset + 2, this.yoffset - 13, true);
        } else {
            gc.drawString("[title missing] (" + this.sDate + ")", this.xoffset + 2, this.yoffset - 13, true);
        }
        if (this.dRangeStart > 0.0) {
            gc.drawString("< " + String.valueOf(this.dRangeStart), this.xoffset + greenStart, this.yoffset - 2, true);
        }
        int posM = new Double(Math.round(xFac * this.dValue)).intValue();
        String sValue = String.valueOf(this.dValue);
        int iLenValue = 4;
        FontMetrics fm = gc.getFontMetrics();
        Point pt = gc.textExtent(this.alphanumValue);
        if (this.alphanumValue.toLowerCase().indexOf("pos") > -1 || this.alphanumValue.toLowerCase().indexOf("+") > -1) {
            String sDisplay = this.alphanumValue;
            if (sDisplay.indexOf("+") > -1) {
                sDisplay = "positiv";
            }
            gc.drawString(sDisplay, this.iPixLen - pt.x - 20, this.yoffset - iLenValue + 1, true);
        } else if (this.alphanumValue.toLowerCase().indexOf("neg") > -1 || this.alphanumValue.toLowerCase().indexOf("norm") > -1 || this.alphanumValue.toLowerCase().indexOf("-") > -1) {
            String sDisplay = this.alphanumValue;
            if (sDisplay.indexOf("-") > -1) {
                sDisplay = "negativ";
            }
            gc.drawString(sDisplay, this.xoffset + posM, this.yoffset - iLenValue + 1, true);
        } else if (this.dValue > 0.0) {
            gc.drawString(sValue, this.xoffset + posM, this.yoffset + 14 - iLenValue, true);
            gc.drawImage(this.pointer, this.xoffset + posM - 6, this.yoffset + 14 - iLenValue - 14);
        }
    }

    public double getRangeStart() {
        return this.dRangeStart;
    }

    public void setRangeStart(double rangeStart) {
        this.dRangeStart = rangeStart;
    }

    public double getRangeEnd() {
        return this.dRangeEnd;
    }

    public void setRangeEnd(double rangeEnd) {
        this.dRangeEnd = rangeEnd;
    }

    public double getValue() {
        return this.dValue;
    }

    public void setValue(double value) {
        this.dValue = value;
    }

    public int getlScale() {
        return this.iLenScale;
    }

    public void setlScale(int lScale) {
        this.iLenScale = lScale;
    }
}

