/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.data;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.util.List;

public class CstAbstract
extends PersistentObject {
    private static final String TABLENAME = "cstlaboritem_abstracts";
    public static final String VERSIONID = "VERSION";
    public static final String VERSION = "3.0.0";
    static final String create = "CREATE TABLE `cstlaboritem_abstracts` (  `ID` varchar(25) NOT NULL,  `lastupdate` bigint(20) DEFAULT NULL,  `deleted` char(1) DEFAULT '0',  `ItemID` varchar(25) DEFAULT NULL,  `Description1` varchar(1024) DEFAULT NULL,  `Description2` varchar(1024) DEFAULT NULL,  PRIMARY KEY (`ID`)) COLLATE='utf8_general_ci' ENGINE=InnoDB;INSERT INTO cstlaboritem_abstracts (ID, description1) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"3.0.0") + ")";

    static {
        CstAbstract.addMapping((String)TABLENAME, (String[])new String[]{"itemId=ItemID", "description1=Description1", "description2=Description2"});
        if (!CstAbstract.tableExists((String)TABLENAME)) {
            CstAbstract.createOrModifyTable((String)create);
            log.debug("Creating table:\r\n" + create);
        } else {
            CstAbstract version = CstAbstract.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get("description1"));
            if (vi.isOlder(VERSION)) {
                if (version.getDescription1() == null) {
                    version.create(VERSIONID);
                }
                version.set("description1", VERSION);
            }
        }
    }

    public CstAbstract() {
    }

    public CstAbstract(String id) {
        super(id);
    }

    public static CstAbstract load(String id) {
        if (StringTool.isNothing((Object)id)) {
            return null;
        }
        return new CstAbstract(id);
    }

    public CstAbstract(String itemID, String description1, String description2) {
        CstAbstract existing = CstAbstract.getByLaboritemId(itemID);
        if (existing != null) {
            throw new IllegalArgumentException(String.format("Mapping for origin id [%s] - [%s] already exists can not create multiple instances.", itemID, description1));
        }
        this.create(null);
        this.set("itemId", itemID);
        this.set("description1", description1);
        this.set("description2", description2);
    }

    public static CstAbstract getByLaboritemId(String itemId) {
        Query qbe = new Query(CstAbstract.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("itemId", "=", itemId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", itemId));
        }
        return (CstAbstract)((Object)res.get(0));
    }

    public boolean delete() {
        return super.delete();
    }

    public void setItemId(String itemId) {
        this.set("itemId", itemId);
    }

    public String getItemId() {
        return this.get("itemId");
    }

    public void setDescription1(String description1) {
        this.set("description1", description1);
    }

    public String getDescription1() {
        return this.get("description1");
    }

    public void setDescription2(String description2) {
        this.set("description1", description2);
    }

    public String getDescription2() {
        return this.get("description1");
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public Object getParent() {
        return new Object();
    }
}

