/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.service;

import ch.elexis.befunde.Messwert;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.data.LabResult;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstGroup;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.data.CstProimmun;
import ch.gpb.elexis.cst.preferences.CstPreference;
import ch.gpb.elexis.cst.view.CstProfileEditor;
import ch.rgw.tools.StringTool;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CstService {
    private static SimpleDateFormat compactDateFormat = new SimpleDateFormat("yyyyMMdd");
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private static Logger log = LoggerFactory.getLogger((String)CstProfileEditor.class.getName());

    public static long getDayCountFromCompact(String start, String end) {
        long diff = -1L;
        try {
            Date dateStart = compactDateFormat.parse(start);
            Date dateEnd = compactDateFormat.parse(end);
            diff = Math.round((double)(dateEnd.getTime() - dateStart.getTime()) / 8.64E7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return diff;
    }

    public void copyProfile(CstProfile source, List<Patient> target, Mandant mandant) {
        for (Patient patient : target) {
            CstProfile newProfile = new CstProfile(Messages.Cst_Text_Copy_of + source.getName() + " (" + CstService.getGermanFromDate(new Date()) + ")", source.getDescription(), null, patient.getId(), mandant.getId(), CstService.getCompactFromDate(new Date()), CstService.getCompactFromDate(new Date()), "1");
            log.info("created new profile with id: " + newProfile.getId());
            CstService.copyProfile(source, newProfile);
            log.info("copy profile complete  id: " + newProfile.getId(), (Object)4);
        }
    }

    public static void copyProfile(CstProfile source, CstProfile target) {
        List<CstGroup> cstgroups = source.getCstGroups();
        target.addItems(cstgroups);
        Map itemRanking = source.getMap("itemsRanking");
        Map mapAuswahl = source.getMap("Auswahlbefunde");
        if (mapAuswahl != null) {
            target.setMap("Auswahlbefunde", mapAuswahl);
        } else {
            Hashtable map = new Hashtable();
            target.setMap("Auswahlbefunde", map);
        }
        target.setMap("itemsRanking", itemRanking);
        target.setAnzeigeTyp("Effektiv");
        target.setAnzeigeTyp(source.getAnzeigeTyp());
        target.setCrawlBack(source.getCrawlBack());
        target.setPeriod1DateStart(source.getPeriod1DateStart());
        target.setPeriod1DateEnd(source.getPeriod1DateEnd());
        target.setPeriod2DateStart(source.getPeriod2DateStart());
        target.setPeriod2DateEnd(source.getPeriod2DateEnd());
        target.setPeriod3DateStart(source.getPeriod3DateStart());
        target.setPeriod3DateEnd(source.getPeriod3DateEnd());
        target.setDaySpan1(source.getDaySpan1());
        target.setDaySpan2(source.getDaySpan2());
        target.setDaySpan3(source.getDaySpan3());
        target.setDiagnose(source.getDiagnose());
        target.setTherapievorschlag(source.getTherapievorschlag());
        target.setOutputHeader(source.getOutputHeader());
        CstProimmun cstProImmun = CstProimmun.getByProfileId(source.getId());
        if (cstProImmun != null && source.getKontaktId().equals(target.getKontaktId())) {
            CstProimmun newCstProImmun = new CstProimmun(target.getId(), cstProImmun.getDatum());
            newCstProImmun.setProfileId(target.getId());
            newCstProImmun.setTested(cstProImmun.getTested());
            newCstProImmun.setToBeTested(cstProImmun.getToBeTested());
            newCstProImmun.setText1(cstProImmun.getText1());
            newCstProImmun.setText2(cstProImmun.getText2());
            newCstProImmun.setText3(cstProImmun.getText3());
            newCstProImmun.setText4(cstProImmun.getText4());
        }
    }

    public static Date getDateFromCompact(String sDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        try {
            return df.parse(sDate);
        }
        catch (ParseException e) {
            log.error("Error parsing date: /" + sDate + "/" + e.toString(), (Object)2);
            Status status = new Status(2, "ch.gbp.elexis.cst", e.getLocalizedMessage());
            StatusManager.getManager().handle((IStatus)status, 1);
            return null;
        }
    }

    public static String getCompactFromDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(date);
    }

    public static String generateFilename(Patient p) {
        SimpleDateFormat df;
        String filePrefix = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_FILEPREFIX, null);
        if (filePrefix == null) {
            filePrefix = "PREFIX-NOT-DEFINED-YET";
        }
        StringBuffer result = new StringBuffer();
        result.append(filePrefix);
        result.append("-");
        result.append(p.getVorname().substring(0, 1));
        result.append(".");
        result.append(p.getName().substring(0, 1));
        result.append(".-");
        String fileFormat = ConfigServiceHolder.getUser((String)CstPreference.CST_IDENTIFIER_FILEFORMAT, null);
        Date date = new Date();
        try {
            df = new SimpleDateFormat(fileFormat);
        }
        catch (Exception e) {
            df = new SimpleDateFormat("yyyyMMdd_HH-mm-ss");
        }
        result.append(df.format(date));
        return result.toString();
    }

    public static String getGermanFromDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        return df.format(date);
    }

    public static String getReadableDateAndTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy  HH:mm");
        return sdf.format(date);
    }

    public static String getGermanFromCompact(String date) {
        StringBuffer result = new StringBuffer();
        result.append(date.substring(6));
        result.append(".");
        result.append(date.substring(4, 6));
        result.append(".");
        result.append(date.substring(0, 4));
        return result.toString();
    }

    public static Date getDateFromGermanFormat(String sDate) {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        Date date = null;
        try {
            date = df.parse(sDate);
        }
        catch (ParseException e) {
            log.error("Error converting date: " + e.getMessage(), (Object)2);
        }
        return date;
    }

    public static String getCompactFromReadable(String sDate) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        try {
            date = df.parse(sDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            date = new Date();
        }
        SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
        return df2.format(date);
    }

    public static String parseCompactDate(String compactDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat outputFormat = new SimpleDateFormat("dd.MM.yyyy");
        if (compactDate != null) {
            try {
                Date result = df.parse(compactDate);
                String out = outputFormat.format(result);
                return out.toString();
            }
            catch (ParseException e) {
                log.error("Error parsing date in CstProfileEditor: " + e.toString(), (Object)2);
                return compactDate;
            }
        }
        return compactDate;
    }

    public static String getDateFromSubraction(int daysToSubtract) {
        Calendar c = Calendar.getInstance();
        c.add(5, -daysToSubtract);
        SimpleDateFormat outputFormat = new SimpleDateFormat("dd.MM.yyyy");
        return outputFormat.format(c.getTime());
    }

    public static boolean isNumericString(String a) {
        Pattern pattern = Pattern.compile("^([0-9\\.])+$");
        Matcher matcher = pattern.matcher(a);
        return matcher.find();
    }

    public static boolean isNonNumericString(String a) {
        Pattern pattern = Pattern.compile("^([A-Za-z])+$");
        Matcher matcher = pattern.matcher(a);
        return matcher.find();
    }

    public static String getMaximumOfNumbersInString(String value) {
        Pattern pattern = Pattern.compile("([0-9\\.])+");
        Matcher matcher = pattern.matcher(value);
        ArrayList<String> values = new ArrayList<String>();
        while (matcher.find()) {
            values.add(matcher.group());
        }
        Collections.sort(values);
        String maxValue = "";
        try {
            maxValue = (String)values.get(values.size() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug("Error extracting maximal value: " + e.toString());
        }
        return maxValue;
    }

    public static boolean isSelectedInAuswahlBefunde(Map<String, Boolean> mapAuswahl, String sBefundName) {
        boolean result = false;
        for (String key : mapAuswahl.keySet()) {
            if (!key.equals(sBefundName)) continue;
            result = mapAuswahl.get(key);
            break;
        }
        return result;
    }

    public static boolean isBefundSelected(Map<Object, Object> mapAuswahl, String sBefundName) {
        boolean result = false;
        for (Object key : mapAuswahl.keySet()) {
            if (!key.equals(sBefundName)) continue;
            if (mapAuswahl.get(key).toString().equals("false")) break;
            result = true;
            break;
        }
        return result;
    }

    public static List<String> getBefundArtenFields() {
        ArrayList<String> result = new ArrayList<String>();
        Messwert setup = Messwert.getSetup();
        Map hash = setup.getMap("Befunde");
        String names = (String)hash.get("names");
        if (!StringTool.isNothing((Object)names)) {
            String[] stringArray = names.split(";;");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sNameBefund = stringArray[n2];
                String fields = (String)hash.get(sNameBefund + "_FIELDS");
                if (fields != null) {
                    String[] mNames = fields.split(";;");
                    int i = 0;
                    while (i < mNames.length) {
                        result.add(mNames[i].split(":/:")[0]);
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static String getBefundArtSeparator(Map<Object, Object> mapAuswahl, String befundArt) {
        String result = null;
        for (Object key : mapAuswahl.keySet()) {
            String sepKey;
            if (!key.equals(sepKey = "separator_" + befundArt)) continue;
            result = (String)mapAuswahl.get(key);
            if (result.length() != 0) break;
            result = null;
            break;
        }
        return result;
    }

    public static String getBefundArtOfField(CstProfile profile, String fieldName) {
        Map mAuswahl = profile.getMap("Auswahlbefunde");
        String sBefundArt = mAuswahl.get(fieldName).toString();
        return sBefundArt;
    }

    public static List<String> getDistinctDates(HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> labResults) {
        HashMap<String, String> distinctDates = new HashMap<String, String>();
        Set<String> keys1 = labResults.keySet();
        for (String sKey : keys1) {
            HashMap<String, HashMap<String, List<LabResult>>> hm2 = labResults.get(sKey);
            Set<String> keys2 = hm2.keySet();
            for (String sKey2 : keys2) {
                HashMap<String, List<LabResult>> hm3 = hm2.get(sKey2);
                Set<String> keys3 = hm3.keySet();
                for (String sKey3 : keys3) {
                    distinctDates.put(sKey3, "dummy");
                }
            }
        }
        ArrayList<String> sortedDates = new ArrayList<String>(distinctDates.keySet());
        Collections.sort(sortedDates);
        return sortedDates;
    }

    public static LabResult getValueForNameAndDate(String name, String date, String kuerzel, HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> labResults) {
        LabResult result = null;
        Set<String> keys1 = labResults.keySet();
        for (String sKey : keys1) {
            HashMap<String, HashMap<String, List<LabResult>>> hm2 = labResults.get(sKey);
            Set<String> keys2 = hm2.keySet();
            for (String sKey2 : keys2) {
                HashMap<String, List<LabResult>> hm3 = hm2.get(sKey2);
                Set<String> keys3 = hm3.keySet();
                block2: for (String sKey3 : keys3) {
                    List<LabResult> obj;
                    List<LabResult> res = obj = hm3.get(sKey3);
                    for (LabResult labResult : res) {
                        if (!labResult.getItem().getName().equals(name) && !labResult.getItem().getKuerzel().equals(kuerzel) && !labResult.getItem().getName().equals(kuerzel) && !labResult.getItem().getKuerzel().equals(name) || !labResult.getDate().equals(CstService.getGermanFromCompact(date))) continue;
                        result = labResult;
                        continue block2;
                    }
                }
            }
        }
        return result;
    }

    public static boolean hasValueForName(String name, String kuerzel, HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> labResults) {
        boolean result = false;
        Set<String> keys1 = labResults.keySet();
        for (String sKey : keys1) {
            HashMap<String, HashMap<String, List<LabResult>>> hm2 = labResults.get(sKey);
            Set<String> keys2 = hm2.keySet();
            for (String sKey2 : keys2) {
                HashMap<String, List<LabResult>> hm3 = hm2.get(sKey2);
                Set<String> keys3 = hm3.keySet();
                block2: for (String sKey3 : keys3) {
                    List<LabResult> obj;
                    List<LabResult> res = obj = hm3.get(sKey3);
                    for (LabResult labResult : res) {
                        if (!labResult.getItem().getName().equals(name) && !labResult.getItem().getKuerzel().equals(kuerzel) && !labResult.getItem().getName().equals(kuerzel) && !labResult.getItem().getKuerzel().equals(name)) continue;
                        result = true;
                        continue block2;
                    }
                }
            }
        }
        return result;
    }

    public static int getDaysBetweenDates(Date dateStart, Date dateEnd) {
        long diff = dateEnd.getTime() - dateStart.getTime();
        long days = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
        int result = (int)days;
        return result;
    }

    public static Date getDateByAddingDays(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        Date dateBeforeOrAfter = cal.getTime();
        return dateBeforeOrAfter;
    }

    public static LabResult getMaxValueForTimespan(String name, String kuerzel, Date dateStart, Date dateEnd, HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> labResults) {
        LabResult result = null;
        Set<String> keys1 = labResults.keySet();
        for (String sKey : keys1) {
            HashMap<String, HashMap<String, List<LabResult>>> hm2 = labResults.get(sKey);
            Set<String> keys2 = hm2.keySet();
            for (String sKey2 : keys2) {
                HashMap<String, List<LabResult>> hm3 = hm2.get(sKey2);
                Set<String> keys3 = hm3.keySet();
                block2: for (String sKey3 : keys3) {
                    List<LabResult> obj;
                    List<LabResult> res = obj = hm3.get(sKey3);
                    for (LabResult currentResult : res) {
                        String sDateResult = currentResult.getDate();
                        Date dateResult = CstService.getDateFromGermanFormat(sDateResult);
                        if (!currentResult.getItem().getName().equals(name) && !currentResult.getItem().getKuerzel().equals(kuerzel) && !currentResult.getItem().getName().equals(kuerzel) && !currentResult.getItem().getKuerzel().equals(name) || !dateResult.after(dateStart) || !dateResult.before(dateEnd)) continue;
                        if (result == null) {
                            result = currentResult;
                            continue block2;
                        }
                        double dResultResult = CstService.getNumericFromLabResult(result.getResult());
                        double dCurrentResult = CstService.getNumericFromLabResult(currentResult.getResult());
                        if (!(dCurrentResult > dResultResult)) continue block2;
                        result = currentResult;
                        continue block2;
                    }
                }
            }
        }
        return result;
    }

    public static LabResult getMinValueForTimespan(String name, String kuerzel, Date dateStart, Date dateEnd, HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> labResults) {
        LabResult result = null;
        Set<String> keys1 = labResults.keySet();
        for (String sKey : keys1) {
            HashMap<String, HashMap<String, List<LabResult>>> hm2 = labResults.get(sKey);
            Set<String> keys2 = hm2.keySet();
            for (String sKey2 : keys2) {
                HashMap<String, List<LabResult>> hm3 = hm2.get(sKey2);
                Set<String> keys3 = hm3.keySet();
                block2: for (String sKey3 : keys3) {
                    List<LabResult> obj;
                    List<LabResult> res = obj = hm3.get(sKey3);
                    for (LabResult currentResult : res) {
                        String sDateResult = currentResult.getDate();
                        Date dateResult = CstService.getDateFromGermanFormat(sDateResult);
                        if (!currentResult.getItem().getName().equals(name) && !currentResult.getItem().getKuerzel().equals(kuerzel) && !currentResult.getItem().getName().equals(kuerzel) && !currentResult.getItem().getKuerzel().equals(name) || !dateResult.after(dateStart) || !dateResult.before(dateEnd)) continue;
                        if (result == null) {
                            result = currentResult;
                            continue block2;
                        }
                        double dResultResult = CstService.getNumericFromLabResult(result.getResult());
                        double dCurrentResult = CstService.getNumericFromLabResult(currentResult.getResult());
                        if (!(dCurrentResult < dResultResult)) continue block2;
                        result = currentResult;
                        continue block2;
                    }
                }
            }
        }
        return result;
    }

    public static double getNumericFromLabResult(String sResult) {
        double result = 0.0;
        String sRes = sResult.replaceAll("[^0-9?!\\.]", "");
        try {
            result = new Double(sRes);
        }
        catch (NumberFormatException e) {
            log.error("Error formatting Result: " + sResult + "/" + sRes + "/" + e.getMessage(), (Object)2);
        }
        return result;
    }

    public static String getReadableFromCompact(String sDate) {
        Date date = CstService.getDateFromCompact(sDate);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        return sdf.format(date);
    }

    public static void printLaborwerte(HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> labResults) {
        Set<String> keys1 = labResults.keySet();
        for (String sKey : keys1) {
            HashMap<String, HashMap<String, List<LabResult>>> hm2 = labResults.get(sKey);
            Set<String> keys2 = hm2.keySet();
            for (String sKey2 : keys2) {
                if (sKey2.length() == 0 || hm2.get(sKey2) == null) continue;
                HashMap<String, List<LabResult>> hm3 = hm2.get(sKey2);
                Set<String> keys3 = hm3.keySet();
                for (String sKey3 : keys3) {
                    List<LabResult> obj;
                    List<LabResult> res = obj = hm3.get(sKey3);
                    for (LabResult labResult : res) {
                        log.info("\t\t\t\tP: lab result: " + labResult.getDate() + " Name: " + labResult.getItem().getName() + " Kuerzel: " + labResult.getItem().getKuerzel() + "\tResult: " + labResult.getResult(), (Object)4);
                    }
                }
            }
        }
    }

    public static long getNrOfDaysBetween(Date dStart, Date dEnd) {
        long diff = dEnd.getTime() - dStart.getTime();
        long days = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
        return days;
    }
}

