/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.dialog;

import ch.elexis.data.LabItem;
import ch.gpb.elexis.cst.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CstLabItemSelectionDialog
extends SelectionDialog {
    private Table table;
    private String firstName;
    private String lastName;
    private CheckboxTableViewer tableViewer;
    private List<LabItem> labItems;
    private List<LabItem> selItems;
    private int sortColumn = 0;
    private boolean sortReverse = false;

    public List<LabItem> getSelItems() {
        return this.selItems;
    }

    public void setSelItems(List<LabItem> selItems) {
        this.selItems = selItems;
    }

    public CstLabItemSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public CstLabItemSelectionDialog(Shell parentShell, List<LabItem> labItems) {
        super(parentShell);
        this.labItems = labItems;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.Cst_Text_Laboritemauswahl);
        this.setMessage(Messages.Cst_Text_Laboritemauswahl_label);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.table = new Table(container, 66340);
        String[] colLabels = this.getColumnLabels();
        int[] columnWidth = this.getColumnWidth();
        SortListener sortListener = new SortListener();
        TableColumn[] cols = new TableColumn[colLabels.length];
        int i = 0;
        while (i < colLabels.length) {
            cols[i] = new TableColumn(this.table, 0);
            cols[i].setWidth(columnWidth[i]);
            cols[i].setText(colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            cols[i].addSelectionListener((SelectionListener)sortListener);
            ++i;
        }
        GridData gridDataTable = new GridData();
        gridDataTable.horizontalAlignment = 4;
        gridDataTable.verticalAlignment = 4;
        gridDataTable.grabExcessHorizontalSpace = true;
        gridDataTable.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridDataTable);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.setSorter((ViewerSorter)new Sorter());
        this.tableViewer.setInput((Object)this);
        return area;
    }

    private String[] getColumnLabels() {
        String[] columnLabels = new String[]{Messages.CstLaborPrefs_name, Messages.CstLaborPrefs_short, Messages.CstLaborPrefs_unit, Messages.CstLaborPrefs_type, Messages.CstLaborPrefs_sortmode, "Ref M", "Ref F"};
        return columnLabels;
    }

    private int[] getColumnWidth() {
        int[] columnWidth = new int[]{120, 150, 200, 200, 100, 100, 100};
        return columnWidth;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        Object[] checkedItems;
        this.selItems = new ArrayList<LabItem>();
        Object[] objectArray = checkedItems = this.tableViewer.getCheckedElements();
        int n = checkedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            LabItem labItem = (LabItem)object;
            this.selItems.add(labItem);
            ++n2;
        }
        super.okPressed();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    class SortListener
    extends SelectionAdapter {
        SortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == CstLabItemSelectionDialog.this.sortColumn) {
                    CstLabItemSelectionDialog.this.sortReverse = !CstLabItemSelectionDialog.this.sortReverse;
                } else {
                    CstLabItemSelectionDialog.this.sortReverse = false;
                    CstLabItemSelectionDialog.this.sortColumn = colNo;
                }
                CstLabItemSelectionDialog.this.tableViewer.refresh();
            }
        }
    }

    class Sorter
    extends ViewerSorter {
        Sorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof LabItem && e2 instanceof LabItem) {
                LabItem d1 = (LabItem)e1;
                LabItem d2 = (LabItem)e2;
                String c1 = "";
                String c2 = "";
                switch (CstLabItemSelectionDialog.this.sortColumn) {
                    case 0: {
                        c1 = d1.getName();
                        c2 = d2.getName();
                        break;
                    }
                    case 1: {
                        c1 = d1.getKuerzel();
                        c2 = d2.getKuerzel();
                        break;
                    }
                    case 2: {
                        c1 = d1.getEinheit();
                        c2 = d2.getEinheit();
                        break;
                    }
                    case 3: {
                        c1 = d1.getPrio();
                        c2 = d2.getPrio();
                        break;
                    }
                    case 4: {
                        c1 = d1.getGroup();
                        c2 = d2.getGroup();
                    }
                }
                if (CstLabItemSelectionDialog.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return CstLabItemSelectionDialog.this.labItems.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            LabItem labItem = (LabItem)obj;
            switch (index) {
                case 0: {
                    return labItem.getName();
                }
                case 1: {
                    return labItem.getKuerzel();
                }
                case 2: {
                    return labItem.getEinheit();
                }
                case 3: {
                    return labItem.getPrio();
                }
                case 4: {
                    return labItem.getGroup();
                }
                case 5: {
                    return labItem.getRefM();
                }
                case 6: {
                    return labItem.getRefW();
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            return font;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

