/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.dialog;

import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.gpb.elexis.cst.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CstCopyProfileDialog
extends SelectionDialog {
    private Table table;
    private String firstName;
    private String lastName;
    private CheckboxTableViewer tableViewer;
    Query<Patient> qbe = new Query(Patient.class);
    Object[] pats;
    List<Patient> lPats = this.qbe.execute();
    private List<Patient> selItems;
    private int sortColumn = 0;
    private boolean sortReverse = false;

    public CstCopyProfileDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.Cst_Text_Patientenauswahl);
        this.setMessage(Messages.Cst_Text_Patientenauswahl_kopieren);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.table = new Table(container, 66340);
        String[] colLabels = this.getColumnLabels();
        int[] columnWidth = this.getColumnWidth();
        SortListener sortListener = new SortListener();
        TableColumn[] cols = new TableColumn[colLabels.length];
        int i = 0;
        while (i < colLabels.length) {
            cols[i] = new TableColumn(this.table, 0);
            cols[i].setWidth(columnWidth[i]);
            cols[i].setText(colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            cols[i].addSelectionListener((SelectionListener)sortListener);
            ++i;
        }
        GridData gridDataTable = new GridData();
        gridDataTable.horizontalAlignment = 4;
        gridDataTable.verticalAlignment = 4;
        gridDataTable.grabExcessHorizontalSpace = true;
        gridDataTable.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridDataTable);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.setSorter((ViewerSorter)new PatientSorter());
        this.tableViewer.setInput((Object)this);
        return area;
    }

    private String[] getColumnLabels() {
        String[] columnLabels = new String[]{Messages.CstLaborPrefs_id, Messages.CstLaborPrefs_name, Messages.CstLaborPrefs_firstname};
        return columnLabels;
    }

    private int[] getColumnWidth() {
        int[] columnWidth = new int[]{120, 100, 100};
        return columnWidth;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        Object[] checkedItems;
        this.selItems = new ArrayList<Patient>();
        Object[] objectArray = checkedItems = this.tableViewer.getCheckedElements();
        int n = checkedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Patient labItem = (Patient)object;
            this.selItems.add(labItem);
            ++n2;
        }
        super.okPressed();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public List<Patient> getSelItems() {
        return this.selItems;
    }

    public void setSelItems(List<Patient> selItems) {
        this.selItems = selItems;
    }

    class PatientSorter
    extends ViewerSorter {
        PatientSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Patient && e2 instanceof Patient) {
                Patient d1 = (Patient)e1;
                Patient d2 = (Patient)e2;
                String c1 = "";
                String c2 = "";
                switch (CstCopyProfileDialog.this.sortColumn) {
                    case 0: {
                        c1 = d1.getId();
                        c2 = d2.getId();
                        break;
                    }
                    case 1: {
                        c1 = d1.getName();
                        c2 = d2.getName();
                        break;
                    }
                    case 2: {
                        c1 = d1.getVorname();
                        c2 = d2.getVorname();
                    }
                }
                if (CstCopyProfileDialog.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }

    class SortListener
    extends SelectionAdapter {
        SortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == CstCopyProfileDialog.this.sortColumn) {
                    CstCopyProfileDialog.this.sortReverse = !CstCopyProfileDialog.this.sortReverse;
                } else {
                    CstCopyProfileDialog.this.sortReverse = false;
                    CstCopyProfileDialog.this.sortColumn = colNo;
                }
                CstCopyProfileDialog.this.tableViewer.refresh();
            }
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (CstCopyProfileDialog.this.lPats == null) {
                CstCopyProfileDialog.this.lPats = CstCopyProfileDialog.this.qbe.execute();
            }
            return CstCopyProfileDialog.this.lPats.toArray(new Patient[0]);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            Patient labItem = (Patient)obj;
            switch (index) {
                case 0: {
                    return labItem.getPatCode();
                }
                case 1: {
                    return labItem.getName();
                }
                case 2: {
                    return labItem.getVorname();
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            return font;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

