/*
 * Decompiled with CFR 0.152.
 */
package elexis_db_shaker.actions;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionedResource;
import elexis_db_shaker.actions.DocumentRemover;
import elexis_db_shaker.actions.Lipsum;
import elexis_db_shaker.actions.Namen;
import elexis_db_shaker.actions.SettingsDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class Shake
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    boolean zufallsnamen;
    int TOTAL = Integer.MAX_VALUE;

    public void run(IAction action) {
        if (!AccessControlServiceHolder.get().evaluate(EvACE.of((String)"EXEC_DBSHAKER"))) {
            MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)"Insufficient rights", (String)"Insufficient rights to execute.");
            return;
        }
        final SettingsDialog sd = new SettingsDialog(this.window.getShell());
        if (sd.open() == 0 && SWTHelper.askYesNo((String)"Wirklich Datenbank anonymisieren", (String)"Achtung! Diese Aktion macht die Datenbank unwiderruflich unbrauchbar! Wirklich anonymisieren?")) {
            this.zufallsnamen = sd.replaceNames;
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                ps.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) {
                        pm.beginTask("Anonymisiere Datenbank", Shake.this.TOTAL);
                        int jobs = 1;
                        if (sd.replaceKons) {
                            ++jobs;
                        }
                        if (sd.deleteDocs) {
                            ++jobs;
                        }
                        if (sd.purgeDB) {
                            ++jobs;
                        }
                        Shake.this.doShakeNames(pm, Shake.this.TOTAL / jobs);
                        if (sd.replaceKons) {
                            Shake.this.doShakeKons(pm, Shake.this.TOTAL / jobs);
                        }
                        if (sd.deleteDocs) {
                            new DocumentRemover().run(pm, Shake.this.TOTAL / jobs);
                        }
                        if (sd.purgeDB) {
                            Shake.this.doPurgeDB(pm, Shake.this.TOTAL / jobs);
                        }
                        pm.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void doPurgeDB(IProgressMonitor monitor, int workUnits) {
        monitor.subTask("Bereinige Datenbank");
        JdbcLink j = PersistentObject.getConnection();
        j.exec("DELETE FROM kontakt where deleted='1'");
        j.exec("DELETE FROM briefe where deleted='1'");
        j.exec("DELETE FROM faelle where deleted='1'");
        j.exec("DELETE FROM behandlungen where deleted='1'");
        j.exec("DELETE FROM artikel where deleted='1'");
        j.exec("DELETE FROM leistungen where deleted='1'");
        j.exec("DELETE FROM output_log");
        j.exec("DELETE FROM rechnungen where deleted='1'");
        j.exec("DELETE FROM reminders where deleted='1'");
        j.exec("DELETE FROM traces");
        j.exec("DELETE FROM laboritems where deleted='1'");
        j.exec("DELETE FROM laborwerte where deleted='1'");
        j.exec("DELETE FROM rezepte where deleted='1'");
        j.exec("DELETE FROM heap where deleted='1'");
        j.exec("DELETE FROM auf where deleted='1'");
        j.exec("DELETE FROM heap2 where deleted='1'");
        j.exec("DELETE FROM logs where deleted='1'");
        j.exec("DELETE FROM xid where deleted='1'");
        j.exec("DELETE FROM etiketten where deleted='1'");
        j.exec("DELETE FROM CH_ELEXIS_OMNIVORE_DATA where deleted='1'");
        monitor.worked(workUnits);
    }

    private void doShakeKons(IProgressMonitor monitor, int workUnits) {
        try {
            monitor.subTask("Anonymisiere Konsultationen");
            Query qbe = new Query(Konsultation.class);
            List list = qbe.execute();
            int workPerKons = Math.round((float)workUnits * 0.8f) / list.size();
            Lipsum lipsum = new Lipsum();
            monitor.worked(Math.round((float)workUnits * 0.2f));
            for (Konsultation k : list) {
                VersionedResource vr = k.getEintrag();
                StringBuilder par = new StringBuilder();
                int numPars = (int)Math.round(3.0 * Math.random() + 1.0);
                while (numPars-- > 0) {
                    par.append(lipsum.getParagraph());
                }
                vr.update(par.toString(), "random contents");
                k.setEintrag(vr, true);
                k.purgeEintrag();
                if (!monitor.isCanceled()) {
                    monitor.worked(workPerKons);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            SWTHelper.showError((String)"Fehler", (String)e.getMessage());
        }
    }

    private void doShakeNames(IProgressMonitor monitor, int workUnits) {
        monitor.subTask("Anonymisiere Patienten und Kontakte");
        Query qbe = new Query(Kontakt.class);
        List list = qbe.execute();
        int workPerName = Math.round((float)workUnits * 0.8f) / list.size();
        Namen n = new Namen();
        monitor.worked(Math.round((float)workUnits * 0.2f));
        for (Kontakt k : list) {
            String vorname = "";
            if (this.zufallsnamen) {
                k.set("Bezeichnung1", n.getRandomNachname());
            } else {
                k.set("Bezeichnung1", this.getWord());
            }
            vorname = this.zufallsnamen ? n.getRandomVorname() : this.getWord();
            k.set("Bezeichnung2", vorname);
            if (k.istPerson()) {
                Person p = Person.load((String)k.getId());
                p.set("Geschlecht", StringTool.isFemale((String)vorname) ? "w" : "m");
            }
            k.set("Anschrift", "");
            k.set("Telefon1", this.getPhone());
            k.set("Telefon2", Math.random() > 0.6 ? this.getPhone() : "");
            k.set("NatelNr", Math.random() > 0.5 ? this.getPhone() : "");
            k.set("E-Mail", "");
            k.set("Ort", "");
            k.set("Strasse", "");
            k.set("Plz", "");
            k.set("Fax", Math.random() > 0.8 ? this.getPhone() : "");
            if (monitor.isCanceled()) break;
            monitor.worked(workPerName);
        }
    }

    private String getPhone() {
        StringBuilder ret = new StringBuilder();
        ret.append("555-");
        int i = 0;
        while (i < 7) {
            ret.append((char)Math.round(Math.random() * 9.0 + 48.0));
            ++i;
        }
        return ret.toString();
    }

    private String getWord() {
        int l = (int)Math.round(Math.random() * 5.0 + 5.0);
        StringBuilder ret = new StringBuilder();
        ret.append(Character.toUpperCase(this.getLetter()));
        int i = 0;
        while (i < l) {
            ret.append(this.getLetter());
            ++i;
        }
        return ret.toString();
    }

    private char getLetter() {
        return (char)Math.round(Math.random() * 25.0 + 97.0);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

