/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.regiomed.order.client.RegiomedOrderClient;
import ch.elexis.regiomed.order.config.RegiomedConfig;
import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.model.RegiomedProductLookupResponse;
import ch.elexis.regiomed.order.service.RegiomedLocalArticleService;
import ch.elexis.regiomed.order.service.RegiomedServerService;
import ch.elexis.regiomed.order.ui.RegiomedCheckController;
import ch.elexis.regiomed.order.ui.RegiomedCheckTemplate;
import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.BrowserFunction;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedCheckDialog
extends Dialog {
    private static final Logger log = LoggerFactory.getLogger(RegiomedCheckDialog.class);
    private final RegiomedCheckController controller;
    private final RegiomedServerService serverService = new RegiomedServerService();
    private final RegiomedLocalArticleService localArticleService = new RegiomedLocalArticleService();
    private boolean searchAvailable = false;
    private List<RegiomedProductLookupResponse.ProductResult> currentSearchResults = Collections.emptyList();
    private Browser browser;
    private Button okButton;

    public RegiomedCheckDialog(Shell parentShell, RegiomedOrderResponse response) {
        super(parentShell);
        this.controller = new RegiomedCheckController(response, this.serverService);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.initializeState();
    }

    private void initializeState() {
        try {
            RegiomedConfig config = RegiomedConfig.load();
            this.searchAvailable = new RegiomedOrderClient().checkSearchAvailability(config);
        }
        catch (Exception e) {
            log.warn("Could not check search availability", (Throwable)e);
            this.searchAvailable = false;
        }
        BusyIndicator.showWhile((Display)Display.getDefault(), () -> this.controller.loadMissingAlternatives());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RegiomedCheckDialog_Title);
        newShell.setImage(Images.IMG_LOGO.getImage());
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(area, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        new BrowserFunction(this.browser, "closeMainDialog"){

            public Object function(Object[] arguments) {
                Display.getDefault().asyncExec(() -> RegiomedCheckDialog.this.cancelPressed());
                return null;
            }
        };
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                if (event.location != null && event.location.startsWith("regiomed:")) {
                    RegiomedCheckDialog.this.handleBrowserAction(event.location);
                    event.doit = false;
                }
            }
        });
        this.browser.addTraverseListener(e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        });
        this.refreshBrowser();
        return area;
    }

    private void handleBrowserAction(String url) {
        String action;
        String[] parts = url.split(":");
        if (parts.length < 2) {
            return;
        }
        switch (action = parts[1]) {
            case "force": {
                if (parts.length < 4) break;
                this.controller.forceArticle(this.controller.makeKey(parts[2], parts[3]));
                this.updateStateAndUI();
                break;
            }
            case "reset": {
                if (parts.length < 4) break;
                this.controller.resetArticle(this.controller.makeKey(parts[2], parts[3]));
                this.updateStateAndUI();
                break;
            }
            case "updateQty": {
                this.handleUpdateQty(parts);
                break;
            }
            case "remove": {
                if (parts.length < 4) break;
                this.controller.removeArticle(this.controller.makeKey(parts[2], parts[3]));
                this.updateStateAndUI();
                break;
            }
            case "replace": {
                this.handleReplace(parts);
                break;
            }
            case "searchQuery": {
                this.handleSearchQuery(parts);
                break;
            }
            case "selectResult": {
                this.handleSelectResult(parts);
                break;
            }
            case "saveFilter": {
                if (parts.length <= 2) break;
                ConfigServiceHolder.get().setActiveUserContact("ch.elexis.regiomed.stockFilter", parts[2]);
                break;
            }
            default: {
                log.warn("Unknown Regiomed action: {}", (Object)action);
            }
        }
    }

    private void handleReplace(String[] parts) {
        RegiomedOrderResponse.AlternativeResult selectedAlt;
        if (parts.length < 6) {
            return;
        }
        String orgKey = this.controller.makeKey(parts[2], parts[3]);
        String newKey = this.controller.makeKey(parts[4], parts[5]);
        if (!this.controller.getReplacements().containsKey(orgKey) && (selectedAlt = this.findAlternativeByKey(newKey)) != null) {
            try {
                RegiomedOrderResponse.ArticleResult validated = this.serverService.validateReplacement(selectedAlt);
                if (validated != null) {
                    this.controller.replaceArticle(orgKey, newKey, selectedAlt.getDescription(), validated.getAvailableInventory());
                    this.updateStateAndUI();
                }
            }
            catch (Exception e) {
                this.showJsError(selectedAlt.getDescription(), e.getMessage());
            }
        }
    }

    private RegiomedOrderResponse.AlternativeResult findAlternativeByKey(String key) {
        RegiomedOrderResponse resp = this.controller.getResponse();
        if (resp.getAlternatives() != null) {
            for (RegiomedOrderResponse.AlternativeResult alt : resp.getAlternatives()) {
                String altKey = this.controller.makeKey(alt.getPharmaCode(), alt.getEanID());
                if (!altKey.equals(key)) continue;
                return alt;
            }
        }
        return null;
    }

    private void handleUpdateQty(String[] parts) {
        if (parts.length < 5) {
            return;
        }
        try {
            String pharma = parts[2];
            String ean = parts[3];
            int newQty = Integer.parseInt(parts[4]);
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> this.controller.updateQuantity(pharma, ean, newQty));
            this.updateStateAndUI();
        }
        catch (NumberFormatException e) {
            log.error("Invalid quantity format: {}", (Object)parts[4], (Object)e);
        }
    }

    private void handleSearchQuery(String[] parts) {
        if (parts.length < 3) {
            return;
        }
        String query = URLDecoder.decode(parts[2], StandardCharsets.UTF_8);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            try {
                RegiomedProductLookupResponse resp = this.serverService.searchProducts(query);
                HashMap<Integer, Map<String, Integer>> localStockMap = new HashMap<Integer, Map<String, Integer>>();
                ArrayList<IStock> allStocks = new ArrayList();
                try {
                    IStockService stockService = OsgiServiceUtil.getService(IStockService.class).orElse(null);
                    if (stockService != null) {
                        allStocks = stockService.getAllStocks(true, false);
                        if (resp != null && resp.products != null) {
                            int i = 0;
                            while (i < resp.products.size()) {
                                RegiomedProductLookupResponse.ProductResult p = resp.products.get(i);
                                IArticle localArticle = this.localArticleService.findLocalArticle(p.ean, p.pharmaCode, p.prodName);
                                if (localArticle != null) {
                                    HashMap<String, Integer> stocksForProduct = new HashMap<String, Integer>();
                                    for (IStock stock : allStocks) {
                                        IStockEntry entry = stockService.findStockEntryForArticleInStock(stock, localArticle);
                                        if (entry == null || entry.getCurrentStock() <= 0) continue;
                                        stocksForProduct.put(stock.getCode(), entry.getCurrentStock());
                                    }
                                    if (!stocksForProduct.isEmpty()) {
                                        localStockMap.put(i, stocksForProduct);
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    log.error("Error retrieving local stock information", (Throwable)ex);
                }
                this.currentSearchResults = resp != null && resp.products != null ? resp.products : Collections.emptyList();
                String lastFilter = ConfigServiceHolder.get().getActiveUserContact("ch.elexis.regiomed.stockFilter", "ALL");
                String rowsHtml = RegiomedCheckTemplate.generateSearchResultRows(this.currentSearchResults, localStockMap, allStocks, lastFilter);
                String safeHtml = rowsHtml.replace("'", "\\'").replace("\n", "");
                this.browser.execute("fillSearchResults('" + safeHtml + "');");
            }
            catch (Exception e) {
                log.error("Search failed", (Throwable)e);
                String errorRow = "<tr><td colspan='4' style='color:red'>" + Messages.RegiomedCheckDialog_ErrorLabel + ": " + e.getMessage().replace("'", "") + "</td></tr>";
                this.browser.execute("fillSearchResults('" + errorRow + "');");
            }
        });
    }

    private void handleSelectResult(String[] parts) {
        block6: {
            if (parts.length < 6) {
                return;
            }
            try {
                int index = Integer.parseInt(parts[2]);
                String orgPharma = parts[4];
                String orgEan = parts[5];
                if (index < 0 || index >= this.currentSearchResults.size()) break block6;
                RegiomedProductLookupResponse.ProductResult selected = this.currentSearchResults.get(index);
                try {
                    RegiomedOrderResponse.ArticleResult validated = this.serverService.validateReplacement(selected);
                    if (validated != null) {
                        String orgKey = this.controller.makeKey(orgPharma, orgEan);
                        String newKey = this.controller.makeKey(selected.pharmaCode, selected.ean);
                        this.controller.replaceArticle(orgKey, newKey, selected.prodName, validated.getAvailableInventory());
                        this.updateStateAndUI();
                    }
                }
                catch (Exception e) {
                    this.showJsError(selected.prodName, e.getMessage());
                }
            }
            catch (NumberFormatException e) {
                log.error("Invalid selection index", (Throwable)e);
            }
        }
    }

    private void updateStateAndUI() {
        boolean hasErrors;
        boolean bl = hasErrors = this.controller.getRemainingErrors() > 0;
        if (this.okButton != null && !this.okButton.isDisposed()) {
            this.okButton.setEnabled(!hasErrors);
        }
        this.refreshBrowser();
    }

    private void refreshBrowser() {
        if (this.browser != null && !this.browser.isDisposed()) {
            String html = RegiomedCheckTemplate.generateHtml(this.controller.getResponse(), this.searchAvailable, this.controller.getRemovedIdentifiers(), this.controller.getReplacements(), this.controller.getReplacementNames(), this.controller.getReplacementInventory(), this.controller.getForcedItems());
            this.browser.setText(html);
        }
    }

    private void showJsError(String prodName, String reason) {
        String msg = Messages.RegiomedCheckDialog_ItemRejected + "\n" + prodName + "\n\n" + Messages.RegiomedCheckDialog_Reason + " " + reason;
        String jsCall = "showErrorModal('" + this.escapeJs(Messages.RegiomedCheckDialog_NotOrderable) + "', '" + this.escapeJs(msg).replace("\n", "\\n") + "'); unlockLastRow();";
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.execute(jsCall);
        }
    }

    private String escapeJs(String text) {
        return text == null ? "" : text.replace("'", "\\'").replace("\"", "\\\"");
    }

    public List<RegiomedOrderResponse.ArticleResult> getDeletedArticles() {
        if (this.controller.getResponse().getArticles() == null) {
            return new ArrayList<RegiomedOrderResponse.ArticleResult>();
        }
        return this.controller.getResponse().getArticles().stream().filter(item -> this.controller.getRemovedIdentifiers().contains(this.controller.makeKey(item.getPharmaCode(), item.getEanID()))).collect(Collectors.toList());
    }

    public Map<String, String> getReplacements() {
        return this.controller.getReplacements();
    }

    public Set<String> getRemovedIdentifiers() {
        return this.controller.getRemovedIdentifiers();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, Messages.RegiomedCheckDialog_OrderBinding, true);
        this.createButton(parent, 1, Messages.RegiomedCheckDialog_Cancel, false);
        this.updateStateAndUI();
    }

    protected Point getInitialSize() {
        return new Point(950, 950);
    }
}

