/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.handler;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.exchange.ArticleUtil;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.BestellView;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.Bestellung;
import ch.elexis.data.PersistentObject;
import ch.elexis.regiomed.order.client.RegiomedOrderClient;
import ch.elexis.regiomed.order.config.RegiomedConfig;
import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderMapper;
import ch.elexis.regiomed.order.model.RegiomedOrderRequest;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.model.RegiomedResponseHelper;
import ch.elexis.regiomed.order.ui.RegiomedCheckDialog;
import ch.rgw.tools.StringTool;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedSender
implements IDataSender {
    private static final Logger log = LoggerFactory.getLogger(RegiomedSender.class);
    private static final String ABORT_BY_USER = "ABORT_BY_USER";
    private final List<IOrderEntry> exportedEntries = new ArrayList<IOrderEntry>();
    private final RegiomedOrderClient orderClient = new RegiomedOrderClient();
    private int counter;

    public boolean canHandle(Class<? extends PersistentObject> clazz) {
        return clazz.equals(Bestellung.class);
    }

    public XChangeElement store(Object output) throws XChangeException {
        if (output instanceof IOrder) {
            IOrder order = (IOrder)output;
            return this.addOrder(order);
        }
        throw new XChangeException("Can't handle object of class " + output.getClass().getName());
    }

    public void finalizeExport() throws XChangeException {
        if (this.counter == 0) {
            log.info("Order contains no articles to order from Regiomed supplier");
            return;
        }
        try {
            RegiomedConfig config = RegiomedConfig.load();
            RegiomedOrderMapper mapper = new RegiomedOrderMapper();
            RegiomedOrderRequest request = mapper.mapToRequest(config, this.exportedEntries);
            RegiomedOrderResponse response = this.orderClient.sendOrderWithToken(config, request);
            if (request.isCheckOrder()) {
                response = this.processInteractiveOrder(config, response);
            } else {
                this.processDirectOrder(response);
            }
            this.finalizeOrder(response);
        }
        catch (Exception ex) {
            this.handleExportException(ex);
        }
    }

    private RegiomedOrderResponse processInteractiveOrder(RegiomedConfig config, RegiomedOrderResponse initialResponse) throws Exception {
        RegiomedCheckDialog dialog = new RegiomedCheckDialog(Display.getDefault().getActiveShell(), initialResponse);
        if (dialog.open() != 0) {
            throw new XChangeException(ABORT_BY_USER);
        }
        this.handleDialogChanges(dialog, initialResponse);
        if (this.exportedEntries.isEmpty()) {
            SWTHelper.showInfo((String)Messages.RegiomedSender_AbortTitle, (String)Messages.RegiomedSender_AllArticlesDeleted);
            throw new XChangeException(ABORT_BY_USER);
        }
        RegiomedOrderMapper mapper = new RegiomedOrderMapper();
        RegiomedOrderRequest finalRequest = mapper.mapToRequest(config, this.exportedEntries);
        finalRequest.setCheckOrder(false);
        RegiomedOrderResponse finalResponse = this.orderClient.sendOrderWithToken(config, finalRequest);
        if (!finalResponse.isOrderSent() && !RegiomedResponseHelper.isOverallSuccess(finalResponse)) {
            String err = RegiomedResponseHelper.buildErrorMessage(finalResponse);
            log.error("Regiomed Final Order error: {}", (Object)err);
            throw new XChangeException(err);
        }
        return finalResponse;
    }

    private void processDirectOrder(RegiomedOrderResponse response) throws XChangeException {
        if (!response.isOrderSent() && !RegiomedResponseHelper.isOverallSuccess(response)) {
            String err = RegiomedResponseHelper.buildErrorMessage(response);
            log.error("Regiomed Direct Order error: {}", (Object)err);
            throw new XChangeException(err);
        }
    }

    private void finalizeOrder(RegiomedOrderResponse response) {
        if (response.getArticlesNOK() > 0) {
            String msg = MessageFormat.format(Messages.RegiomedSender_OrderPartiallySentText, response.getArticlesOK(), response.getArticlesNOK());
            SWTHelper.showInfo((String)Messages.RegiomedSender_OrderPartiallySentTitle, (String)msg);
        } else if (!CoreUtil.isTestMode()) {
            SWTHelper.showInfo((String)Messages.RegiomedSender_SuccessTitle, (String)Messages.RegiomedSender_SuccessText);
        }
        this.updateOrderEntriesStatus(this.exportedEntries, response);
        this.exportedEntries.clear();
    }

    private void handleDialogChanges(RegiomedCheckDialog dialog, RegiomedOrderResponse response) {
        Map<String, String> replacements;
        this.updateQuantities(response);
        Set<String> deletedIds = dialog.getRemovedIdentifiers();
        if (!deletedIds.isEmpty()) {
            this.removeDeletedEntries(deletedIds);
        }
        if (!(replacements = dialog.getReplacements()).isEmpty()) {
            this.applyReplacements(replacements);
        }
    }

    private void handleExportException(Exception ex) throws XChangeException {
        if (ex instanceof XChangeException && ABORT_BY_USER.equals(ex.getMessage())) {
            throw (XChangeException)ex;
        }
        String err = ex.getMessage();
        ElexisStatus status = new ElexisStatus(2, "ch.elexis.regiomed.order", 0, err, null, 2);
        StatusManager.getManager().handle((IStatus)status);
        String msg = Messages.RegiomedSender_ErrorSending;
        if (StringUtils.isNotBlank((CharSequence)err)) {
            msg = err;
        }
        log.error("Order could not be sent to Regiomed.", (Throwable)ex);
        SWTHelper.alert((String)Messages.RegiomedSender_ErrorTitle, (String)msg);
        throw new XChangeException(msg);
    }

    private XChangeElement addOrder(IOrder order) throws XChangeException {
        this.counter = 0;
        this.exportedEntries.clear();
        if (order == null || order.getEntries() == null || order.getEntries().isEmpty()) {
            throw new XChangeException(Messages.RegiomedSender_OrderEmpty);
        }
        String supplierCfg = ConfigServiceHolder.getGlobal((String)"ch.elexis.regiomed.order/supplier", (String)"");
        IContact regiomedSupplier = BestellView.resolveDefaultSupplier((String)supplierCfg, (String)Messages.RegiomedSender_NoSupplierTitle);
        if (regiomedSupplier == null) {
            return null;
        }
        for (IOrderEntry item : order.getEntries()) {
            if (!regiomedSupplier.equals(item.getProvider())) continue;
            this.validateAndAddEntry(item);
        }
        if (this.counter == 0) {
            throw new XChangeException(Messages.RegiomedSender_NoArticlesForSupplier);
        }
        return null;
    }

    private void validateAndAddEntry(IOrderEntry item) throws XChangeException {
        IArticle artikel = item.getArticle();
        String pharmacode = ArticleUtil.getPharmaCode((IArticle)artikel);
        String eanId = ArticleUtil.getEan((IArticle)artikel);
        int quantity = item.getAmount();
        boolean hasPharmacode = !StringTool.isNothing((Object)pharmacode);
        boolean hasEan = StringUtils.isNotBlank((CharSequence)eanId);
        if (!hasPharmacode && !hasEan || quantity < 1) {
            String description = artikel.getName();
            StringBuilder msg = new StringBuilder();
            msg.append(MessageFormat.format(Messages.RegiomedSender_ArticleNotConfigured, StringUtils.defaultString((String)description)));
            if (!hasPharmacode && !hasEan) {
                msg.append(Messages.RegiomedSender_NoPharmaNoEan);
            } else if (!hasPharmacode) {
                msg.append(Messages.RegiomedSender_NoPharma);
            } else if (!hasEan) {
                msg.append(Messages.RegiomedSender_NoEan);
            }
            if (quantity < 1) {
                msg.append(Messages.RegiomedSender_InvalidAmount);
            }
            msg.append(Messages.RegiomedSender_PleaseCorrect);
            SWTHelper.alert((String)Messages.RegiomedSender_BadArticleTitle, (String)msg.toString());
            throw new XChangeException("Bad Article Config: Pharmacode: " + pharmacode + ", EAN: " + eanId + ", Name: " + description + ", Quantity: " + quantity);
        }
        this.exportedEntries.add(item);
        ++this.counter;
    }

    private void updateQuantities(RegiomedOrderResponse response) {
        if (response == null || response.getArticles() == null) {
            return;
        }
        block0: for (IOrderEntry entry : this.exportedEntries) {
            IArticle art = entry.getArticle();
            String pCode = this.cleanId(ArticleUtil.getPharmaCode((IArticle)art));
            String ean = this.cleanId(ArticleUtil.getEan((IArticle)art));
            for (RegiomedOrderResponse.ArticleResult res : response.getArticles()) {
                boolean match;
                String resPCode = String.valueOf(res.getPharmaCode());
                String resEan = String.valueOf(res.getEanID());
                boolean bl = match = StringUtils.isNotBlank((CharSequence)pCode) && pCode.equals(resPCode) || StringUtils.isNotBlank((CharSequence)ean) && ean.equals(resEan);
                if (!match) continue;
                if (entry.getAmount() == res.getQuantity()) continue block0;
                log.info("Regiomed: Menge ge\u00e4ndert f\u00fcr {} von {} auf {}", new Object[]{art.getLabel(), entry.getAmount(), res.getQuantity()});
                entry.setAmount(res.getQuantity());
                CoreModelServiceHolder.get().save((Identifiable)entry);
                continue block0;
            }
        }
    }

    private void applyReplacements(Map<String, String> replacements) {
        for (IOrderEntry entry : this.exportedEntries) {
            String newIds;
            String[] parts;
            String ean;
            IArticle art = entry.getArticle();
            String pCode = this.cleanId(ArticleUtil.getPharmaCode((IArticle)art));
            String key = pCode + ":" + (ean = this.cleanId(ArticleUtil.getEan((IArticle)art)));
            if (!replacements.containsKey(key) || (parts = (newIds = replacements.get(key)).split(":")).length < 1) continue;
            String newPharma = parts[0];
            String newEan = parts.length > 1 ? parts[1] : null;
            Optional<Object> optArticle = Optional.empty();
            if (StringUtils.isNotBlank((CharSequence)newEan) && !"0".equals(newEan)) {
                optArticle = this.findArticle(newEan);
            }
            if (optArticle.isEmpty() && StringUtils.isNotBlank((CharSequence)newPharma) && !"0".equals(newPharma)) {
                Object searchPharma = newPharma;
                if (newPharma.length() == 6 && StringUtils.isNumeric((CharSequence)newPharma)) {
                    searchPharma = "0" + newPharma;
                }
                if ((optArticle = this.findArticle((String)searchPharma)).isEmpty() && !((String)searchPharma).equals(newPharma)) {
                    optArticle = this.findArticle(newPharma);
                }
            }
            if (optArticle.isPresent()) {
                IArticle newArticle = (IArticle)optArticle.get();
                log.info("Regiomed: Replacing article {} with alternative {}", (Object)art.getLabel(), (Object)newArticle.getLabel());
                entry.setArticle(newArticle);
                CoreModelServiceHolder.get().save((Identifiable)entry);
                continue;
            }
            log.warn("Regiomed: Alternative not found locally. EAN: {}, Pharma: {}", (Object)newEan, (Object)newPharma);
            String errorMsg = MessageFormat.format(Messages.RegiomedSender_AlternativeNotFoundLocally, (String)(StringUtils.isNotBlank((CharSequence)newEan) ? "EAN: " + newEan : "") + " / Pharma: " + newPharma);
            SWTHelper.showError((String)Messages.RegiomedSender_WarningTitle, (String)errorMsg);
        }
    }

    private void removeDeletedEntries(Set<String> deletedIds) {
        Iterator<IOrderEntry> it = this.exportedEntries.iterator();
        while (it.hasNext()) {
            IOrderEntry entry = it.next();
            IArticle art = entry.getArticle();
            String key = this.cleanId(ArticleUtil.getPharmaCode((IArticle)art)) + ":" + this.cleanId(ArticleUtil.getEan((IArticle)art));
            if (!deletedIds.contains(key)) continue;
            it.remove();
            this.deleteSingleEntry(entry);
        }
    }

    private void deleteSingleEntry(IOrderEntry entry) {
        try {
            IOrder order = entry.getOrder();
            if (order != null) {
                IOrderService orderService = (IOrderService)OsgiServiceUtil.getService(IOrderService.class).orElseThrow(() -> new IllegalStateException("no order service found"));
                orderService.getHistoryService().logRemove(order, entry);
                order.getEntries().remove(entry);
                CoreModelServiceHolder.get().delete((Deleteable)entry);
            }
        }
        catch (Exception e) {
            log.error("Error deleting OrderEntry", (Throwable)e);
        }
    }

    private void updateOrderEntriesStatus(List<IOrderEntry> entries, RegiomedOrderResponse response) {
        if (response == null || response.getArticles() == null) {
            for (IOrderEntry entry : entries) {
                entry.setState(OrderEntryState.ORDERED);
                CoreModelServiceHolder.get().save((Identifiable)entry);
            }
            return;
        }
        ArrayList<IOrderEntry> entriesToDelete = new ArrayList<IOrderEntry>();
        for (IOrderEntry entry : entries) {
            boolean isSuccess = false;
            boolean foundInResponse = false;
            IArticle art = entry.getArticle();
            String pharmaStr = ArticleUtil.getPharmaCode((IArticle)art);
            String eanStr = ArticleUtil.getEan((IArticle)art);
            for (RegiomedOrderResponse.ArticleResult res : response.getArticles()) {
                if (StringUtils.isNotBlank((CharSequence)pharmaStr) && String.valueOf(res.getPharmaCode()).equals(pharmaStr)) {
                    isSuccess = res.isSuccess();
                    foundInResponse = true;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)eanStr) || !String.valueOf(res.getEanID()).equals(eanStr)) continue;
                isSuccess = res.isSuccess();
                foundInResponse = true;
                break;
            }
            if (isSuccess) {
                entry.setState(OrderEntryState.ORDERED);
                CoreModelServiceHolder.get().save((Identifiable)entry);
                continue;
            }
            if (!foundInResponse || isSuccess) continue;
            entriesToDelete.add(entry);
        }
        for (IOrderEntry toDelete : entriesToDelete) {
            this.deleteSingleEntry(toDelete);
        }
    }

    private Optional<IArticle> findArticle(String scanCode) {
        if (StringUtils.isBlank((CharSequence)scanCode) || "0".equals(scanCode)) {
            return Optional.empty();
        }
        List contributions = CodeElementServiceHolder.get().getContributionsByTyp(ICodeElementService.CodeElementTyp.ARTICLE);
        for (ICodeElementServiceContribution contribution : contributions) {
            Optional loadFromCode = contribution.loadFromCode(scanCode);
            if (!loadFromCode.isPresent() || !(loadFromCode.get() instanceof IArticle)) continue;
            return loadFromCode.map(IArticle.class::cast);
        }
        return Optional.empty();
    }

    private String cleanId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "0";
        }
        return id.replaceFirst("^0+(?!$)", "");
    }

    /*
     * WARNING - void declaration
     */
    public boolean canHandle(Identifiable identifiable) {
        String[] supplierIds;
        if (!(identifiable instanceof IOrder)) {
            return false;
        }
        IOrder iOrder = (IOrder)identifiable;
        String cfg = ConfigServiceHolder.getGlobal((String)"ch.elexis.regiomed.order/supplier", (String)"");
        if (StringUtils.isBlank((CharSequence)cfg)) {
            return false;
        }
        String[] stringArray = supplierIds = StringUtils.split((String)cfg, (char)',');
        int n = supplierIds.length;
        int n2 = 0;
        while (n2 < n) {
            void order;
            String supplierId = stringArray[n2];
            IContact supplier = CoreModelServiceHolder.get().load(supplierId, IContact.class).orElse(null);
            if (supplier != null && OrderServiceHolder.get().containsSupplier((IOrder)order, supplier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

