/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.config;

import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;

public class RegiomedConfig {
    private final String baseUrl;
    private final String clientId;
    private final String email;
    private final String password;
    private final boolean checkOrder;
    private final boolean errorEmailEnabled;
    private final String errorEmailAddress;

    public RegiomedConfig(String baseUrl, String clientId, String email, String password, boolean checkOrder, boolean errorEmailEnabled, String errorEmailAddress) {
        this.baseUrl = baseUrl;
        this.clientId = clientId;
        this.email = email;
        this.password = password;
        this.checkOrder = checkOrder;
        this.errorEmailEnabled = errorEmailEnabled;
        this.errorEmailAddress = errorEmailAddress;
    }

    public static RegiomedConfig load() {
        IConfigService cfg = ConfigServiceHolder.get();
        String baseUrl = cfg.get("regiomed/baseUrl", "https://www.dispomanager.ch/LiveService");
        String clientId = cfg.get("regiomed/clientId", "");
        String email = cfg.get("regiomed/email", "");
        String password = cfg.get("regiomed/password", "");
        boolean checkOrder = cfg.get("ch.elexis.regiomed.checkOrder", true);
        boolean errorEmailEnabled = cfg.get("regiomed/errorEmailEnabled", false);
        String errorEmailAddress = cfg.get("regiomed/errorEmailAddress", "");
        return new RegiomedConfig(baseUrl, clientId, email, password, checkOrder, errorEmailEnabled, errorEmailAddress);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCheckOrder() {
        return this.checkOrder;
    }

    public boolean isErrorEmailEnabled() {
        return this.errorEmailEnabled;
    }

    public String getErrorEmailAddress() {
        return this.errorEmailAddress;
    }

    public String getTokenEndpoint() {
        return this.appendPath("/Token/Create");
    }

    public String getOrderEndpoint() {
        return this.appendPath("/ExternalOrders/DMO");
    }

    public String getFuzzySearchEndpoint() {
        return this.appendPath("/Article/FuzzySearch/");
    }

    public String getAlternativesFlexEndpoint() {
        return this.appendPath("/Article/AlternativesFlex/");
    }

    private String appendPath(String path) {
        if (this.baseUrl.endsWith("/")) {
            return this.baseUrl.substring(0, this.baseUrl.length() - 1) + path;
        }
        return this.baseUrl + path;
    }
}

