/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.regiomed.order.client.RegiomedOrderClient;
import ch.elexis.regiomed.order.config.RegiomedConfig;
import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedAlternativesResponse;
import ch.elexis.regiomed.order.model.RegiomedOrderRequest;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.model.RegiomedProductLookupResponse;
import ch.elexis.regiomed.order.ui.RegiomedCheckTemplate;
import com.equo.chromium.swt.Browser;
import com.equo.chromium.swt.BrowserFunction;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedCheckDialog
extends Dialog {
    private static final Logger log = LoggerFactory.getLogger(RegiomedCheckDialog.class);
    private final RegiomedOrderResponse response;
    private final Set<String> removedIdentifiers = new HashSet<String>();
    private final Map<String, String> replacements = new HashMap<String, String>();
    private final Map<String, String> replacementNames = new HashMap<String, String>();
    private final Set<String> forcedItems = new HashSet<String>();
    private final Set<String> articlesWithAlternatives = new HashSet<String>();
    private boolean searchAvailable = false;
    private int remainingErrors = 0;
    private List<RegiomedProductLookupResponse.ProductResult> currentSearchResults = Collections.emptyList();
    private Browser browser;
    private Button okButton;

    public RegiomedCheckDialog(Shell parentShell, RegiomedOrderResponse response) {
        super(parentShell);
        this.response = response;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.initializeState();
    }

    private void initializeState() {
        try {
            RegiomedConfig config = RegiomedConfig.load();
            this.searchAvailable = new RegiomedOrderClient().checkSearchAvailability(config);
        }
        catch (Exception e) {
            log.warn("Could not check search availability", (Throwable)e);
            this.searchAvailable = false;
        }
        if (this.response.getAlternatives() != null) {
            this.response.getAlternatives().forEach(alt -> {
                boolean bl = this.articlesWithAlternatives.add(this.makeKey(alt.getPharmaCodeOrg(), alt.getEanIDOrg()));
            });
        }
        this.recalcErrors();
        this.loadMissingAlternativesForErrors();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RegiomedCheckDialog_Title);
        newShell.setImage(Images.IMG_LOGO.getImage());
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout(1, false));
        this.browser = new Browser(area, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        new BrowserFunction(this.browser, "closeMainDialog"){

            public Object function(Object[] arguments) {
                Display.getDefault().asyncExec(() -> RegiomedCheckDialog.this.cancelPressed());
                return null;
            }
        };
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                if (event.location != null && event.location.startsWith("regiomed:")) {
                    RegiomedCheckDialog.this.handleBrowserAction(event.location);
                    event.doit = false;
                }
            }
        });
        this.browser.addTraverseListener(e -> {
            if (e.detail == 2) {
                e.doit = false;
            }
        });
        this.refreshBrowser();
        return area;
    }

    private void handleBrowserAction(String url) {
        String action;
        String[] parts = url.split(":");
        if (parts.length < 2) {
            return;
        }
        switch (action = parts[1]) {
            case "force": {
                this.handleForce(parts);
                break;
            }
            case "reset": {
                this.handleReset(parts);
                break;
            }
            case "updateQty": {
                this.handleUpdateQty(parts);
                break;
            }
            case "remove": {
                this.handleRemove(parts);
                break;
            }
            case "replace": {
                this.handleReplace(parts);
                break;
            }
            case "searchQuery": {
                this.handleSearchQuery(parts);
                break;
            }
            case "selectResult": {
                this.handleSelectResult(parts);
                break;
            }
            default: {
                log.warn("Unknown Regiomed action: {}", (Object)action);
            }
        }
    }

    private void handleReset(String[] parts) {
        if (parts.length < 4) {
            return;
        }
        String key = this.makeKey(parts[2], parts[3]);
        boolean changed = false;
        if (this.removedIdentifiers.contains(key)) {
            this.removedIdentifiers.remove(key);
            changed = true;
        }
        if (this.replacements.containsKey(key)) {
            this.replacements.remove(key);
            this.replacementNames.remove(key);
            changed = true;
        }
        if (this.forcedItems.contains(key)) {
            this.forcedItems.remove(key);
            changed = true;
        }
        if (changed) {
            this.updateStateAndUI();
        }
    }

    private void handleForce(String[] parts) {
        if (parts.length < 4) {
            return;
        }
        String key = this.makeKey(parts[2], parts[3]);
        this.forcedItems.add(key);
        this.updateStateAndUI();
    }

    private void handleRemove(String[] parts) {
        if (parts.length < 4) {
            return;
        }
        String key = this.makeKey(parts[2], parts[3]);
        if (!this.removedIdentifiers.contains(key)) {
            this.removedIdentifiers.add(key);
            this.replacements.remove(key);
            this.forcedItems.remove(key);
            this.updateStateAndUI();
        }
    }

    private void handleReplace(String[] parts) {
        RegiomedOrderResponse.AlternativeResult selectedAlt;
        if (parts.length < 6) {
            return;
        }
        String orgKey = this.makeKey(parts[2], parts[3]);
        String newKey = this.makeKey(parts[4], parts[5]);
        if (!this.replacements.containsKey(orgKey) && (selectedAlt = this.findAlternativeByKey(newKey)) != null) {
            boolean allowed = this.validateReplacementWithServer(selectedAlt);
            if (!allowed) {
                return;
            }
            this.replacements.put(orgKey, newKey);
            this.replacementNames.put(orgKey, selectedAlt.getDescription());
            this.forcedItems.remove(orgKey);
            this.updateStateAndUI();
        }
    }

    private RegiomedOrderResponse.AlternativeResult findAlternativeByKey(String key) {
        if (this.response.getAlternatives() != null) {
            for (RegiomedOrderResponse.AlternativeResult alt : this.response.getAlternatives()) {
                String altKey = this.makeKey(alt.getPharmaCode(), alt.getEanID());
                if (!altKey.equals(key)) continue;
                return alt;
            }
        }
        return null;
    }

    private void handleUpdateQty(String[] parts) {
        if (parts.length < 5) {
            return;
        }
        try {
            String pharma = parts[2];
            String ean = parts[3];
            int newQty = Integer.parseInt(parts[4]);
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> this.performQuantityUpdate(pharma, ean, newQty));
        }
        catch (NumberFormatException e) {
            log.error("Invalid quantity format: {}", (Object)parts[4], (Object)e);
        }
    }

    private void handleSearchQuery(String[] parts) {
        if (parts.length < 3) {
            return;
        }
        String query = URLDecoder.decode(parts[2], StandardCharsets.UTF_8);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            try {
                RegiomedConfig config = RegiomedConfig.load();
                RegiomedOrderClient client = new RegiomedOrderClient();
                RegiomedProductLookupResponse resp = client.searchProducts(config, query);
                this.currentSearchResults = resp != null && resp.products != null ? resp.products : Collections.emptyList();
                String rowsHtml = RegiomedCheckTemplate.generateSearchResultRows(this.currentSearchResults);
                String safeHtml = rowsHtml.replace("'", "\\'").replace("\n", "");
                this.browser.execute("fillSearchResults('" + safeHtml + "');");
            }
            catch (Exception e) {
                log.error("Search failed", (Throwable)e);
                String errorRow = "<tr><td colspan='4' style='color:red'>" + Messages.RegiomedCheckDialog_ErrorLabel + ": " + e.getMessage().replace("'", "") + "</td></tr>";
                this.browser.execute("fillSearchResults('" + errorRow + "');");
            }
        });
    }

    private void handleSelectResult(String[] parts) {
        if (parts.length < 6) {
            return;
        }
        try {
            int index = Integer.parseInt(parts[2]);
            String orgPharma = parts[4];
            String orgEan = parts[5];
            if (index >= 0 && index < this.currentSearchResults.size()) {
                RegiomedProductLookupResponse.ProductResult selected = this.currentSearchResults.get(index);
                boolean allowed = this.validateReplacementWithServer(selected);
                if (!allowed) {
                    return;
                }
                String orgKey = this.makeKey(orgPharma, orgEan);
                String newKey = this.makeKey(selected.pharmaCode, (Object)selected.ean);
                this.replacements.put(orgKey, newKey);
                this.replacementNames.put(orgKey, selected.prodName);
                this.forcedItems.remove(orgKey);
                this.updateStateAndUI();
            }
        }
        catch (NumberFormatException e) {
            log.error("Invalid selection index", (Throwable)e);
        }
    }

    private void updateStateAndUI() {
        this.recalcErrors();
        this.updateOkButtonState();
        this.refreshBrowser();
    }

    private void refreshBrowser() {
        if (this.browser != null && !this.browser.isDisposed()) {
            String html = RegiomedCheckTemplate.generateHtml(this.response, this.searchAvailable, this.removedIdentifiers, this.replacements, this.replacementNames, this.forcedItems);
            this.browser.setText(html);
        }
    }

    private void performQuantityUpdate(String pharma, String ean, int newQty) {
        if (this.response.getArticles() == null) {
            return;
        }
        boolean updated = false;
        for (RegiomedOrderResponse.ArticleResult art : this.response.getArticles()) {
            boolean isStockOK;
            if (!String.valueOf(art.getPharmaCode()).equals(pharma) || !String.valueOf(art.getEanID()).equals(ean)) continue;
            art.setQuantity(newQty);
            updated = true;
            boolean bl = isStockOK = art.getAvailableInventory() <= 0 || newQty <= art.getAvailableInventory();
            if (art.isSuccess() && isStockOK) {
                art.setSuccessAvailability(true);
                art.setAvailState(Messages.RegiomedCheckDialog_Yes);
                art.setAvailMsg(Messages.RegiomedCheckDialog_AvailableQtyAdjusted);
                break;
            }
            if (!art.isSuccess() || isStockOK) break;
            art.setSuccessAvailability(false);
            art.setAvailState(Messages.RegiomedCheckDialog_No);
            art.setAvailMsg(MessageFormat.format(Messages.RegiomedCheckDialog_QtyExceedsStock, newQty, art.getAvailableInventory()));
            String key = this.makeKey(pharma, ean);
            if (this.articlesWithAlternatives.contains(key)) break;
            this.fetchMissingAlternatives(art);
            break;
        }
        if (updated) {
            this.updateStateAndUI();
        }
    }

    private void recalcErrors() {
        this.remainingErrors = 0;
        if (this.response.getArticles() != null) {
            for (RegiomedOrderResponse.ArticleResult a : this.response.getArticles()) {
                if (!this.isCalculatedError(a)) continue;
                ++this.remainingErrors;
            }
        }
    }

    private boolean isCalculatedError(RegiomedOrderResponse.ArticleResult a) {
        String key = this.makeKey(a.getPharmaCode(), a.getEanID());
        if (this.removedIdentifiers.contains(key)) {
            return false;
        }
        if (this.replacements.containsKey(key)) {
            return false;
        }
        if (this.forcedItems.contains(key)) {
            return false;
        }
        if (!a.isSuccess()) {
            return true;
        }
        if (a.getAvailableInventory() > 0 && a.getQuantity() > a.getAvailableInventory()) {
            return true;
        }
        boolean hasAlternatives = this.articlesWithAlternatives.contains(key);
        if (hasAlternatives) {
            return !a.isSuccessAvailability();
        }
        return false;
    }

    private void fetchMissingAlternatives(RegiomedOrderResponse.ArticleResult art) {
        try {
            RegiomedOrderClient client = new RegiomedOrderClient();
            RegiomedAlternativesResponse altResp = client.getAlternatives(RegiomedConfig.load(), "PCAVAIL", String.valueOf(art.getPharmaCode()));
            if (altResp != null && altResp.getAlternatives() != null && !altResp.getAlternatives().isEmpty()) {
                if (this.response.getAlternatives() == null) {
                    this.response.setAlternatives(new ArrayList<RegiomedOrderResponse.AlternativeResult>());
                }
                List converted = altResp.getAlternatives().stream().map(item -> {
                    RegiomedOrderResponse.AlternativeResult res = new RegiomedOrderResponse.AlternativeResult();
                    res.setPharmaCodeOrg(art.getPharmaCode());
                    res.setEanIDOrg(art.getEanID());
                    res.setDescriptionOrg(art.getDescription());
                    res.setPharmaCode(item.getPharmaCode());
                    res.setEanID(item.getEan());
                    res.setDescription(item.getProdName());
                    res.setPrice(item.getPrice());
                    res.setAvailState(item.getAvailState());
                    res.setAvailMsg(item.getAvailMessage());
                    res.setAltType(item.getAltType());
                    return res;
                }).collect(Collectors.toList());
                this.response.getAlternatives().addAll(converted);
                this.articlesWithAlternatives.add(this.makeKey(art.getPharmaCode(), art.getEanID()));
            }
        }
        catch (Exception e) {
            log.error("Error fetching alternatives for article {}", (Object)art.getPharmaCode(), (Object)e);
        }
    }

    private void loadMissingAlternativesForErrors() {
        if (this.response.getArticles() == null) {
            return;
        }
        List toLoad = this.response.getArticles().stream().filter(this::isCalculatedError).filter(a -> !this.articlesWithAlternatives.contains(this.makeKey(a.getPharmaCode(), a.getEanID()))).collect(Collectors.toList());
        if (!toLoad.isEmpty()) {
            BusyIndicator.showWhile((Display)(this.getShell() != null ? this.getShell().getDisplay() : null), () -> {
                for (RegiomedOrderResponse.ArticleResult a : toLoad) {
                    this.fetchMissingAlternatives(a);
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateReplacementWithServer(RegiomedProductLookupResponse.ProductResult selected) {
        try {
            RegiomedConfig config = RegiomedConfig.load();
            RegiomedOrderClient client = new RegiomedOrderClient();
            RegiomedOrderRequest request = new RegiomedOrderRequest();
            request.setUserEmail(config.getEmail());
            request.setCheckOrder(true);
            request.setDeliveryType("DEFAULT");
            RegiomedOrderRequest.Article art = new RegiomedOrderRequest.Article();
            art.setPharmaCode(selected.pharmaCode);
            try {
                art.setEanID(StringUtils.isNotBlank((CharSequence)selected.ean) ? Long.parseLong(selected.ean) : 0L);
            }
            catch (Exception e) {
                art.setEanID(0L);
            }
            art.setDescription(selected.prodName);
            art.setQuantity(1);
            request.getArticles().add(art);
            RegiomedOrderResponse resp = client.sendOrderWithToken(config, request);
            if (resp != null && resp.getArticles() != null) {
                for (RegiomedOrderResponse.ArticleResult res : resp.getArticles()) {
                    if (res.getPharmaCode() != selected.pharmaCode || res.isSuccess()) continue;
                    this.showJsError(selected.prodName, Objects.toString(res.getInfo(), Messages.RegiomedCheckDialog_UnknownError));
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error("Server validation failed", (Throwable)e);
            SWTHelper.showError((String)Messages.RegiomedCheckDialog_ErrorLabel, (String)(Messages.RegiomedCheckDialog_ServerValidationFailed + " " + e.getMessage()));
            return false;
        }
    }

    private boolean validateReplacementWithServer(RegiomedOrderResponse.AlternativeResult alt) {
        RegiomedProductLookupResponse.ProductResult temp = new RegiomedProductLookupResponse.ProductResult();
        temp.pharmaCode = alt.getPharmaCode();
        temp.ean = String.valueOf(alt.getEanID());
        temp.prodName = alt.getDescription();
        return this.validateReplacementWithServer(temp);
    }

    private void showJsError(String prodName, String reason) {
        String msg = Messages.RegiomedCheckDialog_ItemRejected + "\n" + prodName + "\n\n" + Messages.RegiomedCheckDialog_Reason + " " + reason;
        String jsCall = "showErrorModal('" + this.escapeJs(Messages.RegiomedCheckDialog_NotOrderable) + "', '" + this.escapeJs(msg).replace("\n", "\\n") + "'); unlockLastRow();";
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.execute(jsCall);
        }
    }

    private String escapeJs(String text) {
        return text == null ? "" : text.replace("'", "\\'").replace("\"", "\\\"");
    }

    private String makeKey(Object pharma, Object ean) {
        return this.makeKey(String.valueOf(pharma), String.valueOf(ean));
    }

    private String makeKey(String pharma, String ean) {
        return (String)StringUtils.defaultIfBlank((CharSequence)pharma, (CharSequence)"0") + ":" + (String)StringUtils.defaultIfBlank((CharSequence)ean, (CharSequence)"0");
    }

    public List<RegiomedOrderResponse.ArticleResult> getDeletedArticles() {
        if (this.response.getArticles() == null) {
            return new ArrayList<RegiomedOrderResponse.ArticleResult>();
        }
        return this.response.getArticles().stream().filter(item -> this.removedIdentifiers.contains(this.makeKey(item.getPharmaCode(), item.getEanID()))).collect(Collectors.toList());
    }

    public Map<String, String> getReplacements() {
        return this.replacements;
    }

    public Set<String> getRemovedIdentifiers() {
        return this.removedIdentifiers;
    }

    private void updateOkButtonState() {
        if (this.okButton != null && !this.okButton.isDisposed()) {
            this.okButton.setEnabled(this.remainingErrors <= 0);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, Messages.RegiomedCheckDialog_OrderBinding, true);
        this.createButton(parent, 1, Messages.RegiomedCheckDialog_Cancel, false);
        this.updateOkButtonState();
    }

    protected Point getInitialSize() {
        return new Point(950, 950);
    }
}

