/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.preferences;

import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.preferences.inputs.KontaktFieldEditor;
import ch.elexis.regiomed.order.messages.Messages;
import ch.rgw.tools.StringTool;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RegiomedPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor baseUrlEditor;
    private StringFieldEditor clientIdEditor;
    private StringFieldEditor emailEditor;
    private StringFieldEditor passwordEditor;
    private BooleanFieldEditor errorMailEnabledEditor;
    private StringFieldEditor errorMailAddressEditor;

    public RegiomedPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        this.setDescription(Messages.RegiomedPreferencePage_Description);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.baseUrlEditor = new StringFieldEditor("regiomed/baseUrl", Messages.RegiomedPreferencePage_ServiceUrlLabel, parent);
        this.addField((FieldEditor)this.baseUrlEditor);
        this.clientIdEditor = new StringFieldEditor("regiomed/clientId", Messages.RegiomedPreferencePage_ClientIdLabel, parent);
        this.addField((FieldEditor)this.clientIdEditor);
        this.emailEditor = new StringFieldEditor("regiomed/email", Messages.RegiomedPreferencePage_EmailUserLabel, parent);
        this.addField((FieldEditor)this.emailEditor);
        this.passwordEditor = new StringFieldEditor("regiomed/password", Messages.RegiomedPreferencePage_PasswordLabel, parent);
        this.passwordEditor.getTextControl(parent).setEchoChar('*');
        this.addField((FieldEditor)this.passwordEditor);
        this.addField((FieldEditor)new KontaktFieldEditor(new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL), "ch.elexis.regiomed.order/supplier", Messages.RegiomedPreferencePage_SupplierLabel, parent));
        this.errorMailEnabledEditor = new BooleanFieldEditor("regiomed/errorEmailEnabled", Messages.RegiomedPreferencePage_ErrorMailCheckbox, parent);
        this.addField((FieldEditor)this.errorMailEnabledEditor);
        this.errorMailAddressEditor = new StringFieldEditor("regiomed/errorEmailAddress", Messages.RegiomedPreferencePage_ErrorMailAddressLabel, parent);
        this.addField((FieldEditor)this.errorMailAddressEditor);
        this.hookErrorEmailBehaviour(parent);
    }

    private void hookErrorEmailBehaviour(final Composite parent) {
        this.updateErrorMailCheckboxState(parent);
        this.errorMailAddressEditor.getTextControl(parent).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegiomedPreferencePage.this.updateErrorMailCheckboxState(parent);
            }
        });
    }

    private void updateErrorMailCheckboxState(Composite parent) {
        String addr = StringUtils.trimToEmpty((String)this.errorMailAddressEditor.getStringValue());
        boolean valid = StringTool.isMailAddress((String)addr);
        Control ctrl = this.errorMailEnabledEditor.getDescriptionControl(parent);
        if (!(ctrl instanceof Button)) {
            return;
        }
        Button check = (Button)ctrl;
        check.setEnabled(valid);
        if (!valid) {
            check.setSelection(false);
        }
    }

    public boolean performOk() {
        if (!this.validateErrorEmail()) {
            return false;
        }
        return super.performOk();
    }

    private boolean validateErrorEmail() {
        boolean enabled = this.errorMailEnabledEditor.getBooleanValue();
        String addr = StringUtils.trimToEmpty((String)this.errorMailAddressEditor.getStringValue());
        if (!enabled) {
            return true;
        }
        if (addr.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.RegiomedPreferencePage_InvalidMailTitle, (String)Messages.RegiomedPreferencePage_EnterMailOrDisable);
            return false;
        }
        if (!StringTool.isMailAddress((String)addr)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.RegiomedPreferencePage_InvalidMailTitle, (String)Messages.RegiomedPreferencePage_InvalidMailMessage);
            return false;
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }
}

