/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.model;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.ui.exchange.ArticleUtil;
import ch.elexis.regiomed.order.config.RegiomedConfig;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RegiomedOrderRequest {
    @SerializedName(value="userEmail")
    private String userEmail;
    @SerializedName(value="b64Password")
    private String b64Password;
    @SerializedName(value="checkOrder")
    private boolean checkOrder;
    @SerializedName(value="deliveryType")
    private String deliveryType;
    @SerializedName(value="errorEmail")
    private String errorEmail;
    @SerializedName(value="deliveryDate")
    private String deliveryDate;
    @SerializedName(value="patinfo")
    private String patInfo;
    @SerializedName(value="sendersUniqueID")
    private String sendersUniqueID;
    @SerializedName(value="reference")
    private String reference;
    @SerializedName(value="articles")
    private List<Article> articles = new ArrayList<Article>();

    public void setCheckOrder(boolean checkOrder) {
        this.checkOrder = checkOrder;
    }

    public boolean isCheckOrder() {
        return this.checkOrder;
    }

    public static RegiomedOrderRequest fromEntries(RegiomedConfig cfg, List<IOrderEntry> entries) {
        RegiomedOrderRequest req = new RegiomedOrderRequest();
        req.userEmail = cfg.getEmail();
        req.b64Password = StringUtils.isNotBlank((CharSequence)cfg.getPassword()) ? Base64.getEncoder().encodeToString(cfg.getPassword().getBytes(StandardCharsets.UTF_8)) : null;
        req.checkOrder = cfg.isCheckOrder();
        req.deliveryType = "DEFAULT";
        req.errorEmail = cfg.isErrorEmailEnabled() && StringUtils.isNotBlank((CharSequence)cfg.getErrorEmailAddress()) && RegiomedOrderRequest.isValidEmail(cfg.getErrorEmailAddress()) ? cfg.getErrorEmailAddress().trim() : null;
        req.deliveryDate = null;
        req.patInfo = null;
        req.sendersUniqueID = null;
        req.reference = null;
        for (IOrderEntry entry : entries) {
            IArticle art = entry.getArticle();
            String pharmaCodeStr = ArticleUtil.getPharmaCode((IArticle)art);
            String eanStr = ArticleUtil.getEan((IArticle)art);
            int pharmaCode = 0;
            long eanId = 0L;
            try {
                if (StringUtils.isNotBlank((CharSequence)pharmaCodeStr)) {
                    pharmaCode = Integer.parseInt(pharmaCodeStr.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)eanStr)) {
                    eanId = Long.parseLong(eanStr.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Article a = new Article();
            a.pharmaCode = pharmaCode;
            a.eanID = eanId;
            a.description = art.getName();
            a.quantity = entry.getAmount();
            req.articles.add(a);
        }
        return req;
    }

    private static boolean isValidEmail(String value) {
        String v = StringUtils.trimToEmpty((String)value);
        int at = v.indexOf(64);
        int dot = v.lastIndexOf(46);
        return at > 0 && dot > at + 1 && dot < v.length() - 1;
    }

    public void clearPasswordForTokenAuth() {
        this.b64Password = null;
    }

    public static class Article {
        @SerializedName(value="pharmaCode")
        public int pharmaCode;
        @SerializedName(value="eanID")
        public long eanID;
        @SerializedName(value="description")
        public String description;
        @SerializedName(value="quantity")
        public int quantity;
    }

    public static class TokenData {
        @SerializedName(value="Token")
        public String token;
        @SerializedName(value="TokenRaw", alternate={"Token Raw", "tokenRaw"})
        public String tokenRaw;
    }

    public static class TokenRequestBody {
        @SerializedName(value="Email")
        public String email;
        @SerializedName(value="B64Password")
        public String b64Password;

        public TokenRequestBody(String email, String b64Password) {
            this.email = email;
            this.b64Password = b64Password;
        }
    }

    public static class TokenResponse {
        @SerializedName(value="data")
        public TokenData data;
    }
}

