/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui;

import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class RegiomedCheckTemplate {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
    private static final String CSS_STYLES = "body { font-family: 'Segoe UI', Arial, sans-serif; background-color: #f4f6f9; color: #333; margin: 0; padding: 20px; }\n.container { background: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); padding: 25px; max-width: 900px; margin: auto; }\n\n.header { border-bottom: 2px solid #005b96; padding-bottom: 15px; margin-bottom: 20px; display: flex; align-items: center; justify-content: space-between; }\n.header-left { display: flex; align-items: center; }\n.logo-img { height: 100px; margin-right: 15px; width: auto; }\n.logo-text { font-size: 24px; font-weight: bold; color: #005b96; }\n\n.status-box { padding: 10px; border-radius: 3px; margin-bottom: 10px; font-size: 14px; line-height: 1.5; }\n.status-ok { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }\n.status-warn { background-color: #fff3cd; color: #856404; border: 1px solid #ffeeba; }\n\n.hint-box {\n\tbackground-color: #e2f0fb;\n\tborder-left: 4px solid #005b96;\n\tcolor: #004085;\n\tpadding: 5px;\n\tmargin-bottom: 20px;\n\tborder-radius: 4px;\n\tfont-size: 14px;\n}\n\nh3 { margin-top: 0; color: #005b96; font-size: 18px; }\n\ntable { width: 100%; border-collapse: collapse; margin-top: 10px; font-size: 13px; }\nth { text-align: left; background: #adcacf; padding: 8px; border-bottom: 2px solid #ddd; color: #555; }\ntd { padding: 8px; border-bottom: 1px solid #eee; vertical-align: top; }\ntr:last-child td { border-bottom: none; }\n\n.badge { padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: bold; }\n.badge-ok { background: #d4edda; color: #155724; }\n.badge-error { background: #f8d7da; color: #721c24; }\n\n.section-title { margin-top: 25px; margin-bottom: 10px; font-weight: bold; color: #333; border-left: 4px solid #005b96; padding-left: 10px; }\n.warning-section { border-left-color: #dc3545; }\n\n.btn-delete {\n\tbackground-color: #fff;\n\tborder: 1px solid #dc3545;\n\tcolor: #dc3545;\n\tpadding: 4px 8px;\n\tborder-radius: 4px;\n\tcursor: pointer;\n\tfont-size: 11px;\n\tfont-weight: bold;\n\ttext-decoration: none;\n\tdisplay: inline-block;\n}\n.btn-delete:hover {\n\tbackground-color: #dc3545;\n\tcolor: white;\n}\n";
    private static final String JS_SCRIPT = "<script>\nfunction removeArticle(rowId, pharma, ean) {\n\tvar row = document.getElementById(rowId);\n\tif(row) {\n\t\trow.style.opacity = '0.3';\n\t\trow.style.textDecoration = 'line-through';\n\t\tvar btn = row.querySelector('.btn-delete');\n\t\tif(btn) btn.disabled = true;\n\t}\n\twindow.location = 'regiomed:remove:' + pharma + ':' + ean;\n}\n</script>\n";

    public static String generateHtml(RegiomedOrderResponse response) {
        String rowId;
        int i;
        StringBuilder html = new StringBuilder();
        String logoSrc = RegiomedCheckTemplate.loadLogoBase64();
        String tableHeader = RegiomedCheckTemplate.getTableHeader();
        html.append("<!DOCTYPE html><html><head><meta charset='UTF-8'>");
        html.append("<style>").append(CSS_STYLES).append("</style>");
        html.append(JS_SCRIPT);
        html.append("</head><body>");
        html.append("<div class='container'>");
        html.append("<div class='header'><div class='header-left'>");
        if (logoSrc != null) {
            html.append("<img src='").append(logoSrc).append("' class='logo-img' alt='Regiomed Logo'>");
        }
        html.append("<div class='logo-text'>").append(Messages.RegiomedCheckTemplate_OrderTitle).append("</div></div>");
        html.append("<div>").append(LocalDateTime.now().format(DATE_FORMATTER)).append("</div></div>");
        boolean hasErrors = response.articlesNOK > 0 || !response.checkSuccess;
        String statusClass = hasErrors ? "status-warn" : "status-ok";
        html.append("<div class='status-box ").append(statusClass).append("'>");
        html.append("<h3>").append(Messages.RegiomedCheckTemplate_CheckResult).append("</h3>");
        html.append("<p>").append(RegiomedCheckTemplate.escapeHtml(response.message)).append("</p>");
        html.append("</div>");
        List okItems = null;
        List nokItems = null;
        if (response.articles != null) {
            okItems = response.articles.stream().filter(a -> a.success).collect(Collectors.toList());
            nokItems = response.articles.stream().filter(a -> !a.success).collect(Collectors.toList());
        }
        if (nokItems != null && !nokItems.isEmpty()) {
            html.append("<div class='hint-box'>");
            html.append(Messages.RegiomedCheckTemplate_HintText);
            html.append("</div>");
            html.append("<div class='section-title warning-section'>").append(Messages.RegiomedCheckTemplate_ProblematicItems).append("</div>");
            html.append(tableHeader);
            i = 0;
            for (RegiomedOrderResponse.ArticleResult item : nokItems) {
                rowId = "nok_row_" + i++;
                html.append(RegiomedCheckTemplate.buildTableRow(rowId, item, true));
            }
            html.append("</tbody></table>");
        }
        if (okItems != null && !okItems.isEmpty()) {
            html.append("<div class='section-title'>").append(Messages.RegiomedCheckTemplate_AvailableItems).append("</div>");
            html.append(tableHeader);
            i = 0;
            for (RegiomedOrderResponse.ArticleResult item : okItems) {
                rowId = "ok_row_" + i++;
                html.append(RegiomedCheckTemplate.buildTableRow(rowId, item, false));
            }
            html.append("</tbody></table>");
        }
        html.append("</div></body></html>");
        return html.toString();
    }

    private static String buildTableRow(String rowId, RegiomedOrderResponse.ArticleResult item, boolean isError) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr id='").append(rowId).append("'>");
        sb.append("<td>").append(RegiomedCheckTemplate.escapeHtml(item.description)).append("<br><small style='color:#888'>").append(Messages.RegiomedCheckTemplate_PharmaLabel).append(" ").append(item.pharmaCode).append("</small></td>");
        sb.append("<td>").append(item.quantity).append("</td>");
        String colorStyle = isError ? "style='color:#dc3545'" : "";
        String infoText = item.info != null ? item.info : "";
        sb.append("<td ").append(colorStyle).append(">").append(RegiomedCheckTemplate.escapeHtml(infoText)).append("</td>");
        if (isError) {
            sb.append("<td><span class='badge badge-error'>").append(Messages.RegiomedCheckTemplate_BadgeError).append("</span></td>");
        } else {
            sb.append("<td><span class='badge badge-ok'>").append(Messages.RegiomedCheckTemplate_BadgeOk).append("</span></td>");
        }
        sb.append("<td><button class='btn-delete' onclick=\"removeArticle('").append(rowId).append("', '").append(item.pharmaCode).append("', '").append(item.eanID).append("')\">").append(Messages.RegiomedCheckTemplate_BtnDelete).append("</button></td>");
        sb.append("</tr>");
        return sb.toString();
    }

    private static String loadLogoBase64() {
        URL url;
        block14: {
            Bundle bundle;
            block13: {
                try {
                    bundle = FrameworkUtil.getBundle(RegiomedCheckTemplate.class);
                    if (bundle != null) break block13;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            url = bundle.getEntry("rsc/regiomed_logo.png");
            if (url != null) break block14;
            return null;
        }
        Throwable throwable = null;
        Object var3_5 = null;
        try (InputStream in = url.openStream();){
            byte[] imageBytes = in.readAllBytes();
            return "data:image/png;base64," + Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String escapeHtml(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private static String getTableHeader() {
        return "<table><thead><tr><th>" + Messages.RegiomedCheckTemplate_ColArticle + "</th><th>" + Messages.RegiomedCheckTemplate_ColAmount + "</th><th>" + Messages.RegiomedCheckTemplate_ColInfo + "</th><th>" + Messages.RegiomedCheckTemplate_ColStatus + "</th><th>" + Messages.RegiomedCheckTemplate_ColAction + "</th></tr></thead><tbody>";
    }
}

