/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.ui.RegiomedCheckTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RegiomedCheckDialog
extends Dialog {
    private final RegiomedOrderResponse response;
    private final Set<String> removedIdentifiers = new HashSet<String>();
    private int remainingErrors = 0;

    public RegiomedCheckDialog(Shell parentShell, RegiomedOrderResponse response) {
        super(parentShell);
        this.response = response;
        this.remainingErrors = response.articlesNOK;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RegiomedCheckDialog_Title);
        newShell.setImage(Images.IMG_LOGO.getImage());
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout(1, false));
        Browser browser = new Browser(area, 0);
        browser.setLayoutData((Object)new GridData(4, 4, true, true));
        browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                if (event.location != null && event.location.startsWith("regiomed:remove:")) {
                    String[] parts = event.location.split(":", -1);
                    if (parts.length >= 4) {
                        String key;
                        String pharma = parts[2];
                        String ean = parts[3];
                        if (StringUtils.isBlank((CharSequence)pharma)) {
                            pharma = "0";
                        }
                        if (StringUtils.isBlank((CharSequence)ean)) {
                            ean = "0";
                        }
                        if (!RegiomedCheckDialog.this.removedIdentifiers.contains(key = pharma + ":" + ean)) {
                            RegiomedCheckDialog.this.removedIdentifiers.add(key);
                            if (RegiomedCheckDialog.this.isErrorArticle(pharma, ean)) {
                                --RegiomedCheckDialog.this.remainingErrors;
                                RegiomedCheckDialog.this.updateOkButtonState();
                            }
                        }
                    }
                    event.doit = false;
                }
            }
        });
        String html = RegiomedCheckTemplate.generateHtml(this.response);
        browser.setText(html);
        return area;
    }

    public List<RegiomedOrderResponse.ArticleResult> getDeletedArticles() {
        String rowId;
        ArrayList<RegiomedOrderResponse.ArticleResult> deletedItems = new ArrayList<RegiomedOrderResponse.ArticleResult>();
        if (this.response.articles == null) {
            return deletedItems;
        }
        List okItems = this.response.articles.stream().filter(a -> a.success).collect(Collectors.toList());
        List nokItems = this.response.articles.stream().filter(a -> !a.success).collect(Collectors.toList());
        int i = 0;
        while (i < nokItems.size()) {
            rowId = "nok_row_" + i;
            if (this.removedIdentifiers.contains(rowId)) {
                deletedItems.add((RegiomedOrderResponse.ArticleResult)nokItems.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < okItems.size()) {
            rowId = "ok_row_" + i;
            if (this.removedIdentifiers.contains(rowId)) {
                deletedItems.add((RegiomedOrderResponse.ArticleResult)okItems.get(i));
            }
            ++i;
        }
        return deletedItems;
    }

    private boolean isErrorArticle(String pharmaStr, String eanStr) {
        if (this.response.articles == null) {
            return false;
        }
        for (RegiomedOrderResponse.ArticleResult item : this.response.articles) {
            String itemPharma = String.valueOf(item.pharmaCode);
            String itemEan = String.valueOf(item.eanID);
            if (StringUtils.isBlank((CharSequence)itemPharma) || "null".equals(itemPharma)) {
                itemPharma = "0";
            }
            if (StringUtils.isBlank((CharSequence)itemEan) || "null".equals(itemEan)) {
                itemEan = "0";
            }
            if (!itemPharma.equals(pharmaStr) || !itemEan.equals(eanStr)) continue;
            return !item.success;
        }
        return false;
    }

    private void updateOkButtonState() {
        this.getShell().getDisplay().asyncExec(() -> {
            Button okBtn = this.getButton(0);
            if (okBtn != null && !okBtn.isDisposed()) {
                System.out.println("Test " + this.remainingErrors);
                okBtn.setEnabled(this.remainingErrors <= 0);
            }
        });
    }

    public Set<String> getRemovedIdentifiers() {
        return this.removedIdentifiers;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button okBtn = this.createButton(parent, 0, Messages.RegiomedCheckDialog_OrderBinding, true);
        this.createButton(parent, 1, Messages.RegiomedCheckDialog_Cancel, false);
        if (this.remainingErrors > 0) {
            okBtn.setEnabled(false);
        }
    }

    protected Point getInitialSize() {
        return new Point(950, 950);
    }
}

