/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.model;

import ch.elexis.regiomed.order.messages.Messages;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;

public class RegiomedOrderResponse {
    @SerializedName(value="client")
    public String client;
    @SerializedName(value="clientID")
    public long clientID;
    @SerializedName(value="checkSuccess")
    public boolean checkSuccess;
    @SerializedName(value="message")
    public String message;
    @SerializedName(value="deliveryType")
    public String deliveryType;
    @SerializedName(value="deliveryDate")
    public String deliveryDate;
    @SerializedName(value="articleCount")
    public int articleCount;
    @SerializedName(value="articlesOK")
    public int articlesOK;
    @SerializedName(value="articlesNOK")
    public int articlesNOK;
    @SerializedName(value="orderSent")
    public boolean orderSent;
    @SerializedName(value="errorEmailSent")
    public boolean errorEmailSent;
    @SerializedName(value="user")
    public int user;
    @SerializedName(value="patInfo")
    public String patInfo;
    @SerializedName(value="reference")
    public String reference;
    @SerializedName(value="authMethod")
    public String authMethod;
    @SerializedName(value="articles")
    public List<ArticleResult> articles;

    public boolean overallSuccess() {
        if (!this.checkSuccess) {
            return false;
        }
        if (this.articlesNOK > 0) {
            return false;
        }
        if (this.articles != null) {
            return this.articles.stream().allMatch(a -> a.success);
        }
        return true;
    }

    public String buildErrorMessage() {
        List bad;
        StringBuilder sb = new StringBuilder();
        if (this.message != null && !this.message.isBlank()) {
            sb.append(this.message);
        } else {
            sb.append(Messages.RegiomedOrderResponse_GenericErrorMessage);
        }
        if (this.articles != null && !(bad = this.articles.stream().filter(a -> !a.success).collect(Collectors.toList())).isEmpty()) {
            sb.append(Messages.RegiomedOrderResponse_ProblematicArticles);
            for (ArticleResult ar : bad) {
                sb.append("[").append(ar.pharmaCode).append(" - ").append(ar.description);
                if (ar.info != null && !ar.info.isBlank()) {
                    sb.append(" (").append(ar.info).append(")");
                }
                sb.append("] ");
            }
        }
        return sb.toString();
    }

    public static class ArticleResult {
        @SerializedName(value="pharmaCode", alternate={"PharmaCode"})
        public int pharmaCode;
        @SerializedName(value="eanID", alternate={"EanID"})
        public long eanID;
        @SerializedName(value="description", alternate={"Description"})
        public String description;
        @SerializedName(value="quantity", alternate={"Quantity"})
        public int quantity;
        @SerializedName(value="success", alternate={"Success"})
        public boolean success;
        @SerializedName(value="info", alternate={"Info"})
        public String info;
    }
}

