/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.privatrechnung.model.internal;

import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.PrivatLeistung;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.privatrechnung.model.IPrivatLeistung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class Leistung
extends AbstractIdDeleteModelAdapter<PrivatLeistung>
implements IPrivatLeistung {
    private static final String CODESYSTEM_NAME = "Privat";
    private static IBillableOptifier<IPrivatLeistung> optifier;
    private static IBillableVerifier verifier;
    public static final String STS_CLASS = "ch.elexis.privatrechnung.data.Leistung";

    public Leistung(PrivatLeistung entity) {
        super((EntityWithId)entity);
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public String getCode() {
        return ((PrivatLeistung)this.getEntity()).getShortName();
    }

    public void setCode(String value) {
        ((PrivatLeistung)this.getEntityMarkDirty()).setShortName(value);
    }

    public String getText() {
        return ((PrivatLeistung)this.getEntity()).getName();
    }

    public void setText(String value) {
        ((PrivatLeistung)this.getEntityMarkDirty()).setName(value);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    public IBillableOptifier<IPrivatLeistung> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractOptifier<IPrivatLeistung>(CoreModelServiceHolder.get(), ContextServiceHolder.get()){

                protected void setPrice(IPrivatLeistung billable, IBilled billed) {
                    Optional<IBillingSystemFactor> billingFactor = this.getFactor(billed.getEncounter());
                    if (billingFactor.isPresent()) {
                        billed.setFactor(billingFactor.get().getFactor());
                    } else {
                        billed.setFactor(1.0);
                    }
                    billed.setNetPrice(billable.getNetPrice());
                    billed.setPoints(billable.getPrice().getCents());
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return BillingServiceHolder.get().getBillingSystemFactor(encounter.getCoverage().getBillingSystem().getName(), encounter.getDate());
                }
            };
        }
        return optifier;
    }

    public IBillableVerifier getVerifier() {
        if (verifier == null) {
            verifier = new DefaultVerifier();
        }
        return verifier;
    }

    @Override
    public Money getNetPrice() {
        return new Money(((PrivatLeistung)this.getEntity()).getCost());
    }

    @Override
    public Money getPrice() {
        return new Money(((PrivatLeistung)this.getEntity()).getPrice());
    }

    @Override
    public boolean isValidOn(LocalDate date) {
        boolean validFrom;
        boolean bl = validFrom = this.getValidFrom().isBefore(date) || this.getValidFrom().isEqual(date);
        if (validFrom && this.getValidTo() != null) {
            return this.getValidTo().isAfter(date) || this.getValidTo().isEqual(date);
        }
        return validFrom;
    }

    private LocalDate getValidTo() {
        return ((PrivatLeistung)this.getEntity()).getValidTo() != null ? ((PrivatLeistung)this.getEntity()).getValidTo() : LocalDate.MAX;
    }

    private LocalDate getValidFrom() {
        return ((PrivatLeistung)this.getEntity()).getValidFrom() != null ? ((PrivatLeistung)this.getEntity()).getValidFrom() : LocalDate.MIN;
    }

    @Override
    public void setParent(String string) {
        ((PrivatLeistung)this.getEntityMarkDirty()).setParent(string);
    }

    @Override
    public void setCost(String string) {
        try {
            ((PrivatLeistung)this.getEntityMarkDirty()).setCost(Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error setting cost", (Throwable)e);
        }
    }

    @Override
    public void setPrice(String string) {
        try {
            ((PrivatLeistung)this.getEntityMarkDirty()).setPrice(Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error setting price", (Throwable)e);
        }
    }

    @Override
    public void setTime(String string) {
        try {
            ((PrivatLeistung)this.getEntityMarkDirty()).setTime(Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error setting price", (Throwable)e);
        }
    }

    @Override
    public void setValidFrom(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            ((PrivatLeistung)this.getEntityMarkDirty()).setValidFrom(new TimeTool(string).toLocalDate());
        }
    }

    @Override
    public void setValidTo(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            ((PrivatLeistung)this.getEntityMarkDirty()).setValidTo(new TimeTool(string).toLocalDate());
        }
    }

    public String getLabel() {
        return this.getCode() + " - " + this.getText();
    }
}

