/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills.privat;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.arzttarife.xml.exporter.Tarmed45Exporter;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.core.utils.PlatformHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Rechnung;
import ch.elexis.pdfBills.OutputterUtil;
import ch.elexis.pdfBills.privat.ElexisPDFGenerator;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IProgressService;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.LoggerFactory;

public class PrivatQrRnOutputter
implements IRnOutputter {
    public static final String PDFDIR = "pdfdir";
    public static final String XMLDIR = "xmldir";
    public static final String CFG_ROOT = "qrpdf-output/";
    public static final String CFG_ROOT_PRIVAT = "privatqrpdf-output/";
    public static final String PLUGIN_ID = "ch.elexis.pdfBills.privat";
    public static final String CFG_MARGINLEFT = "margin.left";
    public static final String CFG_MARGINRIGHT = "margin.right";
    public static final String CFG_MARGINTOP = "margin.top";
    public static final String CFG_MARGINBOTTOM = "margin.bottom";
    public static final String CFG_BESR_MARGIN_VERTICAL = "margin.besr.vertical";
    public static final String CFG_BESR_MARGIN_HORIZONTAL = "margin.besr.horizontal";
    public static final String CFG_ESR_HEADER_1 = "qrpdf-output/esr.header.line1";
    public static final String CFG_ESR_HEADER_2 = "qrpdf-output/esr.header.line2";
    public static final String CFG_PRINT_DIRECT = "qrpdf-output/print.direct";
    public static final String CFG_PRINT_PRINTER = "qrpdf-output/print.printer";
    public static final String CFG_PRINT_TRAY = "qrpdf-output/print.tray";
    public static final String CFG_ESR_PRINT_PRINTER = "qrpdf-output/esr.print.printer";
    public static final String CFG_ESR_PRINT_TRAY = "qrpdf-output/esr.print.tray";
    public static final String CFG_PRINT_COMMAND = "qrpdf-output/print.command";
    public static final String CFG_PRINT_USE_SCRIPT = "qrpdf-output/print.usescript";
    protected static final String CFG_MAIL_CPY = "mail.copy";
    protected static final String CFG_MAIL_MANDANT_ACCOUNT = "mail.mandant.account";
    private Text tXml;
    private Text tPdf;
    private Button bWithEsr;
    private Button bWithRf;
    private Button bCopyMail;
    private boolean modifyInvoiceState;
    private boolean pdfOnly;
    private RnOutputDialog rnOutputDialog;
    private Button buttonOpen;

    public String getDescription() {
        return "Privatrechnung drucken";
    }

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        if (!props.isEmpty()) {
            this.initSelectedFromProperties(props);
        } else {
            this.modifyInvoiceState = true;
        }
        if (StringUtils.isEmpty((CharSequence)OutputterUtil.getXmlOutputDir((String)CFG_ROOT_PRIVAT))) {
            String msg = "Es ist kein XML Ausgabe-Verzeichnis konfiguriert.\nBitte konfigurieren Sie dieses in den Einstellungen.";
            SWTHelper.showError((String)"Fehler beim Rechnungsdruck", (String)msg);
            return new Result(Result.SEVERITY.ERROR, 2, msg, null, true);
        }
        if (!OutputterUtil.isPdfOutputDirValid((String)CFG_ROOT_PRIVAT)) {
            String msg = "Es ist kein PDF Ausgabe-Verzeichnis konfiguriert.\nBitte konfigurieren Sie dieses in den Einstellungen.";
            SWTHelper.showError((String)"Fehler beim Rechnungsdruck", (String)msg);
            return new Result(Result.SEVERITY.ERROR, 2, msg, null, true);
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        Result res = new Result();
        final File rsc = new File(PlatformHelper.getBasePath((String)PLUGIN_ID), "rsc");
        final StringJoiner mailErrors = new StringJoiner("\n- ", "- ", "");
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Exportiere Rechnungen...", rnn.size() * 10);
                    int errors = 0;
                    for (Rechnung rn : rnn) {
                        block23: {
                            IInvoice invoice = (IInvoice)CoreModelServiceHolder.get().load(rn.getId(), IInvoice.class).orElseThrow(() -> new IllegalStateException("Could not load invoice [" + rn.getId() + "]"));
                            XMLExporter ex = new XMLExporter();
                            Document dRn = ex.doExport(rn, null, type, true);
                            monitor.worked(1);
                            if (invoice.getState() == InvoiceState.DEFECTIVE) {
                                ++errors;
                                continue;
                            }
                            String fname = OutputterUtil.getXmlOutputDir((String)PrivatQrRnOutputter.CFG_ROOT_PRIVAT) + File.separator + invoice.getNumber() + ".xml";
                            try {
                                OutputStream fout = VirtualFilesystemServiceHolder.get().of(fname).openOutputStream();
                                OutputStreamWriter cout = new OutputStreamWriter(fout, "UTF-8");
                                XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                                xout.output(dRn, (Writer)cout);
                                cout.close();
                                fout.close();
                                ElexisPDFGenerator epdf = new ElexisPDFGenerator(fname, invoice.getNumber(), invoice.getState());
                                if (PrivatQrRnOutputter.this.pdfOnly) {
                                    epdf.setPrint(false);
                                }
                                Tarmed45Exporter.EsrType outputEsrType = ex.getEsrTypeOrFallback(invoice);
                                if ("4.5".equals(epdf.getBillVersion()) && outputEsrType != Tarmed45Exporter.EsrType.esr9) {
                                    epdf.printQrBill(rsc);
                                } else {
                                    LoggerFactory.getLogger(this.getClass()).warn("Fallback to ESR9 for xml version [" + epdf.getBillVersion() + "] and esrType [" + String.valueOf(outputEsrType) + "]");
                                    epdf.printBill(rsc);
                                }
                                if (PrivatQrRnOutputter.this.modifyInvoiceState) {
                                    int status_vorher = invoice.getState().numericValue();
                                    if (status_vorher == InvoiceState.OPEN.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_1.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_2.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_3.numericValue()) {
                                        invoice.setState(InvoiceState.fromState((int)(status_vorher + 1)));
                                    }
                                    invoice.addTrace("Ausgegeben", PrivatQrRnOutputter.this.getDescription() + ": " + invoice.getState().getLocaleText());
                                    CoreModelServiceHolder.get().save((Identifiable)invoice);
                                }
                                List<File> printed = epdf.getPrintedBill();
                                for (File pdfFile : printed) {
                                    if (!pdfFile.exists()) continue;
                                    try {
                                        Desktop.getDesktop().open(pdfFile);
                                    }
                                    catch (IOException e) {
                                        LoggerFactory.getLogger(this.getClass()).error("Error opening PDF file", (Throwable)e);
                                    }
                                }
                                if (!LocalConfigService.get((String)"qrpdf-output/mail.copy", (boolean)false) || !PrivatQrRnOutputter.this.shouldSendCopyMail(rn)) break block23;
                                Kontakt guarantor = PrivatQrRnOutputter.this.getGuarantor(rn);
                                if (guarantor != null && StringUtils.isNotBlank((CharSequence)guarantor.getMailAddress())) {
                                    String resultString;
                                    for (File pdfFile : printed) {
                                        if (!pdfFile.exists()) continue;
                                        try {
                                            Desktop.getDesktop().open(pdfFile);
                                        }
                                        catch (IOException e) {
                                            LoggerFactory.getLogger(this.getClass()).error("Error opening PDF file", (Throwable)e);
                                        }
                                    }
                                    if (!printed.isEmpty() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resultString = PrivatQrRnOutputter.this.sendAsMail(guarantor, rn, printed)})) {
                                        mailErrors.add(resultString);
                                    }
                                } else if (guarantor != null) {
                                    mailErrors.add("Keine mail Addresse f\u00fcr " + guarantor.getLabel(false));
                                } else {
                                    mailErrors.add("Keine Garant f\u00fcr Rechnung " + rn.getNr());
                                }
                            }
                            catch (IllegalStateException e) {
                                ExHandler.handle((Throwable)e);
                                SWTHelper.showError((String)"Fehler beim Rechnungsdruck", (String)("Bei der Ausgabe ist folgender Fehler aufgetreten.\n\n" + e.getMessage()));
                                invoice.reject(InvoiceState.REJECTCODE.INTERNAL_ERROR, "write error: " + fname);
                                CoreModelServiceHolder.get().save((Identifiable)invoice);
                                continue;
                            }
                            catch (Exception e1) {
                                ExHandler.handle((Throwable)e1);
                                SWTHelper.showError((String)"Fehler beim Rechnungsdruck", (String)("Konnte Datei " + fname + " nicht schreiben"));
                                invoice.reject(InvoiceState.REJECTCODE.INTERNAL_ERROR, "write error: " + fname);
                                CoreModelServiceHolder.get().save((Identifiable)invoice);
                                continue;
                            }
                        }
                        monitor.worked(1);
                    }
                    PrivatQrRnOutputter.this.pdfOnly = false;
                    monitor.done();
                    if (errors > 0) {
                        SWTHelper.alert((String)"Fehler bei der \u00dcbermittlung", (String)(Integer.toString(errors) + " Rechnungen waren fehlerhaft. Sie k\u00f6nnen diese unter Rechnungen mit dem Status fehlerhaft aufsuchen und korrigieren"));
                    } else {
                        SWTHelper.showInfo((String)"\u00dcbermittlung beendet", (String)"Es sind keine Fehler aufgetreten");
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            res.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
            ErrorDialog.openError(null, (String)"Fehler bei der Ausgabe", (String)"Konnte Rechnungsdruck nicht starten", (IStatus)ResultAdapter.getResultAsStatus((Result)res));
            return res;
        }
        if (mailErrors.length() > 2) {
            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "Fehler beim Mail-Versand", null, "Beim Mail-Versand sind folgende Fehler aufgetreten:\n" + mailErrors.toString(), 1, 0, new String[]{IDialogConstants.OK_LABEL, "als Text \u00f6ffnen"}){

                protected void buttonPressed(int buttonId) {
                    if (buttonId == 1) {
                        try {
                            Path tmpFile = Files.createTempFile("error_", "rechnung.txt", new FileAttribute[0]);
                            Throwable throwable = null;
                            Object var4_6 = null;
                            try (FileWriter fo = new FileWriter(tmpFile.toFile());){
                                fo.write(mailErrors.toString());
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            Program.launch((String)tmpFile.toString());
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error writing tmp file", (Throwable)e);
                        }
                    }
                    super.buttonPressed(buttonId);
                }
            };
            dialog.open();
        }
        return res;
    }

    private void initSelectedFromProperties(Properties props) {
        String value;
        LoggerFactory.getLogger(this.getClass()).warn("Initializing with properties " + props.toString());
        this.modifyInvoiceState = true;
        if (props.get("OutputModifyInvoiceState") instanceof String) {
            value = (String)props.get("OutputModifyInvoiceState");
            this.modifyInvoiceState = Boolean.parseBoolean(value);
        }
        if (props.get("OutputWithEsr") instanceof String) {
            value = (String)props.get("OutputWithEsr");
            LocalConfigService.set((String)"privatqrpdf-output/print.besr", (boolean)Boolean.parseBoolean(value));
        }
        if (props.get("OutputWithReclaim") instanceof String) {
            value = (String)props.get("OutputWithReclaim");
            LocalConfigService.set((String)"privatqrpdf-output/print.rf", (boolean)Boolean.parseBoolean(value));
        }
        if (props.get("OutputWithMail") instanceof String) {
            value = (String)props.get("OutputWithMail");
            LocalConfigService.set((String)"privatqrpdf-output/mail.copy", (boolean)Boolean.parseBoolean(value));
        }
    }

    private Kontakt getGuarantor(Rechnung rn) {
        IContact ret;
        IPatient patient;
        ICoverage coverage = CoreModelServiceHolder.get().load(rn.getFall().getId(), ICoverage.class).orElse(null);
        if (coverage != null && (patient = (IPatient)CoreModelServiceHolder.get().load(rn.getFall().getPatient().getId(), IPatient.class).orElse(null)) != null && (ret = XMLExporterUtil.getGuarantor((String)"TP", (IPatient)patient, (ICoverage)coverage)) != null) {
            return Kontakt.load((String)ret.getId());
        }
        return null;
    }

    private boolean shouldSendCopyMail(Rechnung rn) {
        Kontakt guarantor = this.getGuarantor(rn);
        if (guarantor != null) {
            Fall fall = rn.getFall();
            return !fall.getInvoiceRecipient().equals((Object)guarantor);
        }
        return false;
    }

    private String sendAsMail(Kontakt receiver, Rechnung rechnung, List<File> printed) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        try {
            String attachmentsString = this.getAttachmentsString(printed);
            Command sendMailCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMailNoUi");
            HashMap<String, Object> params = new HashMap<String, Object>();
            String accountid = ConfigServiceHolder.getGlobal((String)("qrpdf-output/mail.mandant.account/" + rechnung.getMandant().getId()), null);
            if (accountid != null) {
                params.put("ch.elexis.core.mail.ui.sendMailNoUi.accountid", accountid);
            }
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.mandant", rechnung.getMandant().getId());
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.to", receiver.getMailAddress());
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.attachments", attachmentsString);
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.subject", "Rechnungskopie vom " + rechnung.getDatumRn());
            params.put("ch.elexis.core.mail.ui.sendMailNoUi.text", "Anbei finden Sie eine Kopie der Rechnung vom " + rechnung.getDatumRn() + " f\u00fcr Ihre Unterlagen.\n\nBeste Gr\u00fcsse\n" + rechnung.getMandant().get("Titel") + " " + rechnung.getMandant().getVorname() + " " + rechnung.getMandant().getName());
            ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
            return (String)((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
        }
        catch (Exception me) {
            throw new RuntimeException("ch.elexis.core.mail.ui.sendMailNoUi not found", me);
        }
    }

    private String getAttachmentsString(List<File> attachments) {
        StringBuilder sb = new StringBuilder();
        for (File file : attachments) {
            if (sb.length() > 0) {
                sb.append(":::");
            }
            sb.append(file.getAbsolutePath());
        }
        return sb.toString();
    }

    public boolean canStorno(Rechnung rn) {
        return false;
    }

    public boolean canBill(Fall fall) {
        return true;
    }

    public Object createSettingsControl(Object parent) {
        final Composite compParent = (Composite)parent;
        Composite ret = new Composite(compParent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData());
        ret.setLayout((Layout)new GridLayout(2, false));
        this.bWithEsr = new Button(ret, 32);
        this.bWithEsr.setText("Mit Einzahlungsschein");
        this.bWithEsr.setSelection(LocalConfigService.get((String)"privatqrpdf-output/print.besr", (boolean)true));
        this.bWithEsr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalConfigService.set((String)"privatqrpdf-output/print.besr", (boolean)PrivatQrRnOutputter.this.bWithEsr.getSelection());
                PrivatQrRnOutputter.this.updateButtonStates(PrivatQrRnOutputter.this.rnOutputDialog);
            }
        });
        this.bWithEsr.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bWithRf = new Button(ret, 32);
        this.bWithRf.setText("Mit Rechnungsformular");
        this.bWithRf.setSelection(LocalConfigService.get((String)"privatqrpdf-output/print.rf", (boolean)true));
        this.bWithRf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalConfigService.set((String)"privatqrpdf-output/print.rf", (boolean)PrivatQrRnOutputter.this.bWithRf.getSelection());
                PrivatQrRnOutputter.this.updateButtonStates(PrivatQrRnOutputter.this.rnOutputDialog);
            }
        });
        this.bWithRf.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bCopyMail = new Button(ret, 32);
        this.bCopyMail.setText("Kopie als mail");
        this.bCopyMail.setSelection(false);
        this.bCopyMail.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        this.bCopyMail.setSelection(LocalConfigService.get((String)"privatqrpdf-output/mail.copy", (boolean)false));
        this.bCopyMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalConfigService.set((String)"privatqrpdf-output/mail.copy", (boolean)PrivatQrRnOutputter.this.bCopyMail.getSelection());
            }
        });
        Button bXML = new Button(ret, 8);
        bXML.setText("XML Verzeichnis");
        this.tXml = new Text(ret, 2056);
        this.tXml.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tXml.setText(PreferencesUtil.getOsSpecificPreference((String)"pdf-outputter/global.output.xmldir", (IConfigService)ConfigServiceHolder.get()));
        Button bPDF = new Button(ret, 8);
        bPDF.setText("PDF Verzeichnis");
        this.tPdf = new Text(ret, 2056);
        this.tPdf.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tPdf.setText(PreferencesUtil.getOsSpecificPreference((String)"pdf-outputter/global.output.pdfdir", (IConfigService)ConfigServiceHolder.get()));
        bXML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(compParent.getShell());
                String dir = dd.open();
                if (dir != null) {
                    PrivatQrRnOutputter.this.tXml.setText(dir);
                }
            }
        });
        bPDF.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(compParent.getShell());
                String dir = dd.open();
                if (dir != null) {
                    PrivatQrRnOutputter.this.tPdf.setText(dir);
                }
            }
        });
        boolean useGlobalOutputDirs = OutputterUtil.useGlobalOutputDirs();
        this.setWidgetsVisible(!useGlobalOutputDirs, new Control[]{bXML, bPDF, this.tXml, this.tPdf});
        return ret;
    }

    public void customizeDialog(Object dialog) {
        if (dialog instanceof RnOutputDialog) {
            this.rnOutputDialog = (RnOutputDialog)dialog;
            this.rnOutputDialog.setOkButtonText(Messages.Core_Print);
            this.buttonOpen = this.rnOutputDialog.addCustomButton(Messages.Core_Open);
            RowData rowData = new RowData();
            rowData.width = 91;
            rowData.height = 26;
            this.buttonOpen.setLayoutData((Object)rowData);
            this.buttonOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PrivatQrRnOutputter.this.pdfOnly = true;
                    PrivatQrRnOutputter.this.rnOutputDialog.customButtonPressed(0);
                }
            });
            this.updateButtonStates(this.rnOutputDialog);
            this.rnOutputDialog.updateSize();
            this.rnOutputDialog.redrawLayout();
        }
    }

    private void updateButtonStates(RnOutputDialog rnOutputDialog) {
        boolean isEnabled = this.bWithEsr.getSelection() || this.bWithRf.getSelection();
        rnOutputDialog.setOkButtonEnabled(this.bWithEsr.getSelection() || this.bWithRf.getSelection());
        rnOutputDialog.setButtonEnabled(Messages.Core_Open, isEnabled);
    }

    public void saveComposite() {
        LocalConfigService.set((String)"privatqrpdf-output/print.besr", (boolean)this.bWithEsr.getSelection());
        LocalConfigService.set((String)"privatqrpdf-output/print.rf", (boolean)this.bWithRf.getSelection());
        if (!OutputterUtil.useGlobalOutputDirs()) {
            LocalConfigService.set((String)"privatqrpdf-output/xmldir", (String)this.tXml.getText());
            LocalConfigService.set((String)"privatqrpdf-output/pdfdir", (String)this.tPdf.getText());
        }
        LocalConfigService.flush();
    }

    public void openOutput(IInvoice invoice, LocalDateTime timestamp, InvoiceState invoiceState) {
        try {
            File esrFile = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)CFG_ROOT_PRIVAT) + File.separator + invoice.getNumber() + "_esr.pdf").toFile().orElse(null);
            File rfFile = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)CFG_ROOT_PRIVAT) + File.separator + invoice.getNumber() + "_rf.pdf").toFile().orElse(null);
            if (esrFile.exists()) {
                Program.launch((String)esrFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + esrFile.getAbsolutePath() + "] does not exist");
            }
            if (rfFile.exists()) {
                Program.launch((String)rfFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + rfFile.getAbsolutePath() + "] does not exist");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setWidgetsVisible(boolean visible, Control ... widgets) {
        Control[] controlArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Control widget = controlArray[n2];
            widget.setVisible(visible);
            ++n2;
        }
    }
}

