/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.util;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.omnivore.data.Preferences;
import ch.elexis.omnivore.data.Utils;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.util.CategoryUtil;
import ch.elexis.omnivore.ui.Messages;
import ch.elexis.omnivore.ui.service.OmnivoreModelServiceHolder;
import ch.elexis.omnivore.ui.views.FileImportDialog;
import ch.rgw.tools.ExHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.program.Program;
import org.slf4j.LoggerFactory;

public class UiUtils {
    public static void open(IDocumentHandle handle) {
        try {
            String ext = " ";
            File temp = Utils.createTemporaryFile((IDocumentHandle)handle, (String)handle.getTitle());
            Program proggie = Program.findProgram((String)ext);
            if (proggie != null) {
                proggie.execute(temp.getAbsolutePath());
            } else if (!Program.launch((String)temp.getAbsolutePath())) {
                Runtime.getRuntime().exec(temp.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(UiUtils.class).error("Error on omnivore open", (Throwable)ex);
            SWTHelper.showError((String)Messages.DocHandle_runErrorHeading, (String)ex.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IDocumentHandle assimilate(String f, String selectedCategory) {
        act = ContextServiceHolder.get().getActivePatient().orElse(null);
        if (act == null) {
            SWTHelper.showError((String)ch.elexis.omnivore.data.Messages.DocHandle_noPatientSelected, (String)ch.elexis.omnivore.data.Messages.DocHandle_pleaseSelectPatient);
            return null;
        }
        try {
            file = VirtualFilesystemServiceHolder.get().of(f);
            if (!file.canRead()) {
                SWTHelper.showError((String)ch.elexis.omnivore.data.Messages.DocHandle_cantReadCaption, (String)String.format(ch.elexis.omnivore.data.Messages.DocHandle_cantReadMessage, new Object[]{f}));
                return null;
            }
            if (file.isDirectory()) {
                SWTHelper.showError((String)ch.elexis.omnivore.data.Messages.DocHandle_importErrorDirectory, (String)ch.elexis.omnivore.data.Messages.DocHandle_importErrorDirectoryText);
                return null;
            }
        }
        catch (IOException e) {
            SWTHelper.showError((String)ch.elexis.omnivore.data.Messages.DocHandle_importErrorDirectory, (String)e.getMessage());
            return null;
        }
        maxOmnivoreFilenameLength = Preferences.getOmnivoreMax_Filename_Length();
        nam = file.getName();
        if (nam.length() > maxOmnivoreFilenameLength) {
            SWTHelper.showError((String)ch.elexis.omnivore.data.Messages.DocHandle_importErrorCaption, (String)MessageFormat.format(ch.elexis.omnivore.data.Messages.DocHandle_importErrorMessage, new Object[]{maxOmnivoreFilenameLength}));
            return null;
        }
        fid = selectedCategory == null ? new FileImportDialog(file.getName()) : new FileImportDialog(file.getName(), selectedCategory);
        docHandle = null;
        if (fid.open() != 0) return docHandle;
        try {
            var8_9 = null;
            var9_12 = null;
            try {
                bis = file.openInputStream();
                try {
                    block25: {
                        block26: {
                            baos = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)bis, (OutputStream)baos);
                            fileName = file.getName();
                            if (fileName.length() <= 255) break block25;
                            SWTHelper.showError((String)ch.elexis.omnivore.data.Messages.DocHandle_readErrorCaption, (String)ch.elexis.omnivore.data.Messages.DocHandle_fileNameTooLong);
                            if (baos == null) break block26;
                            {
                                catch (Throwable var8_10) {
                                    throw var8_10;
                                }
                            }
                            baos.close();
                        }
                        if (bis == null) return null;
                        bis.close();
                        return null;
                    }
                    category = fid.category;
                    if (category == null || category.length() == 0) {
                        category = CategoryUtil.getDefaultCategory().getName();
                    }
                    docHandle = UiUtils.createDocHandle(category, baos.toByteArray(), act, fid.title.trim(), file.getName(), fid.keywords.trim());
                    docHandle.setLastchanged(fid.saveDate);
                    if (Preferences.getDateModifiable()) {
                        docHandle.setCreated(fid.originDate);
                    }
                    OmnivoreModelServiceHolder.get().save((Identifiable)docHandle);
                    break block27;
                }
                catch (Throwable var9_13) {
                    if (var8_9 == null) {
                        var8_9 = var9_13;
                    } else if (var8_9 != var9_13) {
                        var8_9.addSuppressed(var9_13);
                    }
                    if (bis == null) throw var8_9;
                    bis.close();
                    throw var8_9;
                }
                {
                    block27: {
                        finally {
                            if (baos != null) {
                                baos.close();
                            }
                        }
                    }
                    ** if (bis == null) goto lbl-1000
                }
lbl-1000:
                // 1 sources

                {
                    bis.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var9_14) {
                if (var8_9 == null) {
                    var8_9 = var9_14;
                    throw var8_9;
                }
                if (var8_9 == var9_14) throw var8_9;
                var8_9.addSuppressed(var9_14);
                throw var8_9;
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)ch.elexis.omnivore.data.Messages.DocHandle_importErrorCaption, (String)ch.elexis.omnivore.data.Messages.DocHandle_importErrorMessage2);
            return null;
        }
        Utils.archiveFile((IVirtualFilesystemService.IVirtualFilesystemHandle)file, (IDocumentHandle)docHandle);
        return docHandle;
    }

    /*
     * Exception decompiling
     */
    public static IDocumentHandle assimilate(String f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IDocumentHandle createDocHandle(String category, byte[] doc, IPatient pat, Date creationDate, String title, String mime, String keyw) {
        IDocumentHandle ret = (IDocumentHandle)OmnivoreModelServiceHolder.get().create(IDocumentHandle.class);
        OmnivoreModelServiceHolder.get().setEntityProperty("category", (Object)category, (Identifiable)ret);
        ret.setPatient(pat);
        ret.setCreated(creationDate);
        ret.setTitle(title);
        ret.setMimeType(mime);
        ret.setKeywords(keyw);
        ret.setContent((InputStream)new ByteArrayInputStream(doc));
        OmnivoreModelServiceHolder.get().save((Identifiable)ret);
        return ret;
    }

    private static IDocumentHandle createDocHandle(String category, byte[] doc, IPatient pat, String title, String mime, String keyw) {
        IDocumentHandle ret = (IDocumentHandle)OmnivoreModelServiceHolder.get().create(IDocumentHandle.class);
        OmnivoreModelServiceHolder.get().setEntityProperty("category", (Object)category, (Identifiable)ret);
        ret.setPatient(pat);
        ret.setTitle(title);
        ret.setMimeType(mime);
        ret.setKeywords(keyw);
        ret.setContent((InputStream)new ByteArrayInputStream(doc));
        OmnivoreModelServiceHolder.get().save((Identifiable)ret);
        return ret;
    }
}

