/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.views;

import ch.elexis.omnivore.model.IDocumentHandle;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class OmnivoreViewerComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int propertyIndex = 0;
    private int direction = 1;
    private int catDirection = -1;
    private boolean isFlat;

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
        if (column == 1) {
            this.catDirection = this.direction;
        }
    }

    public void setFlat(boolean isFlat) {
        this.isFlat = isFlat;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        boolean compareCategories = false;
        IDocumentHandle dh1 = (IDocumentHandle)e1;
        IDocumentHandle dh2 = (IDocumentHandle)e2;
        String cat1 = dh1.getCategory().getName().toLowerCase();
        String cat2 = dh2.getCategory().getName().toLowerCase();
        int rc = 0;
        switch (this.propertyIndex) {
            case 1: {
                rc = cat1.compareTo(cat2);
                break;
            }
            case 2: {
                if (cat1.equals(cat2) || this.isFlat) {
                    rc = dh1.getLastchanged().compareTo(dh2.getLastchanged());
                    break;
                }
                compareCategories = true;
                break;
            }
            case 3: {
                if (cat1.equals(cat2) || this.isFlat) {
                    rc = dh1.getCreated().compareTo(dh2.getCreated());
                    break;
                }
                compareCategories = true;
                break;
            }
            case 4: {
                if (cat1.equals(cat2) || this.isFlat) {
                    String t1 = dh1.getTitle().toLowerCase();
                    String t2 = dh2.getTitle().toLowerCase();
                    rc = t1.compareTo(t2);
                    break;
                }
                compareCategories = true;
                break;
            }
            case 5: {
                if (cat1.equals(cat2) || this.isFlat) {
                    String k1 = dh1.getKeywords().toLowerCase();
                    String k2 = dh2.getKeywords().toLowerCase();
                    rc = k1.compareTo(k2);
                    break;
                }
                compareCategories = true;
                break;
            }
            default: {
                rc = 0;
            }
        }
        if (compareCategories) {
            rc = cat1.compareTo(cat2);
            if (this.catDirection == 1) {
                rc = -rc;
            }
            return rc;
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public int getDirectionDigit() {
        return this.direction;
    }

    public int getCategoryDirection() {
        return this.catDirection;
    }

    public void setCategoryDirection(int catDirection) {
        this.catDirection = catDirection;
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }
}

