/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.inbox;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.ui.part.provider.IInboxElementUiProvider;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.ui.inbox.DocHandleLabelProvider;
import ch.elexis.omnivore.ui.inbox.DocHandleViewerFilter;
import ch.elexis.omnivore.ui.util.UiUtils;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DocHandleUiProvider
implements IInboxElementUiProvider {
    private DocHandleLabelProvider labelProvider = new DocHandleLabelProvider();
    private DocHandleViewerFilter filter = new DocHandleViewerFilter();

    public ImageDescriptor getFilterImage(ViewerFilter filter) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.omnivore.ui", (String)"icons/fressen.gif");
    }

    public List<ViewerFilter> getFilters() {
        return Collections.singletonList(this.filter);
    }

    public LabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IColorProvider getColorProvider() {
        return null;
    }

    public IToolTipProvider getToolTipProvider() {
        return null;
    }

    public LocalDate getObjectDate(IInboxElement element) {
        if (element.getObject() instanceof IDocumentHandle) {
            return TimeUtil.toLocalDate((Date)((IDocumentHandle)element.getObject()).getCreated());
        }
        return null;
    }

    public boolean isProviderFor(IInboxElement element) {
        Object obj = element.getObject();
        return obj instanceof IDocumentHandle;
    }

    public void doubleClicked(IInboxElement element) {
        Object obj = element.getObject();
        if (this.isProviderFor(element)) {
            IDocumentHandle document = (IDocumentHandle)obj;
            UiUtils.open(document);
        }
    }

    public void singleClicked(IInboxElement element) {
        IDocumentHandle document;
        Object obj = element.getObject();
        if (this.isProviderFor(element) && (document = (IDocumentHandle)obj) != null && !document.isCategory()) {
            ContextServiceHolder.get().postEvent("ui/preview/mimetype/application/pdf", (Object)document);
        }
    }
}

